/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.input.parse;

import com.thaiopensource.datatype.DatatypeLibraryLoader;
import com.thaiopensource.relaxng.edit.NameClass;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.edit.SourceLocation;
import com.thaiopensource.relaxng.input.InputFailedException;
import com.thaiopensource.relaxng.input.InputFormat;
import com.thaiopensource.relaxng.input.parse.AnnotationsImpl;
import com.thaiopensource.relaxng.input.parse.CommentListImpl;
import com.thaiopensource.relaxng.input.parse.ElementAnnotationBuilderImpl;
import com.thaiopensource.relaxng.input.parse.SchemaBuilderImpl;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.Parseable;
import com.thaiopensource.relaxng.translate.util.EncodingParam;
import com.thaiopensource.relaxng.translate.util.InvalidParamsException;
import com.thaiopensource.relaxng.translate.util.ParamProcessor;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.resolver.xml.sax.SAXResolver;
import java.io.IOException;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class ParseInputFormat
implements InputFormat {
    private final boolean commentsNeedTrimming;

    protected ParseInputFormat(boolean bl) {
        this.commentsNeedTrimming = bl;
    }

    @Override
    public SchemaCollection load(String string, String[] stringArray, String string2, ErrorHandler errorHandler, Resolver resolver) throws InputFailedException, InvalidParamsException, IOException, SAXException {
        final InputSource inputSource = new InputSource(string);
        ParamProcessor paramProcessor = new ParamProcessor();
        paramProcessor.declare("encoding", new EncodingParam(){

            @Override
            protected void setEncoding(String string) {
                inputSource.setEncoding(string);
            }
        });
        paramProcessor.process(stringArray, errorHandler);
        Parseable<Pattern, NameClass, SourceLocation, ElementAnnotationBuilderImpl, CommentListImpl, AnnotationsImpl> parseable = this.makeParseable(inputSource, new SAXResolver(resolver), errorHandler);
        try {
            return SchemaBuilderImpl.parse(parseable, string, errorHandler, new DatatypeLibraryLoader(), this.commentsNeedTrimming);
        }
        catch (IllegalSchemaException illegalSchemaException) {
            throw new InputFailedException();
        }
    }

    protected abstract Parseable<Pattern, NameClass, SourceLocation, ElementAnnotationBuilderImpl, CommentListImpl, AnnotationsImpl> makeParseable(InputSource var1, SAXResolver var2, ErrorHandler var3) throws SAXException;
}

