/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.rnc;

import com.thaiopensource.relaxng.edit.Annotated;
import com.thaiopensource.relaxng.edit.AnnotationChild;
import com.thaiopensource.relaxng.edit.AnnotationChildVisitor;
import com.thaiopensource.relaxng.edit.AnyNameNameClass;
import com.thaiopensource.relaxng.edit.AttributeAnnotation;
import com.thaiopensource.relaxng.edit.AttributePattern;
import com.thaiopensource.relaxng.edit.ChoiceNameClass;
import com.thaiopensource.relaxng.edit.ChoicePattern;
import com.thaiopensource.relaxng.edit.Combine;
import com.thaiopensource.relaxng.edit.Comment;
import com.thaiopensource.relaxng.edit.Component;
import com.thaiopensource.relaxng.edit.ComponentVisitor;
import com.thaiopensource.relaxng.edit.CompositePattern;
import com.thaiopensource.relaxng.edit.Container;
import com.thaiopensource.relaxng.edit.DataPattern;
import com.thaiopensource.relaxng.edit.DefineComponent;
import com.thaiopensource.relaxng.edit.DivComponent;
import com.thaiopensource.relaxng.edit.ElementAnnotation;
import com.thaiopensource.relaxng.edit.ElementPattern;
import com.thaiopensource.relaxng.edit.EmptyPattern;
import com.thaiopensource.relaxng.edit.ExternalRefPattern;
import com.thaiopensource.relaxng.edit.GrammarPattern;
import com.thaiopensource.relaxng.edit.GroupPattern;
import com.thaiopensource.relaxng.edit.IncludeComponent;
import com.thaiopensource.relaxng.edit.InterleavePattern;
import com.thaiopensource.relaxng.edit.ListPattern;
import com.thaiopensource.relaxng.edit.MixedPattern;
import com.thaiopensource.relaxng.edit.NameClass;
import com.thaiopensource.relaxng.edit.NameClassVisitor;
import com.thaiopensource.relaxng.edit.NameClassedPattern;
import com.thaiopensource.relaxng.edit.NameNameClass;
import com.thaiopensource.relaxng.edit.NamespaceContext;
import com.thaiopensource.relaxng.edit.NotAllowedPattern;
import com.thaiopensource.relaxng.edit.NsNameNameClass;
import com.thaiopensource.relaxng.edit.OneOrMorePattern;
import com.thaiopensource.relaxng.edit.OptionalPattern;
import com.thaiopensource.relaxng.edit.Param;
import com.thaiopensource.relaxng.edit.ParentRefPattern;
import com.thaiopensource.relaxng.edit.Pattern;
import com.thaiopensource.relaxng.edit.PatternVisitor;
import com.thaiopensource.relaxng.edit.RefPattern;
import com.thaiopensource.relaxng.edit.SourceLocation;
import com.thaiopensource.relaxng.edit.TextAnnotation;
import com.thaiopensource.relaxng.edit.TextPattern;
import com.thaiopensource.relaxng.edit.UnaryPattern;
import com.thaiopensource.relaxng.edit.ValuePattern;
import com.thaiopensource.relaxng.edit.VoidVisitor;
import com.thaiopensource.relaxng.edit.ZeroOrMorePattern;
import com.thaiopensource.relaxng.output.OutputDirectory;
import com.thaiopensource.relaxng.output.common.ErrorReporter;
import com.thaiopensource.relaxng.output.rnc.ComplexityCache;
import com.thaiopensource.relaxng.output.rnc.NamespaceManager;
import com.thaiopensource.relaxng.output.rnc.Prettyprinter;
import com.thaiopensource.relaxng.output.rnc.StreamingPrettyprinter;
import com.thaiopensource.relaxng.parse.SchemaBuilder;
import com.thaiopensource.util.Utf16;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.xml.out.CharRepertoire;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

class Output {
    private final Prettyprinter pp;
    private final CharRepertoire cr;
    private final String indent;
    private final String sourceUri;
    private final OutputDirectory od;
    private final ErrorReporter er;
    private final NamespaceManager.NamespaceBindings nsb;
    private final Map<String, String> datatypeLibraryMap = new HashMap<String, String>();
    private final ComplexityCache complexityCache = new ComplexityCache();
    private final NameClassVisitor<VoidValue> nameClassOutput = new NameClassOutput(true);
    private final NameClassVisitor<VoidValue> noParenNameClassOutput = new NameClassOutput(false);
    private final PatternVisitor<VoidValue> noParenPatternOutput = new PatternOutput(false);
    private final PatternVisitor<VoidValue> patternOutput = new PatternOutput(true);
    private final PatternVisitor<VoidValue> repeatedPatternOutput = new RepeatedPatternOutput();
    private final ComponentVisitor<VoidValue> componentOutput = new ComponentOutput();
    private final AnnotationChildVisitor<VoidValue> annotationChildOutput = new AnnotationChildOutput();
    private final AnnotationChildVisitor<VoidValue> followingAnnotationChildOutput = new FollowingAnnotationChildOutput();
    private boolean isAttributeNameClass;
    private final StringBuffer encodeBuf = new StringBuffer();
    private static final String[] keywords = new String[]{"attribute", "default", "datatypes", "div", "element", "empty", "external", "grammar", "include", "inherit", "list", "mixed", "namespace", "notAllowed", "parent", "start", "string", "text", "token"};
    private static final Set<String> keywordSet = new HashSet<String>();
    private static final String[] delims;

    static void output(Pattern pattern, String string, String string2, OutputDirectory outputDirectory, ErrorReporter errorReporter) throws IOException {
        try {
            new Output(string2, string, outputDirectory, errorReporter, NamespaceVisitor.createBindings(pattern)).topLevel(pattern);
        }
        catch (Prettyprinter.WrappedException wrappedException) {
            throw wrappedException.getIOException();
        }
    }

    private Output(String string, String string2, OutputDirectory outputDirectory, ErrorReporter errorReporter, NamespaceManager.NamespaceBindings namespaceBindings) throws IOException {
        this.sourceUri = string;
        this.od = outputDirectory;
        this.er = errorReporter;
        if (!(string2 == null || string2.equalsIgnoreCase("UTF-8") || string2.equalsIgnoreCase("UTF-16") || string2.equalsIgnoreCase("US-ASCII"))) {
            string2 = null;
        }
        OutputDirectory.Stream stream = outputDirectory.open(string, string2);
        this.cr = stream.getCharRepertoire();
        this.pp = new StreamingPrettyprinter(outputDirectory.getLineLength(), outputDirectory.getLineSeparator(), stream.getWriter());
        this.nsb = namespaceBindings;
        char[] cArray = new char[outputDirectory.getIndent()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = 32;
        }
        this.indent = new String(cArray);
    }

    private void topLevel(Pattern pattern) {
        boolean bl;
        pattern.accept(new TextAnnotationMerger());
        boolean bl2 = bl = pattern instanceof GrammarPattern && pattern.getAttributeAnnotations().isEmpty();
        if (bl && !pattern.getLeadingComments().isEmpty()) {
            this.leadingComments(pattern);
            this.pp.hardNewline();
        }
        this.outputNamespaceDeclarations();
        this.outputDatatypeLibraryDeclarations(pattern);
        if (bl) {
            for (AnnotationChild annotationChild : pattern.getChildElementAnnotations()) {
                annotationChild.accept(this.annotationChildOutput);
                this.pp.hardNewline();
            }
            this.innerBody(((GrammarPattern)pattern).getComponents());
            for (AnnotationChild annotationChild : pattern.getFollowingElementAnnotations()) {
                this.pp.hardNewline();
                annotationChild.accept(this.annotationChildOutput);
            }
        } else {
            pattern.accept(this.patternOutput);
        }
        this.pp.close();
    }

    private void outputNamespaceDeclarations() {
        Vector<String> vector = new Vector<String>();
        vector.addAll(this.nsb.getPrefixes());
        Collections.sort(vector);
        boolean bl = false;
        String string = null;
        String string2 = this.nsb.getNamespaceUri("");
        if (string2 != null && !string2.equals(SchemaBuilder.INHERIT_NS)) {
            string = this.nsb.getNonEmptyPrefix(string2);
        }
        for (String string3 : vector) {
            String string4 = this.nsb.getNamespaceUri(string3);
            if (string3.length() == 0) {
                if (string != null || string4.equals(SchemaBuilder.INHERIT_NS)) continue;
                this.pp.startGroup();
                this.pp.text("default namespace =");
                this.pp.startNest(this.indent);
                this.pp.softNewline(" ");
                this.literal(string4);
                this.pp.endNest();
                this.pp.endGroup();
                this.pp.hardNewline();
                bl = true;
                continue;
            }
            if (string3.equals("xml")) continue;
            this.pp.startGroup();
            if (string3.equals(string)) {
                this.pp.text("default namespace ");
            } else {
                this.pp.text("namespace ");
            }
            this.encodedText(string3);
            this.pp.text(" =");
            this.pp.startNest(this.indent);
            this.pp.softNewline(" ");
            if (string4.equals(SchemaBuilder.INHERIT_NS)) {
                this.pp.text("inherit");
            } else {
                this.literal(string4);
            }
            this.pp.endNest();
            this.pp.endGroup();
            this.pp.hardNewline();
            bl = true;
        }
        if (bl) {
            this.pp.hardNewline();
        }
    }

    private void outputDatatypeLibraryDeclarations(Pattern pattern) {
        this.datatypeLibraryMap.put("http://www.w3.org/2001/XMLSchema-datatypes", "xsd");
        Vector<String> vector = new Vector<String>();
        vector.addAll(DatatypeLibraryVisitor.findDatatypeLibraries(pattern));
        if (vector.isEmpty()) {
            return;
        }
        Collections.sort(vector);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string = "d";
            if (n > 1) {
                string = string + Integer.toString(i + 1);
            }
            String string2 = (String)vector.get(i);
            this.datatypeLibraryMap.put(string2, string);
            this.pp.startGroup();
            this.pp.text("datatypes ");
            this.encodedText(string);
            this.pp.text(" =");
            this.pp.startNest(this.indent);
            this.pp.softNewline(" ");
            this.literal(string2);
            this.pp.endNest();
            this.pp.endGroup();
            this.pp.hardNewline();
        }
        this.pp.hardNewline();
    }

    private static boolean hasAnnotations(Annotated annotated) {
        return !annotated.getChildElementAnnotations().isEmpty() || !annotated.getAttributeAnnotations().isEmpty() || !annotated.getFollowingElementAnnotations().isEmpty();
    }

    private boolean startAnnotations(Annotated annotated) {
        int n;
        if (!annotated.getLeadingComments().isEmpty()) {
            this.leadingComments(annotated);
            if (!Output.hasAnnotations(annotated)) {
                return false;
            }
        } else if (!Output.hasAnnotations(annotated)) {
            return false;
        }
        List<AnnotationChild> list = annotated.mayContainText() ? annotated.getFollowingElementAnnotations() : annotated.getChildElementAnnotations();
        int n2 = list.size();
        for (n = 0; n < n2; ++n) {
            String string;
            int n3 = n;
            if (n != 0) {
                while (list.get(n3) instanceof Comment && ++n3 < n2) {
                }
                if (n3 >= n2) break;
            }
            if ((string = Output.documentationString(list.get(n3))) == null) break;
            if (n3 == n) {
                this.pp.hardNewline();
            } else {
                while (true) {
                    list.get(n).accept(this.annotationChildOutput);
                    if (++n == n3) break;
                    this.pp.hardNewline();
                }
            }
            this.comment("##", string);
        }
        if (n > 0) {
            list = list.subList(n, n2);
        }
        this.pp.startGroup();
        if (!annotated.getAttributeAnnotations().isEmpty() || !list.isEmpty()) {
            if (!annotated.getAttributeAnnotations().isEmpty()) {
                this.checkContext(annotated.getContext(), annotated.getSourceLocation());
            }
            this.annotationBody(annotated.getAttributeAnnotations(), list);
            this.pp.softNewline(" ");
        }
        return true;
    }

    private static String documentationString(AnnotationChild annotationChild) {
        if (!(annotationChild instanceof ElementAnnotation)) {
            return null;
        }
        ElementAnnotation elementAnnotation = (ElementAnnotation)annotationChild;
        if (!elementAnnotation.getLocalName().equals("documentation")) {
            return null;
        }
        if (!elementAnnotation.getNamespaceUri().equals("http://relaxng.org/ns/compatibility/annotations/1.0")) {
            return null;
        }
        if (!elementAnnotation.getAttributes().isEmpty()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (AnnotationChild annotationChild2 : elementAnnotation.getChildren()) {
            if (!(annotationChild2 instanceof TextAnnotation)) {
                return null;
            }
            stringBuffer.append(((TextAnnotation)annotationChild2).getValue());
        }
        return stringBuffer.toString();
    }

    private void endAnnotations(Annotated annotated) {
        if (!annotated.mayContainText()) {
            for (AnnotationChild annotationChild : annotated.getFollowingElementAnnotations()) {
                if (annotated instanceof Component) {
                    this.pp.hardNewline();
                } else {
                    this.pp.softNewline(" ");
                }
                AnnotationChildVisitor<VoidValue> annotationChildVisitor = annotated instanceof Component ? this.annotationChildOutput : this.followingAnnotationChildOutput;
                annotationChild.accept(annotationChildVisitor);
            }
        }
        if (Output.hasAnnotations(annotated)) {
            this.pp.endGroup();
        }
    }

    private void leadingComments(Annotated annotated) {
        boolean bl = true;
        for (Comment comment : annotated.getLeadingComments()) {
            if (!bl) {
                this.pp.hardNewline();
            } else {
                bl = false;
            }
            comment.accept(this.annotationChildOutput);
        }
    }

    private void annotationBody(List<AttributeAnnotation> list, List<AnnotationChild> list2) {
        this.pp.startGroup();
        this.pp.text("[");
        this.pp.startNest(this.indent);
        for (AttributeAnnotation sourceObject : list) {
            this.pp.softNewline(" ");
            this.pp.startGroup();
            this.qualifiedName(sourceObject.getNamespaceUri(), sourceObject.getPrefix(), sourceObject.getLocalName(), true);
            this.pp.text(" =");
            this.pp.startNest(this.indent);
            this.pp.softNewline(" ");
            this.literal(sourceObject.getValue());
            this.pp.endNest();
            this.pp.endGroup();
        }
        for (AnnotationChild annotationChild : list2) {
            this.pp.softNewline(" ");
            annotationChild.accept(this.annotationChildOutput);
        }
        this.pp.endNest();
        this.pp.softNewline(" ");
        this.pp.text("]");
        this.pp.endGroup();
    }

    private void body(Container container) {
        this.body(container.getComponents());
    }

    private void body(List<Component> list) {
        if (list.size() == 0) {
            this.pp.text(" { }");
        } else {
            this.pp.text(" {");
            this.pp.startNest(this.indent);
            this.pp.hardNewline();
            this.innerBody(list);
            this.pp.endNest();
            this.pp.hardNewline();
            this.pp.text("}");
        }
    }

    private void innerBody(List<Component> list) {
        boolean bl = true;
        for (Component component : list) {
            if (bl) {
                bl = false;
            } else {
                this.pp.hardNewline();
            }
            component.accept(this.componentOutput);
        }
    }

    private void inherit(String string) {
        if (string.equals(this.nsb.getNamespaceUri(""))) {
            return;
        }
        this.pp.softNewline(" ");
        this.pp.text("inherit = ");
        this.encodedText(this.nsb.getNonEmptyPrefix(string));
    }

    private void identifier(String string) {
        if (keywordSet.contains(string)) {
            this.pp.text("\\");
        }
        this.encodedText(string);
    }

    private void literal(String string) {
        int n;
        int n2 = 0;
        int n3 = string.length();
        do {
            String string2 = null;
            n = -1;
            int n4 = string.indexOf(10, n2);
            n4 = n4 < 0 ? n3 : ++n4;
            for (int i = 0; i < delims.length; ++i) {
                int n5 = (string + delims[i]).indexOf(delims[i], n2);
                if (n5 <= n) continue;
                string2 = delims[i];
                n = n5;
                if (n5 < n4) continue;
                n = n4;
                break;
            }
            if (n2 != 0) {
                this.pp.text(" ~");
                this.pp.softNewline(" ");
            }
            this.pp.text(string2);
            this.encodedText(string.substring(n2, n));
            this.pp.text(string2);
        } while ((n2 = n) != n3);
    }

    private void encodedText(String string) {
        this.pp.text(this.encode(string));
    }

    private String encode(String string) {
        int n = 0;
        int n2 = string.length();
        block4: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\\': {
                    if (!Output.startsWithEscapeOpen(string, i)) continue block4;
                }
                case '\n': 
                case '\r': {
                    if (n < i) {
                        this.encodeBuf.append(string.substring(n, i));
                    }
                    this.escape(c);
                    n = i + 1;
                    continue block4;
                }
                default: {
                    if (Utf16.isSurrogate(c)) {
                        if (!this.cr.contains(c, string.charAt(i + 1))) {
                            if (n < i) {
                                this.encodeBuf.append(string.substring(n, i));
                            }
                            this.escape(Utf16.scalarValue(c, string.charAt(i + 1)));
                            n = i + 2;
                        }
                        ++i;
                        continue block4;
                    }
                    if (this.cr.contains(c)) continue block4;
                    if (n < i) {
                        this.encodeBuf.append(string.substring(n, i));
                    }
                    this.escape(c);
                    n = i + 1;
                }
            }
        }
        if (n == 0) {
            return string;
        }
        if (n != n2) {
            this.encodeBuf.append(string.substring(n, n2));
        }
        string = this.encodeBuf.toString();
        this.encodeBuf.setLength(0);
        return string;
    }

    private void escape(int n) {
        this.encodeBuf.append("\\x{");
        this.encodeBuf.append(Integer.toHexString(n));
        this.encodeBuf.append("}");
    }

    private static boolean startsWithEscapeOpen(String string, int n) {
        if (!string.startsWith("\\x", n)) {
            return false;
        }
        n += 2;
        while (string.startsWith("x", n)) {
            ++n;
        }
        return string.startsWith("{", n);
    }

    private void qualifiedName(String string, String string2, String string3, boolean bl) {
        if ((string2 = this.choosePrefix(string, string2, bl)) == null) {
            this.encodedText(string3);
        } else {
            this.encodedText(string2);
            this.pp.text(":");
            this.encodedText(string3);
        }
    }

    private String choosePrefix(String string, String string2, boolean bl) {
        if (string2 != null && string.equals(this.nsb.getNamespaceUri(string2))) {
            return string2;
        }
        if (bl ? string.length() == 0 : string.equals(this.nsb.getNamespaceUri(""))) {
            return null;
        }
        return this.nsb.getNonEmptyPrefix(string);
    }

    private void comment(String string, String string2) {
        int n = 0;
        while (true) {
            int n2;
            this.pp.text(string);
            if (n < string2.length() && string2.charAt(n) != '\t') {
                this.pp.text(" ");
            }
            String string3 = (n2 = string2.indexOf(10, n)) < 0 ? string2.substring(n) : string2.substring(n, n2);
            this.encodedText(string3);
            this.pp.hardNewline();
            if (n2 < 0) break;
            n = n2 + 1;
        }
    }

    private void checkContext(NamespaceContext namespaceContext, SourceLocation sourceLocation) {
        if (namespaceContext == null) {
            return;
        }
        for (String string : namespaceContext.getPrefixes()) {
            String string2;
            if (string.equals("") || (string2 = namespaceContext.getNamespace(string)) == null || string2.equals(SchemaBuilder.INHERIT_NS) || this.nsb.getNamespaceUri(string).equals(string2)) continue;
            this.er.warning("annotation_inconsistent_binding", string, string2, sourceLocation);
        }
    }

    static {
        for (int i = 0; i < keywords.length; ++i) {
            keywordSet.add(keywords[i]);
        }
        delims = new String[]{"\"", "'", "\"\"\"", "'''"};
    }

    class FollowingAnnotationChildOutput
    extends AnnotationChildOutput {
        FollowingAnnotationChildOutput() {
        }

        @Override
        public VoidValue visitElement(ElementAnnotation elementAnnotation) {
            Output.this.pp.text(">> ");
            Output.this.pp.startNest(">> ");
            super.visitElement(elementAnnotation);
            Output.this.pp.endNest();
            return VoidValue.VOID;
        }
    }

    class AnnotationChildOutput
    implements AnnotationChildVisitor<VoidValue> {
        AnnotationChildOutput() {
        }

        @Override
        public VoidValue visitText(TextAnnotation textAnnotation) {
            Output.this.literal(textAnnotation.getValue());
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitComment(Comment comment) {
            Output.this.comment("#", comment.getValue());
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitElement(ElementAnnotation elementAnnotation) {
            Output.this.checkContext(elementAnnotation.getContext(), elementAnnotation.getSourceLocation());
            Output.this.qualifiedName(elementAnnotation.getNamespaceUri(), elementAnnotation.getPrefix(), elementAnnotation.getLocalName(), true);
            Output.this.pp.text(" ");
            Output.this.annotationBody(elementAnnotation.getAttributes(), elementAnnotation.getChildren());
            return VoidValue.VOID;
        }
    }

    class NameClassOutput
    implements NameClassVisitor<VoidValue> {
        private final boolean alwaysUseParens;

        NameClassOutput(boolean bl) {
            this.alwaysUseParens = bl;
        }

        @Override
        public VoidValue visitAnyName(AnyNameNameClass anyNameNameClass) {
            NameClass nameClass = anyNameNameClass.getExcept();
            if (nameClass == null) {
                Output.this.startAnnotations(anyNameNameClass);
                Output.this.pp.text("*");
            } else {
                boolean bl = Output.this.startAnnotations(anyNameNameClass) || this.alwaysUseParens;
                String string = bl ? "(* - " : "* - ";
                Output.this.pp.text(string);
                Output.this.pp.startNest(string);
                nameClass.accept(Output.this.nameClassOutput);
                if (bl) {
                    Output.this.pp.text(")");
                }
                Output.this.pp.endNest();
            }
            Output.this.endAnnotations(anyNameNameClass);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitNsName(NsNameNameClass nsNameNameClass) {
            NameClass nameClass = nsNameNameClass.getExcept();
            String string = Output.this.nsb.getNonEmptyPrefix(nsNameNameClass.getNs());
            if (nameClass == null) {
                Output.this.startAnnotations(nsNameNameClass);
                Output.this.encodedText(string);
                Output.this.pp.text(":*");
            } else {
                boolean bl = Output.this.startAnnotations(nsNameNameClass) || this.alwaysUseParens;
                String string2 = bl ? "(" : "";
                string2 = string2 + Output.this.encode(string);
                string2 = string2 + ":* - ";
                Output.this.pp.text(string2);
                Output.this.pp.startNest(string2);
                nameClass.accept(Output.this.nameClassOutput);
                Output.this.pp.endNest();
                if (bl) {
                    Output.this.pp.text(")");
                }
            }
            Output.this.endAnnotations(nsNameNameClass);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitName(NameNameClass nameNameClass) {
            Output.this.startAnnotations(nameNameClass);
            Output.this.qualifiedName(nameNameClass.getNamespaceUri(), nameNameClass.getPrefix(), nameNameClass.getLocalName(), Output.this.isAttributeNameClass);
            Output.this.endAnnotations(nameNameClass);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitChoice(ChoiceNameClass choiceNameClass) {
            boolean bl = this.alwaysUseParens;
            if (Output.this.startAnnotations(choiceNameClass)) {
                bl = true;
            } else if (choiceNameClass.getChildren().size() == 1) {
                bl = false;
            }
            if (bl) {
                Output.this.pp.text("(");
                Output.this.pp.startNest("(");
            }
            Output.this.pp.startGroup();
            boolean bl2 = true;
            for (NameClass nameClass : choiceNameClass.getChildren()) {
                if (bl2) {
                    bl2 = false;
                } else {
                    Output.this.pp.softNewline(" ");
                    Output.this.pp.text("| ");
                }
                nameClass.accept(Output.this.nameClassOutput);
            }
            Output.this.pp.endGroup();
            if (bl) {
                Output.this.pp.endNest();
                Output.this.pp.text(")");
            }
            Output.this.endAnnotations(choiceNameClass);
            return VoidValue.VOID;
        }
    }

    class PatternOutput
    implements PatternVisitor<VoidValue> {
        private final boolean alwaysUseParens;

        PatternOutput(boolean bl) {
            this.alwaysUseParens = bl;
        }

        @Override
        public VoidValue visitGrammar(GrammarPattern grammarPattern) {
            Output.this.startAnnotations(grammarPattern);
            Output.this.pp.text("grammar");
            Output.this.body(grammarPattern);
            Output.this.endAnnotations(grammarPattern);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitElement(ElementPattern elementPattern) {
            Output.this.isAttributeNameClass = false;
            this.nameClassed(elementPattern, "element ");
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitAttribute(AttributePattern attributePattern) {
            Output.this.isAttributeNameClass = true;
            this.nameClassed(attributePattern, "attribute ");
            return VoidValue.VOID;
        }

        private void nameClassed(NameClassedPattern nameClassedPattern, String string) {
            Output.this.startAnnotations(nameClassedPattern);
            Output.this.pp.text(string);
            Output.this.pp.startNest(string);
            nameClassedPattern.getNameClass().accept(Output.this.noParenNameClassOutput);
            Output.this.pp.endNest();
            this.braceChild(nameClassedPattern);
            Output.this.endAnnotations(nameClassedPattern);
        }

        private void braceChild(UnaryPattern unaryPattern) {
            boolean bl;
            Pattern pattern = unaryPattern.getChild();
            boolean bl2 = bl = !Output.this.complexityCache.isComplex(pattern);
            if (bl) {
                Output.this.pp.startGroup();
            }
            Output.this.pp.text(" {");
            Output.this.pp.startNest(Output.this.indent);
            if (bl) {
                Output.this.pp.softNewline(" ");
            } else {
                Output.this.pp.hardNewline();
            }
            pattern.accept(Output.this.noParenPatternOutput);
            Output.this.pp.endNest();
            if (bl) {
                Output.this.pp.softNewline(" ");
            } else {
                Output.this.pp.hardNewline();
            }
            Output.this.pp.text("}");
            if (bl) {
                Output.this.pp.endGroup();
            }
        }

        @Override
        public VoidValue visitOneOrMore(OneOrMorePattern oneOrMorePattern) {
            this.postfix(oneOrMorePattern, "+");
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitZeroOrMore(ZeroOrMorePattern zeroOrMorePattern) {
            this.postfix(zeroOrMorePattern, "*");
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitOptional(OptionalPattern optionalPattern) {
            this.postfix(optionalPattern, "?");
            return VoidValue.VOID;
        }

        protected void postfix(UnaryPattern unaryPattern, String string) {
            if (!Output.this.startAnnotations(unaryPattern)) {
                unaryPattern.getChild().accept(Output.this.repeatedPatternOutput);
                Output.this.pp.text(string);
            } else {
                Output.this.pp.text("(");
                Output.this.pp.startNest("(");
                unaryPattern.getChild().accept(Output.this.repeatedPatternOutput);
                Output.this.pp.endNest();
                Output.this.pp.text(string);
                Output.this.pp.text(")");
            }
            Output.this.endAnnotations(unaryPattern);
        }

        @Override
        public VoidValue visitRef(RefPattern refPattern) {
            Output.this.startAnnotations(refPattern);
            Output.this.identifier(refPattern.getName());
            Output.this.endAnnotations(refPattern);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitParentRef(ParentRefPattern parentRefPattern) {
            Output.this.startAnnotations(parentRefPattern);
            Output.this.pp.text("parent ");
            Output.this.identifier(parentRefPattern.getName());
            Output.this.endAnnotations(parentRefPattern);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitExternalRef(ExternalRefPattern externalRefPattern) {
            Output.this.startAnnotations(externalRefPattern);
            Output.this.pp.startGroup();
            Output.this.pp.text("external ");
            Output.this.pp.startNest("external ");
            Output.this.literal(Output.this.od.reference(Output.this.sourceUri, externalRefPattern.getUri()));
            Output.this.inherit(externalRefPattern.getNs());
            Output.this.pp.endNest();
            Output.this.pp.endGroup();
            Output.this.endAnnotations(externalRefPattern);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitText(TextPattern textPattern) {
            Output.this.startAnnotations(textPattern);
            Output.this.pp.text("text");
            Output.this.endAnnotations(textPattern);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitEmpty(EmptyPattern emptyPattern) {
            Output.this.startAnnotations(emptyPattern);
            Output.this.pp.text("empty");
            Output.this.endAnnotations(emptyPattern);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitNotAllowed(NotAllowedPattern notAllowedPattern) {
            Output.this.startAnnotations(notAllowedPattern);
            Output.this.pp.text("notAllowed");
            Output.this.endAnnotations(notAllowedPattern);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitList(ListPattern listPattern) {
            this.prefix(listPattern, "list");
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitMixed(MixedPattern mixedPattern) {
            this.prefix(mixedPattern, "mixed");
            return VoidValue.VOID;
        }

        private void prefix(UnaryPattern unaryPattern, String string) {
            Output.this.startAnnotations(unaryPattern);
            Output.this.pp.text(string);
            this.braceChild(unaryPattern);
            Output.this.endAnnotations(unaryPattern);
        }

        @Override
        public VoidValue visitChoice(ChoicePattern choicePattern) {
            this.composite(choicePattern, "| ", false);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitInterleave(InterleavePattern interleavePattern) {
            this.composite(interleavePattern, "& ", false);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitGroup(GroupPattern groupPattern) {
            this.composite(groupPattern, ",", true);
            return VoidValue.VOID;
        }

        void composite(CompositePattern compositePattern, String string, boolean bl) {
            boolean bl2;
            boolean bl3 = this.alwaysUseParens;
            if (Output.this.startAnnotations(compositePattern)) {
                bl3 = true;
            }
            boolean bl4 = bl2 = !Output.this.complexityCache.isComplex(compositePattern);
            if (bl2) {
                Output.this.pp.startGroup();
            }
            if (bl3) {
                Output.this.pp.text("(");
                Output.this.pp.startNest("(");
            }
            boolean bl5 = true;
            for (Pattern pattern : compositePattern.getChildren()) {
                if (!bl5) {
                    if (bl) {
                        Output.this.pp.text(string);
                    }
                    if (bl2) {
                        Output.this.pp.softNewline(" ");
                    } else {
                        Output.this.pp.hardNewline();
                    }
                    if (!bl) {
                        Output.this.pp.text(string);
                        Output.this.pp.startNest(string);
                    }
                }
                pattern.accept(Output.this.patternOutput);
                if (bl5) {
                    bl5 = false;
                    continue;
                }
                if (bl) continue;
                Output.this.pp.endNest();
            }
            if (bl3) {
                Output.this.pp.endNest();
                Output.this.pp.text(")");
            }
            if (bl2) {
                Output.this.pp.endGroup();
            }
            Output.this.endAnnotations(compositePattern);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public VoidValue visitData(DataPattern dataPattern) {
            Output.this.startAnnotations(dataPattern);
            String string = dataPattern.getDatatypeLibrary();
            String string2 = !string.equals("") ? (String)Output.this.datatypeLibraryMap.get(string) + ":" + dataPattern.getType() : dataPattern.getType();
            string2 = Output.this.encode(string2);
            Pattern pattern = dataPattern.getExcept();
            if (pattern != null) {
                Output.this.pp.text("(");
            }
            Output.this.pp.text(string2);
            List<Param> list = dataPattern.getParams();
            if (list.size() > 0) {
                Output.this.pp.startGroup();
                Output.this.pp.text(" {");
                Output.this.pp.startNest(Output.this.indent);
                for (Param object : list) {
                    Output.this.pp.softNewline(" ");
                    Output.this.startAnnotations(object);
                    Output.this.pp.startGroup();
                    Output.this.encodedText(object.getName());
                    Output.this.pp.text(" =");
                    Output.this.pp.startNest(Output.this.indent);
                    Output.this.pp.softNewline(" ");
                    Output.this.literal(object.getValue());
                    Output.this.pp.endNest();
                    Output.this.pp.endGroup();
                    Output.this.endAnnotations(object);
                }
                Output.this.pp.endNest();
                Output.this.pp.softNewline(" ");
                Output.this.pp.text("}");
                Output.this.pp.endGroup();
            }
            if (pattern != null) {
                void var7_13;
                boolean bl;
                boolean bl2 = bl = !pattern.mayContainText() && !pattern.getFollowingElementAnnotations().isEmpty();
                if (list.isEmpty()) {
                    String string3 = " - ";
                } else {
                    Output.this.pp.startGroup();
                    Output.this.pp.softNewline(" ");
                    String string4 = "- ";
                }
                if (bl) {
                    void var7_11;
                    String string5 = (String)var7_11 + "(";
                }
                Output.this.pp.text((String)var7_13);
                Output.this.pp.startNest((String)(list.isEmpty() ? string2 + (String)var7_13 : var7_13));
                pattern.accept(bl ? Output.this.noParenPatternOutput : Output.this.patternOutput);
                Output.this.pp.endNest();
                if (bl) {
                    Output.this.pp.text(")");
                }
                if (!list.isEmpty()) {
                    Output.this.pp.endGroup();
                }
                Output.this.pp.text(")");
            }
            Output.this.endAnnotations(dataPattern);
            return VoidValue.VOID;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public VoidValue visitValue(ValuePattern valuePattern) {
            void var3_7;
            String string;
            for (Map.Entry<String, String> object2 : valuePattern.getPrefixMap().entrySet()) {
                string = object2.getKey();
                String string2 = object2.getValue();
                if (string2.equals(Output.this.nsb.getNamespaceUri(string))) continue;
                if (string.equals("")) {
                    Output.this.er.error("value_inconsistent_default_binding", string2, valuePattern.getSourceLocation());
                    continue;
                }
                Output.this.er.error("value_inconsistent_binding", string, string2, valuePattern.getSourceLocation());
            }
            Output.this.startAnnotations(valuePattern);
            String string3 = valuePattern.getDatatypeLibrary();
            Output.this.pp.startGroup();
            Object var3_4 = null;
            if (string3.equals("")) {
                if (!valuePattern.getType().equals("token")) {
                    String string4 = valuePattern.getType() + " ";
                }
            } else {
                String string5 = (String)Output.this.datatypeLibraryMap.get(string3) + ":" + valuePattern.getType() + " ";
            }
            if (var3_7 != null) {
                string = Output.this.encode((String)var3_7);
                Output.this.pp.text(string);
                Output.this.pp.startNest(string);
            }
            Output.this.literal(valuePattern.getValue());
            if (var3_7 != null) {
                Output.this.pp.endNest();
            }
            Output.this.pp.endGroup();
            Output.this.endAnnotations(valuePattern);
            return VoidValue.VOID;
        }
    }

    class RepeatedPatternOutput
    extends PatternOutput {
        RepeatedPatternOutput() {
            super(true);
        }

        @Override
        protected void postfix(UnaryPattern unaryPattern, String string) {
            Output.this.startAnnotations(unaryPattern);
            Output.this.pp.text("(");
            Output.this.pp.startNest("(");
            unaryPattern.getChild().accept(Output.this.repeatedPatternOutput);
            Output.this.pp.endNest();
            Output.this.pp.text(string);
            Output.this.pp.text(")");
            Output.this.endAnnotations(unaryPattern);
        }
    }

    private class ComponentOutput
    implements ComponentVisitor<VoidValue> {
        private ComponentOutput() {
        }

        @Override
        public VoidValue visitDefine(DefineComponent defineComponent) {
            Output.this.startAnnotations(defineComponent);
            Output.this.pp.startGroup();
            String string = defineComponent.getName();
            if (string == DefineComponent.START) {
                Output.this.pp.text("start");
            } else {
                Output.this.identifier(string);
            }
            Combine combine = defineComponent.getCombine();
            String string2 = combine == null ? " =" : (combine == Combine.CHOICE ? " |=" : " &=");
            Output.this.pp.text(string2);
            Output.this.pp.startNest(Output.this.indent);
            Output.this.pp.softNewline(" ");
            defineComponent.getBody().accept(Output.this.noParenPatternOutput);
            Output.this.pp.endNest();
            Output.this.pp.endGroup();
            Output.this.endAnnotations(defineComponent);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitDiv(DivComponent divComponent) {
            Output.this.startAnnotations(divComponent);
            Output.this.pp.text("div");
            Output.this.body(divComponent);
            Output.this.endAnnotations(divComponent);
            return VoidValue.VOID;
        }

        @Override
        public VoidValue visitInclude(IncludeComponent includeComponent) {
            Output.this.startAnnotations(includeComponent);
            Output.this.pp.startGroup();
            Output.this.pp.text("include ");
            Output.this.pp.startNest("include ");
            Output.this.literal(Output.this.od.reference(Output.this.sourceUri, includeComponent.getUri()));
            Output.this.inherit(includeComponent.getNs());
            Output.this.pp.endNest();
            Output.this.pp.endGroup();
            List<Component> list = includeComponent.getComponents();
            if (!list.isEmpty()) {
                Output.this.body(list);
            }
            Output.this.endAnnotations(includeComponent);
            return VoidValue.VOID;
        }
    }

    static class NamespaceVisitor
    extends VoidVisitor {
        private final NamespaceManager nsm = new NamespaceManager();
        private boolean isAttribute;

        NamespaceVisitor() {
        }

        @Override
        public void voidVisitInclude(IncludeComponent includeComponent) {
            super.voidVisitInclude(includeComponent);
            this.nsm.requireNamespace(includeComponent.getNs(), true);
        }

        @Override
        public void voidVisitExternalRef(ExternalRefPattern externalRefPattern) {
            super.voidVisitExternalRef(externalRefPattern);
            this.nsm.requireNamespace(externalRefPattern.getNs(), true);
        }

        @Override
        public void voidVisitElement(ElementPattern elementPattern) {
            this.isAttribute = false;
            super.voidVisitElement(elementPattern);
        }

        @Override
        public void voidVisitAttribute(AttributePattern attributePattern) {
            this.isAttribute = true;
            super.voidVisitAttribute(attributePattern);
        }

        @Override
        public void voidVisitName(NameNameClass nameNameClass) {
            super.voidVisitName(nameNameClass);
            if (!this.isAttribute || nameNameClass.getNamespaceUri().length() != 0) {
                this.nsm.requireNamespace(nameNameClass.getNamespaceUri(), !this.isAttribute);
            }
            if (nameNameClass.getPrefix() == null) {
                if (!this.isAttribute) {
                    this.nsm.preferBinding("", nameNameClass.getNamespaceUri());
                }
            } else {
                this.nsm.preferBinding(nameNameClass.getPrefix(), nameNameClass.getNamespaceUri());
            }
        }

        @Override
        public void voidVisitNsName(NsNameNameClass nsNameNameClass) {
            super.voidVisitNsName(nsNameNameClass);
            this.nsm.requireNamespace(nsNameNameClass.getNs(), false);
        }

        @Override
        public void voidVisitValue(ValuePattern valuePattern) {
            super.voidVisitValue(valuePattern);
            for (Map.Entry<String, String> entry : valuePattern.getPrefixMap().entrySet()) {
                this.nsm.requireBinding(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public void voidVisitElement(ElementAnnotation elementAnnotation) {
            super.voidVisitElement(elementAnnotation);
            this.noteAnnotationBinding(elementAnnotation.getPrefix(), elementAnnotation.getNamespaceUri());
            this.noteContext(elementAnnotation.getContext(), true);
        }

        private void noteContext(NamespaceContext namespaceContext, boolean bl) {
            if (namespaceContext == null) {
                return;
            }
            for (String string : namespaceContext.getPrefixes()) {
                String string2;
                if (string.equals("") || (string2 = namespaceContext.getNamespace(string)) == null || string2.equals(SchemaBuilder.INHERIT_NS)) continue;
                if (bl) {
                    this.nsm.requireBinding(string, string2);
                    continue;
                }
                this.nsm.preferBinding(string, string2);
            }
        }

        @Override
        public void voidVisitAttribute(AttributeAnnotation attributeAnnotation) {
            super.voidVisitAttribute(attributeAnnotation);
            this.noteAnnotationBinding(attributeAnnotation.getPrefix(), attributeAnnotation.getNamespaceUri());
        }

        private void noteAnnotationBinding(String string, String string2) {
            if (string2.length() != 0) {
                this.nsm.requireNamespace(string2, false);
            }
            if (string != null) {
                this.nsm.preferBinding(string, string2);
            }
        }

        @Override
        public void voidVisitAnnotated(Annotated annotated) {
            annotated.leadingCommentsAccept(this);
            this.noteContext(annotated.getContext(), !annotated.getAttributeAnnotations().isEmpty());
            annotated.attributeAnnotationsAccept(this);
            List<AnnotationChild> list = annotated.mayContainText() ? annotated.getFollowingElementAnnotations() : annotated.getChildElementAnnotations();
            int n = 0;
            for (AnnotationChild annotationChild : list) {
                if (n < 2 && Output.documentationString(annotationChild) != null) {
                    n = 1;
                } else if (n != 1 || !(annotationChild instanceof Comment)) {
                    n = 2;
                }
                if (n != 2) continue;
                annotationChild.accept(this);
            }
            if (!annotated.mayContainText()) {
                annotated.followingElementAnnotationsAccept(this);
            }
        }

        static NamespaceManager.NamespaceBindings createBindings(Pattern pattern) {
            NamespaceVisitor namespaceVisitor = new NamespaceVisitor();
            pattern.accept(namespaceVisitor);
            return namespaceVisitor.nsm.createBindings();
        }
    }

    static class DatatypeLibraryVisitor
    extends VoidVisitor {
        private final Set<String> datatypeLibraries = new HashSet<String>();

        DatatypeLibraryVisitor() {
        }

        @Override
        public void voidVisitValue(ValuePattern valuePattern) {
            this.noteDatatypeLibrary(valuePattern.getDatatypeLibrary());
            super.voidVisitValue(valuePattern);
        }

        @Override
        public void voidVisitData(DataPattern dataPattern) {
            this.noteDatatypeLibrary(dataPattern.getDatatypeLibrary());
            super.voidVisitData(dataPattern);
        }

        private void noteDatatypeLibrary(String string) {
            if (!string.equals("") && !string.equals("http://www.w3.org/2001/XMLSchema-datatypes")) {
                this.datatypeLibraries.add(string);
            }
        }

        static Set<String> findDatatypeLibraries(Pattern pattern) {
            DatatypeLibraryVisitor datatypeLibraryVisitor = new DatatypeLibraryVisitor();
            pattern.accept(datatypeLibraryVisitor);
            return datatypeLibraryVisitor.datatypeLibraries;
        }
    }

    private static class TextAnnotationMerger
    extends VoidVisitor {
        private TextAnnotationMerger() {
        }

        @Override
        public void voidVisitElement(ElementAnnotation elementAnnotation) {
            TextAnnotation textAnnotation = null;
            Iterator<AnnotationChild> iterator = elementAnnotation.getChildren().iterator();
            while (iterator.hasNext()) {
                AnnotationChild annotationChild = iterator.next();
                if (annotationChild instanceof TextAnnotation) {
                    if (textAnnotation == null) {
                        textAnnotation = (TextAnnotation)annotationChild;
                        continue;
                    }
                    textAnnotation.setValue(textAnnotation.getValue() + ((TextAnnotation)annotationChild).getValue());
                    iterator.remove();
                    continue;
                }
                textAnnotation = null;
                annotationChild.accept(this);
            }
        }
    }
}

