/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.rnc;

import com.thaiopensource.relaxng.output.rnc.Prettyprinter;
import java.io.IOException;
import java.io.Writer;

public class StreamingPrettyprinter
implements Prettyprinter {
    private final String lineSep;
    private final Writer w;
    private Segment head;
    private Segment tail;
    private int nextSegmentSerial = 0;
    private Group currentGroup = new Group(null);
    private int currentIndent = 0;
    private int[] indentStack = new int[10];
    private int indentLevel = 0;
    private int totalWidth = 0;
    private int availWidth;
    private Segment lastPossibleBreak = null;
    private final int maxWidth;
    private Group noBreakGroup = null;

    public StreamingPrettyprinter(int n, String string, Writer writer) {
        this.lineSep = string;
        this.w = writer;
        this.maxWidth = n;
        this.availWidth = n;
        this.tail = this.head = this.makeSegment();
    }

    private Segment makeSegment() {
        return new Segment(this.nextSegmentSerial++);
    }

    @Override
    public void startGroup() {
        this.currentGroup = new Group(this.currentGroup);
    }

    @Override
    public void endGroup() {
        if (this.noBreakGroup == this.currentGroup) {
            this.noBreakGroup = null;
        }
        this.currentGroup.closeSegmentSerial = this.tail.serial;
        this.currentGroup = this.currentGroup.parent;
    }

    @Override
    public void startNest(String string) {
        if (this.indentLevel >= this.indentStack.length) {
            int[] nArray = new int[this.indentStack.length * 2];
            System.arraycopy(this.indentStack, 0, nArray, 0, this.indentStack.length);
            this.indentStack = nArray;
        }
        this.indentStack[this.indentLevel++] = this.currentIndent;
        this.currentIndent += string.length();
    }

    @Override
    public void endNest() {
        this.currentIndent = this.indentStack[--this.indentLevel];
    }

    @Override
    public void text(String string) {
        this.tail.append(string);
        this.totalWidth += string.length();
        this.tryFlush(false);
    }

    @Override
    public void softNewline(String string) {
        Segment segment;
        if (this.head == this.tail || this.noBreakGroup == null) {
            this.lastPossibleBreak = this.tail;
        }
        this.tail.append(string);
        this.tail.preBreakDiscardCount = string.length();
        this.tail.group = this.currentGroup;
        if (this.noBreakGroup == null) {
            this.noBreakGroup = this.currentGroup;
        }
        this.tail.indent = this.currentIndent;
        this.totalWidth += this.tail.preBreakDiscardCount;
        this.tail.next = segment = this.makeSegment();
        this.tail = segment;
        this.tryFlush(false);
    }

    @Override
    public void hardNewline() {
        Segment segment;
        if (this.head == this.tail || this.noBreakGroup == null) {
            this.lastPossibleBreak = this.tail;
        }
        this.tail.preBreakDiscardCount = 0;
        this.tail.group = this.currentGroup;
        if (this.noBreakGroup == null) {
            this.noBreakGroup = this.currentGroup;
        }
        this.tail.indent = this.currentIndent;
        this.tail.next = segment = this.makeSegment();
        this.tail = segment;
        this.tryFlush(true);
    }

    private boolean shouldKeepLooking(boolean bl) {
        if (this.lastPossibleBreak == null) {
            return true;
        }
        if (bl) {
            return false;
        }
        if (this.totalWidth > this.availWidth) {
            return false;
        }
        return !this.lastPossibleBreak.group.broken;
    }

    private void tryFlush(boolean bl) {
        while (!this.shouldKeepLooking(bl)) {
            Segment segment = this.head;
            this.head = this.lastPossibleBreak.next;
            this.lastPossibleBreak.next = null;
            this.lastPossibleBreak.length -= this.lastPossibleBreak.preBreakDiscardCount;
            while (segment != null) {
                this.write(segment.chars, 0, segment.length);
                segment = segment.next;
            }
            this.writeNewline(this.lastPossibleBreak.indent);
            this.availWidth = this.maxWidth - this.lastPossibleBreak.indent;
            this.lastPossibleBreak.group.setBroken();
            this.update();
        }
        return;
    }

    private void update() {
        this.lastPossibleBreak = null;
        this.totalWidth = 0;
        Group group = null;
        Segment segment = this.head;
        while (segment != this.tail) {
            if (group != null && group.closeSegmentSerial != -1 && segment.serial >= group.closeSegmentSerial) {
                group = null;
            }
            this.totalWidth += segment.length;
            if (this.lastPossibleBreak == null || !this.lastPossibleBreak.group.broken && group == null) {
                this.lastPossibleBreak = segment;
            }
            if (group == null) {
                group = segment.group;
            }
            segment = segment.next;
        }
        this.totalWidth += this.tail.length;
        this.noBreakGroup = group != null && group.closeSegmentSerial == -1 ? group : null;
    }

    @Override
    public void close() {
        if (this.tail.length != 0) {
            this.currentIndent = 0;
            this.hardNewline();
        } else if (this.head != this.tail) {
            Segment segment = this.head;
            while (true) {
                if (segment.next == this.tail) break;
                segment = segment.next;
            }
            segment.indent = 0;
            this.tryFlush(true);
        }
        try {
            this.w.close();
        }
        catch (IOException iOException) {
            throw new Prettyprinter.WrappedException(iOException);
        }
    }

    private void write(char[] cArray, int n, int n2) {
        try {
            this.w.write(cArray, n, n2);
        }
        catch (IOException iOException) {
            throw new Prettyprinter.WrappedException(iOException);
        }
    }

    private void writeNewline(int n) {
        try {
            this.w.write(this.lineSep);
            for (int i = 0; i < n; ++i) {
                this.w.write(32);
            }
        }
        catch (IOException iOException) {
            throw new Prettyprinter.WrappedException(iOException);
        }
    }

    private static class Segment {
        Segment next;
        int preBreakDiscardCount = -1;
        Group group = null;
        int indent;
        final int serial;
        private static final int ALLOC_SPARE = 5;
        private static final int ALLOC_INIT = 10;
        char[] chars = new char[10];
        int length = 0;

        Segment(int n) {
            this.serial = n;
        }

        void append(String string) {
            if (string.length() > this.chars.length - this.length) {
                int n = this.chars.length * 2;
                if (n - this.length < string.length()) {
                    n = this.chars.length + string.length() + 5;
                }
                char[] cArray = new char[n];
                System.arraycopy(this.chars, 0, cArray, 0, this.length);
                this.chars = cArray;
            }
            string.getChars(0, string.length(), this.chars, this.length);
            this.length += string.length();
        }
    }

    private static class Group {
        int closeSegmentSerial = -1;
        boolean broken;
        final Group parent;

        Group(Group group) {
            this.parent = group;
            this.broken = group == null;
        }

        void setBroken() {
            if (!this.broken) {
                this.broken = true;
                this.parent.setBroken();
            }
        }
    }
}

