/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.slee.resource.map;

import java.lang.management.ManagementFactory;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.slee.Address;
import javax.slee.AddressPlan;
import javax.slee.SLEEException;
import javax.slee.facilities.Tracer;
import javax.slee.resource.ActivityAlreadyExistsException;
import javax.slee.resource.ActivityHandle;
import javax.slee.resource.ActivityIsEndingException;
import javax.slee.resource.ConfigProperties;
import javax.slee.resource.FailureReason;
import javax.slee.resource.FireEventException;
import javax.slee.resource.FireableEventType;
import javax.slee.resource.IllegalEventException;
import javax.slee.resource.InvalidConfigurationException;
import javax.slee.resource.Marshaler;
import javax.slee.resource.ReceivableService;
import javax.slee.resource.ResourceAdaptor;
import javax.slee.resource.ResourceAdaptorContext;
import javax.slee.resource.SleeEndpoint;
import javax.slee.resource.StartActivityException;
import javax.slee.resource.UnrecognizedActivityHandleException;
import org.restcomm.protocols.ss7.map.api.MAPDialog;
import org.restcomm.protocols.ss7.map.api.MAPDialogListener;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPMessage;
import org.restcomm.protocols.ss7.map.api.MAPProvider;
import org.restcomm.protocols.ss7.map.api.dialog.MAPAbortProviderReason;
import org.restcomm.protocols.ss7.map.api.dialog.MAPAbortSource;
import org.restcomm.protocols.ss7.map.api.dialog.MAPDialogState;
import org.restcomm.protocols.ss7.map.api.dialog.MAPNoticeProblemDiagnostic;
import org.restcomm.protocols.ss7.map.api.dialog.MAPRefuseReason;
import org.restcomm.protocols.ss7.map.api.dialog.MAPUserAbortChoice;
import org.restcomm.protocols.ss7.map.api.errors.MAPErrorMessage;
import org.restcomm.protocols.ss7.map.api.primitives.AddressString;
import org.restcomm.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.restcomm.protocols.ss7.map.api.service.callhandling.IstCommandRequest;
import org.restcomm.protocols.ss7.map.api.service.callhandling.IstCommandResponse;
import org.restcomm.protocols.ss7.map.api.service.callhandling.MAPDialogCallHandling;
import org.restcomm.protocols.ss7.map.api.service.callhandling.MAPServiceCallHandlingListener;
import org.restcomm.protocols.ss7.map.api.service.callhandling.ProvideRoamingNumberRequest;
import org.restcomm.protocols.ss7.map.api.service.callhandling.ProvideRoamingNumberResponse;
import org.restcomm.protocols.ss7.map.api.service.callhandling.SendRoutingInformationRequest;
import org.restcomm.protocols.ss7.map.api.service.callhandling.SendRoutingInformationResponse;
import org.restcomm.protocols.ss7.map.api.service.lsm.MAPDialogLsm;
import org.restcomm.protocols.ss7.map.api.service.lsm.MAPServiceLsmListener;
import org.restcomm.protocols.ss7.map.api.service.lsm.ProvideSubscriberLocationRequest;
import org.restcomm.protocols.ss7.map.api.service.lsm.ProvideSubscriberLocationResponse;
import org.restcomm.protocols.ss7.map.api.service.lsm.SendRoutingInfoForLCSRequest;
import org.restcomm.protocols.ss7.map.api.service.lsm.SendRoutingInfoForLCSResponse;
import org.restcomm.protocols.ss7.map.api.service.lsm.SubscriberLocationReportRequest;
import org.restcomm.protocols.ss7.map.api.service.lsm.SubscriberLocationReportResponse;
import org.restcomm.protocols.ss7.map.api.service.mobility.MAPDialogMobility;
import org.restcomm.protocols.ss7.map.api.service.mobility.MAPServiceMobilityListener;
import org.restcomm.protocols.ss7.map.api.service.mobility.authentication.AuthenticationFailureReportRequest;
import org.restcomm.protocols.ss7.map.api.service.mobility.authentication.AuthenticationFailureReportResponse;
import org.restcomm.protocols.ss7.map.api.service.mobility.authentication.SendAuthenticationInfoRequest;
import org.restcomm.protocols.ss7.map.api.service.mobility.authentication.SendAuthenticationInfoResponse;
import org.restcomm.protocols.ss7.map.api.service.mobility.faultRecovery.ForwardCheckSSIndicationRequest;
import org.restcomm.protocols.ss7.map.api.service.mobility.faultRecovery.ResetRequest;
import org.restcomm.protocols.ss7.map.api.service.mobility.faultRecovery.RestoreDataRequest;
import org.restcomm.protocols.ss7.map.api.service.mobility.faultRecovery.RestoreDataResponse;
import org.restcomm.protocols.ss7.map.api.service.mobility.imei.CheckImeiRequest;
import org.restcomm.protocols.ss7.map.api.service.mobility.imei.CheckImeiResponse;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.CancelLocationRequest;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.CancelLocationResponse;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.PurgeMSRequest;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.PurgeMSResponse;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.SendIdentificationRequest;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.SendIdentificationResponse;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.UpdateGprsLocationRequest;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.UpdateGprsLocationResponse;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.UpdateLocationRequest;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.UpdateLocationResponse;
import org.restcomm.protocols.ss7.map.api.service.mobility.oam.ActivateTraceModeRequest_Mobility;
import org.restcomm.protocols.ss7.map.api.service.mobility.oam.ActivateTraceModeResponse_Mobility;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberInformation.AnyTimeInterrogationRequest;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberInformation.AnyTimeInterrogationResponse;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberInformation.AnyTimeSubscriptionInterrogationRequest;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberInformation.AnyTimeSubscriptionInterrogationResponse;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberInformation.ProvideSubscriberInfoRequest;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberInformation.ProvideSubscriberInfoResponse;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.DeleteSubscriberDataRequest;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.DeleteSubscriberDataResponse;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.InsertSubscriberDataRequest;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.InsertSubscriberDataResponse;
import org.restcomm.protocols.ss7.map.api.service.oam.ActivateTraceModeRequest_Oam;
import org.restcomm.protocols.ss7.map.api.service.oam.ActivateTraceModeResponse_Oam;
import org.restcomm.protocols.ss7.map.api.service.oam.MAPDialogOam;
import org.restcomm.protocols.ss7.map.api.service.oam.MAPServiceOamListener;
import org.restcomm.protocols.ss7.map.api.service.oam.SendImsiRequest;
import org.restcomm.protocols.ss7.map.api.service.oam.SendImsiResponse;
import org.restcomm.protocols.ss7.map.api.service.pdpContextActivation.MAPDialogPdpContextActivation;
import org.restcomm.protocols.ss7.map.api.service.pdpContextActivation.MAPServicePdpContextActivationListener;
import org.restcomm.protocols.ss7.map.api.service.pdpContextActivation.SendRoutingInfoForGprsRequest;
import org.restcomm.protocols.ss7.map.api.service.pdpContextActivation.SendRoutingInfoForGprsResponse;
import org.restcomm.protocols.ss7.map.api.service.sms.AlertServiceCentreRequest;
import org.restcomm.protocols.ss7.map.api.service.sms.AlertServiceCentreResponse;
import org.restcomm.protocols.ss7.map.api.service.sms.ForwardShortMessageRequest;
import org.restcomm.protocols.ss7.map.api.service.sms.ForwardShortMessageResponse;
import org.restcomm.protocols.ss7.map.api.service.sms.InformServiceCentreRequest;
import org.restcomm.protocols.ss7.map.api.service.sms.MAPDialogSms;
import org.restcomm.protocols.ss7.map.api.service.sms.MAPServiceSmsListener;
import org.restcomm.protocols.ss7.map.api.service.sms.MoForwardShortMessageRequest;
import org.restcomm.protocols.ss7.map.api.service.sms.MoForwardShortMessageResponse;
import org.restcomm.protocols.ss7.map.api.service.sms.MtForwardShortMessageRequest;
import org.restcomm.protocols.ss7.map.api.service.sms.MtForwardShortMessageResponse;
import org.restcomm.protocols.ss7.map.api.service.sms.NoteSubscriberPresentRequest;
import org.restcomm.protocols.ss7.map.api.service.sms.ReadyForSMRequest;
import org.restcomm.protocols.ss7.map.api.service.sms.ReadyForSMResponse;
import org.restcomm.protocols.ss7.map.api.service.sms.ReportSMDeliveryStatusRequest;
import org.restcomm.protocols.ss7.map.api.service.sms.ReportSMDeliveryStatusResponse;
import org.restcomm.protocols.ss7.map.api.service.sms.SendRoutingInfoForSMRequest;
import org.restcomm.protocols.ss7.map.api.service.sms.SendRoutingInfoForSMResponse;
import org.restcomm.protocols.ss7.map.api.service.supplementary.ActivateSSRequest;
import org.restcomm.protocols.ss7.map.api.service.supplementary.ActivateSSResponse;
import org.restcomm.protocols.ss7.map.api.service.supplementary.DeactivateSSRequest;
import org.restcomm.protocols.ss7.map.api.service.supplementary.DeactivateSSResponse;
import org.restcomm.protocols.ss7.map.api.service.supplementary.EraseSSRequest;
import org.restcomm.protocols.ss7.map.api.service.supplementary.EraseSSResponse;
import org.restcomm.protocols.ss7.map.api.service.supplementary.GetPasswordRequest;
import org.restcomm.protocols.ss7.map.api.service.supplementary.GetPasswordResponse;
import org.restcomm.protocols.ss7.map.api.service.supplementary.InterrogateSSRequest;
import org.restcomm.protocols.ss7.map.api.service.supplementary.InterrogateSSResponse;
import org.restcomm.protocols.ss7.map.api.service.supplementary.MAPDialogSupplementary;
import org.restcomm.protocols.ss7.map.api.service.supplementary.MAPServiceSupplementaryListener;
import org.restcomm.protocols.ss7.map.api.service.supplementary.ProcessUnstructuredSSRequest;
import org.restcomm.protocols.ss7.map.api.service.supplementary.ProcessUnstructuredSSResponse;
import org.restcomm.protocols.ss7.map.api.service.supplementary.RegisterPasswordRequest;
import org.restcomm.protocols.ss7.map.api.service.supplementary.RegisterPasswordResponse;
import org.restcomm.protocols.ss7.map.api.service.supplementary.RegisterSSRequest;
import org.restcomm.protocols.ss7.map.api.service.supplementary.RegisterSSResponse;
import org.restcomm.protocols.ss7.map.api.service.supplementary.UnstructuredSSNotifyRequest;
import org.restcomm.protocols.ss7.map.api.service.supplementary.UnstructuredSSNotifyResponse;
import org.restcomm.protocols.ss7.map.api.service.supplementary.UnstructuredSSRequest;
import org.restcomm.protocols.ss7.map.api.service.supplementary.UnstructuredSSResponse;
import org.restcomm.protocols.ss7.tcap.asn.ApplicationContextName;
import org.restcomm.protocols.ss7.tcap.asn.comp.Problem;
import org.restcomm.slee.resource.map.EventIDCache;
import org.restcomm.slee.resource.map.EventIDFilter;
import org.restcomm.slee.resource.map.MAPDialogActivityHandle;
import org.restcomm.slee.resource.map.MAPRAMarshaler;
import org.restcomm.slee.resource.map.MAPResourceAdaptorStatisticsUsageParameters;
import org.restcomm.slee.resource.map.events.DialogAccept;
import org.restcomm.slee.resource.map.events.DialogClose;
import org.restcomm.slee.resource.map.events.DialogDelimiter;
import org.restcomm.slee.resource.map.events.DialogNotice;
import org.restcomm.slee.resource.map.events.DialogProviderAbort;
import org.restcomm.slee.resource.map.events.DialogReject;
import org.restcomm.slee.resource.map.events.DialogRelease;
import org.restcomm.slee.resource.map.events.DialogRequest;
import org.restcomm.slee.resource.map.events.DialogTimeout;
import org.restcomm.slee.resource.map.events.DialogUserAbort;
import org.restcomm.slee.resource.map.events.ErrorComponent;
import org.restcomm.slee.resource.map.events.InvokeTimeout;
import org.restcomm.slee.resource.map.events.MAPEvent;
import org.restcomm.slee.resource.map.events.RejectComponent;
import org.restcomm.slee.resource.map.service.callhandling.wrappers.IstCommandRequestWrapper;
import org.restcomm.slee.resource.map.service.callhandling.wrappers.IstCommandResponseWrapper;
import org.restcomm.slee.resource.map.service.callhandling.wrappers.MAPDialogCallHandlingWrapper;
import org.restcomm.slee.resource.map.service.callhandling.wrappers.ProvideRoamingNumberRequestWrapper;
import org.restcomm.slee.resource.map.service.callhandling.wrappers.ProvideRoamingNumberResponseWrapper;
import org.restcomm.slee.resource.map.service.callhandling.wrappers.SendRoutingInformationRequestWrapper;
import org.restcomm.slee.resource.map.service.callhandling.wrappers.SendRoutingInformationResponseWrapper;
import org.restcomm.slee.resource.map.service.lsm.wrappers.MAPDialogLsmWrapper;
import org.restcomm.slee.resource.map.service.lsm.wrappers.ProvideSubscriberLocationRequestWrapper;
import org.restcomm.slee.resource.map.service.lsm.wrappers.ProvideSubscriberLocationResponseWrapper;
import org.restcomm.slee.resource.map.service.lsm.wrappers.SendRoutingInfoForLCSRequestWrapper;
import org.restcomm.slee.resource.map.service.lsm.wrappers.SendRoutingInfoForLCSResponseWrapper;
import org.restcomm.slee.resource.map.service.lsm.wrappers.SubscriberLocationReportRequestWrapper;
import org.restcomm.slee.resource.map.service.lsm.wrappers.SubscriberLocationReportResponseWrapper;
import org.restcomm.slee.resource.map.service.mobility.authentication.wrappers.AuthenticationFailureReportRequestWrapper;
import org.restcomm.slee.resource.map.service.mobility.authentication.wrappers.AuthenticationFailureReportResponseWrapper;
import org.restcomm.slee.resource.map.service.mobility.authentication.wrappers.SendAuthenticationInfoRequestWrapper;
import org.restcomm.slee.resource.map.service.mobility.authentication.wrappers.SendAuthenticationInfoResponseWrapper;
import org.restcomm.slee.resource.map.service.mobility.faultRecovery.wrappers.ForwardCheckSSIndicationRequestWrapper;
import org.restcomm.slee.resource.map.service.mobility.faultRecovery.wrappers.ResetRequestWrapper;
import org.restcomm.slee.resource.map.service.mobility.faultRecovery.wrappers.RestoreDataRequestWrapper;
import org.restcomm.slee.resource.map.service.mobility.faultRecovery.wrappers.RestoreDataResponseWrapper;
import org.restcomm.slee.resource.map.service.mobility.imei.wrappers.CheckImeiRequestWrapper;
import org.restcomm.slee.resource.map.service.mobility.imei.wrappers.CheckImeiResponseWrapper;
import org.restcomm.slee.resource.map.service.mobility.locationManagement.wrappers.CancelLocationRequestWrapper;
import org.restcomm.slee.resource.map.service.mobility.locationManagement.wrappers.CancelLocationResponseWrapper;
import org.restcomm.slee.resource.map.service.mobility.locationManagement.wrappers.PurgeMSRequestWrapper;
import org.restcomm.slee.resource.map.service.mobility.locationManagement.wrappers.PurgeMSResponseWrapper;
import org.restcomm.slee.resource.map.service.mobility.locationManagement.wrappers.SendIdentificationRequestWrapper;
import org.restcomm.slee.resource.map.service.mobility.locationManagement.wrappers.SendIdentificationResponseWrapper;
import org.restcomm.slee.resource.map.service.mobility.locationManagement.wrappers.UpdateGprsLocationRequestWrapper;
import org.restcomm.slee.resource.map.service.mobility.locationManagement.wrappers.UpdateGprsLocationResponseWrapper;
import org.restcomm.slee.resource.map.service.mobility.locationManagement.wrappers.UpdateLocationRequestWrapper;
import org.restcomm.slee.resource.map.service.mobility.locationManagement.wrappers.UpdateLocationResponseWrapper;
import org.restcomm.slee.resource.map.service.mobility.oam.wrappers.ActivateTraceModeRequest_MobilityWrapper;
import org.restcomm.slee.resource.map.service.mobility.oam.wrappers.ActivateTraceModeResponse_MobilityWrapper;
import org.restcomm.slee.resource.map.service.mobility.subscriberInformation.wrappers.AnyTimeInterrogationRequestWrapper;
import org.restcomm.slee.resource.map.service.mobility.subscriberInformation.wrappers.AnyTimeInterrogationResponseWrapper;
import org.restcomm.slee.resource.map.service.mobility.subscriberInformation.wrappers.AnyTimeSubscriptionInterrogationRequestWrapper;
import org.restcomm.slee.resource.map.service.mobility.subscriberInformation.wrappers.AnyTimeSubscriptionInterrogationResponseWrapper;
import org.restcomm.slee.resource.map.service.mobility.subscriberInformation.wrappers.ProvideSubscriberInfoRequestWrapper;
import org.restcomm.slee.resource.map.service.mobility.subscriberInformation.wrappers.ProvideSubscriberInfoResponseWrapper;
import org.restcomm.slee.resource.map.service.mobility.subscriberManagement.wrappers.DeleteSubscriberDataRequestWrapper;
import org.restcomm.slee.resource.map.service.mobility.subscriberManagement.wrappers.DeleteSubscriberDataResponseWrapper;
import org.restcomm.slee.resource.map.service.mobility.subscriberManagement.wrappers.InsertSubscriberDataRequestWrapper;
import org.restcomm.slee.resource.map.service.mobility.subscriberManagement.wrappers.InsertSubscriberDataResponseWrapper;
import org.restcomm.slee.resource.map.service.mobility.wrappers.MAPDialogMobilityWrapper;
import org.restcomm.slee.resource.map.service.oam.wrappers.ActivateTraceModeRequest_OamWrapper;
import org.restcomm.slee.resource.map.service.oam.wrappers.ActivateTraceModeResponse_OamWrapper;
import org.restcomm.slee.resource.map.service.oam.wrappers.MAPDialogOamWrapper;
import org.restcomm.slee.resource.map.service.oam.wrappers.SendImsiRequestWrapper;
import org.restcomm.slee.resource.map.service.oam.wrappers.SendImsiResponseWrapper;
import org.restcomm.slee.resource.map.service.pdpContextActivation.wrappers.MAPDialogPdpContextActivationWrapper;
import org.restcomm.slee.resource.map.service.pdpContextActivation.wrappers.SendRoutingInfoForGprsRequestWrapper;
import org.restcomm.slee.resource.map.service.pdpContextActivation.wrappers.SendRoutingInfoForGprsResponseWrapper;
import org.restcomm.slee.resource.map.service.sms.wrappers.AlertServiceCentreRequestWrapper;
import org.restcomm.slee.resource.map.service.sms.wrappers.AlertServiceCentreResponseWrapper;
import org.restcomm.slee.resource.map.service.sms.wrappers.ForwardShortMessageRequestWrapper;
import org.restcomm.slee.resource.map.service.sms.wrappers.ForwardShortMessageResponseWrapper;
import org.restcomm.slee.resource.map.service.sms.wrappers.InformServiceCentreRequestWrapper;
import org.restcomm.slee.resource.map.service.sms.wrappers.MAPDialogSmsWrapper;
import org.restcomm.slee.resource.map.service.sms.wrappers.MoForwardShortMessageRequestWrapper;
import org.restcomm.slee.resource.map.service.sms.wrappers.MoForwardShortMessageResponseWrapper;
import org.restcomm.slee.resource.map.service.sms.wrappers.MtForwardShortMessageRequestWrapper;
import org.restcomm.slee.resource.map.service.sms.wrappers.MtForwardShortMessageResponseWrapper;
import org.restcomm.slee.resource.map.service.sms.wrappers.NoteSubscriberPresentRequestWrapper;
import org.restcomm.slee.resource.map.service.sms.wrappers.ReadyForSMRequestWrapper;
import org.restcomm.slee.resource.map.service.sms.wrappers.ReadyForSMResponseWrapper;
import org.restcomm.slee.resource.map.service.sms.wrappers.ReportSMDeliveryStatusRequestWrapper;
import org.restcomm.slee.resource.map.service.sms.wrappers.ReportSMDeliveryStatusResponseWrapper;
import org.restcomm.slee.resource.map.service.sms.wrappers.SendRoutingInfoForSMRequestWrapper;
import org.restcomm.slee.resource.map.service.sms.wrappers.SendRoutingInfoForSMResponseWrapper;
import org.restcomm.slee.resource.map.service.supplementary.wrappers.ActivateSSRequestWrapper;
import org.restcomm.slee.resource.map.service.supplementary.wrappers.ActivateSSResponseWrapper;
import org.restcomm.slee.resource.map.service.supplementary.wrappers.DeactivateSSRequestWrapper;
import org.restcomm.slee.resource.map.service.supplementary.wrappers.DeactivateSSResponseWrapper;
import org.restcomm.slee.resource.map.service.supplementary.wrappers.EraseSSRequestWrapper;
import org.restcomm.slee.resource.map.service.supplementary.wrappers.EraseSSResponseWrapper;
import org.restcomm.slee.resource.map.service.supplementary.wrappers.GetPasswordRequestWrapper;
import org.restcomm.slee.resource.map.service.supplementary.wrappers.GetPasswordResponseWrapper;
import org.restcomm.slee.resource.map.service.supplementary.wrappers.InterrogateSSRequestWrapper;
import org.restcomm.slee.resource.map.service.supplementary.wrappers.InterrogateSSResponseWrapper;
import org.restcomm.slee.resource.map.service.supplementary.wrappers.MAPDialogSupplementaryWrapper;
import org.restcomm.slee.resource.map.service.supplementary.wrappers.ProcessUnstructuredSSRequestWrapper;
import org.restcomm.slee.resource.map.service.supplementary.wrappers.ProcessUnstructuredSSResponseWrapper;
import org.restcomm.slee.resource.map.service.supplementary.wrappers.RegisterPasswordRequestWrapper;
import org.restcomm.slee.resource.map.service.supplementary.wrappers.RegisterPasswordResponseWrapper;
import org.restcomm.slee.resource.map.service.supplementary.wrappers.RegisterSSRequestWrapper;
import org.restcomm.slee.resource.map.service.supplementary.wrappers.RegisterSSResponseWrapper;
import org.restcomm.slee.resource.map.service.supplementary.wrappers.UnstructuredSSNotifyRequestWrapper;
import org.restcomm.slee.resource.map.service.supplementary.wrappers.UnstructuredSSNotifyResponseWrapper;
import org.restcomm.slee.resource.map.service.supplementary.wrappers.UnstructuredSSRequestWrapper;
import org.restcomm.slee.resource.map.service.supplementary.wrappers.UnstructuredSSResponseWrapper;
import org.restcomm.slee.resource.map.wrappers.MAPDialogWrapper;
import org.restcomm.slee.resource.map.wrappers.MAPProviderWrapper;
import org.restcomm.slee.resource.ss7.ext.SS7RAExtImpl;
import org.restcomm.slee.resource.ss7.ext.SS7RAExtInterface;

public class MAPResourceAdaptor
implements ResourceAdaptor,
MAPDialogListener,
MAPServiceMobilityListener,
MAPServiceCallHandlingListener,
MAPServiceOamListener,
MAPServicePdpContextActivationListener,
MAPServiceSupplementaryListener,
MAPServiceSmsListener,
MAPServiceLsmListener {
    public static final int DEFAULT_EVENT_FLAGS = 64;
    private static final int ACTIVITY_FLAGS = 2;
    protected MAPProviderWrapper mapProvider = null;
    protected MAPProvider realProvider = null;
    protected Tracer tracer;
    private transient SleeEndpoint sleeEndpoint = null;
    protected ResourceAdaptorContext resourceAdaptorContext;
    private MAPResourceAdaptorStatisticsUsageParameters defaultUsageParameters;
    private EventIDCache eventIdCache = null;
    private Marshaler marshaler = new MAPRAMarshaler();
    private final EventIDFilter eventIDFilter = new EventIDFilter();
    private static final String CONF_MAP_JNDI = "mapJndi";
    private String mapJndi = null;
    private static final transient Address address = new Address(AddressPlan.IP, "localhost");
    private SS7RAExtInterface ss7RAExtInterface = new SS7RAExtImpl();

    public MAPResourceAdaptor() {
        this.mapProvider = new MAPProviderWrapper(this);
    }

    public void activityEnded(ActivityHandle activityHandle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("Activity with handle " + activityHandle + " ended");
        }
        MAPDialogActivityHandle mdah = (MAPDialogActivityHandle)activityHandle;
        MAPDialogWrapper dw = mdah.getActivity();
        mdah.setActivity(null);
        if (dw != null) {
            dw.clear();
        }
    }

    public void activityUnreferenced(ActivityHandle arg0) {
    }

    public void administrativeRemove(ActivityHandle handle) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("administrativeRemove:" + handle);
        }
    }

    public void eventProcessingFailed(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags, FailureReason reason) {
        MAPDialogActivityHandle dah;
        MAPDialogWrapper dw;
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("eventProcessingFailed:" + eventType + ":" + handle);
        }
        if (eventType.getEventType().getName().equals("ss7.map.DIALOG_TIMEOUT") && (dw = (dah = (MAPDialogActivityHandle)handle).getActivity()) != null) {
            this.releaseDialog(dw);
        }
    }

    public void eventProcessingSuccessful(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
        MAPDialogActivityHandle dah;
        MAPDialogWrapper dw;
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("eventProcessingSuccessful:" + eventType + ":" + handle);
        }
        if (eventType.getEventType().getName().equals("ss7.map.DIALOG_TIMEOUT") && (dw = (dah = (MAPDialogActivityHandle)handle).getActivity()) != null && !dw.checkDialogTimeoutProcKeeped()) {
            this.releaseDialog(dw);
        }
    }

    public void eventUnreferenced(ActivityHandle handle, FireableEventType eventType, Object event, Address address, ReceivableService service, int flags) {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("eventUnreferenced:" + eventType + ":" + handle);
        }
    }

    private void releaseDialog(MAPDialogWrapper dw) {
        dw.release();
    }

    public Object getActivity(ActivityHandle handle) {
        return ((MAPDialogActivityHandle)handle).getActivity();
    }

    public ActivityHandle getActivityHandle(Object activity) {
        MAPDialogWrapper wrapper;
        if (activity instanceof MAPDialogWrapper && (wrapper = (MAPDialogWrapper)activity).getRa() == this) {
            return wrapper.getActivityHandle();
        }
        return null;
    }

    public Marshaler getMarshaler() {
        return this.marshaler;
    }

    public Object getResourceAdaptorInterface(String className) {
        return this.mapProvider;
    }

    public void queryLiveness(ActivityHandle activityHandle) {
        MAPDialogActivityHandle handle = (MAPDialogActivityHandle)activityHandle;
        MAPDialogWrapper mapDialog = handle.getActivity();
        if (mapDialog == null || mapDialog.getWrappedDialog() == null || mapDialog.getState() == MAPDialogState.EXPUNGED) {
            this.sleeEndpoint.endActivity((ActivityHandle)handle);
        }
    }

    public void raActive() {
        try {
            ObjectName objectName = new ObjectName("org.restcomm.ss7:service=MAPSS7Service");
            Object object = null;
            if (ManagementFactory.getPlatformMBeanServer().isRegistered(objectName)) {
                object = ManagementFactory.getPlatformMBeanServer().getAttribute(objectName, "Stack");
                if (this.tracer.isInfoEnabled()) {
                    this.tracer.info("Trying to get via MBeanServer: " + objectName + ", object: " + object);
                }
            } else {
                InitialContext ic = new InitialContext();
                object = ic.lookup(this.mapJndi);
                if (this.tracer.isInfoEnabled()) {
                    this.tracer.info("Trying to get via JNDI: " + this.mapJndi + ", object: " + object);
                }
            }
            if (object instanceof MAPProvider) {
                this.realProvider = (MAPProvider)object;
                if (this.tracer.isInfoEnabled()) {
                    this.tracer.info("Successfully connected to MAP service[" + this.realProvider.getClass().getCanonicalName() + "]");
                }
            } else if (this.tracer.isSevereEnabled()) {
                this.tracer.severe("Failed of connecting to MAP service[org.restcomm.ss7:service=MAPSS7Service]");
            }
            this.realProvider.addMAPDialogListener((MAPDialogListener)this);
            this.realProvider.getMAPServiceMobility().addMAPServiceListener((MAPServiceMobilityListener)this);
            this.realProvider.getMAPServiceCallHandling().addMAPServiceListener((MAPServiceCallHandlingListener)this);
            this.realProvider.getMAPServiceOam().addMAPServiceListener((MAPServiceOamListener)this);
            this.realProvider.getMAPServicePdpContextActivation().addMAPServiceListener((MAPServicePdpContextActivationListener)this);
            this.realProvider.getMAPServiceSupplementary().addMAPServiceListener((MAPServiceSupplementaryListener)this);
            this.realProvider.getMAPServiceSms().addMAPServiceListener((MAPServiceSmsListener)this);
            this.realProvider.getMAPServiceLsm().addMAPServiceListener((MAPServiceLsmListener)this);
            this.sleeEndpoint = this.resourceAdaptorContext.getSleeEndpoint();
            this.realProvider.getMAPServiceMobility().acivate();
            this.realProvider.getMAPServiceCallHandling().acivate();
            this.realProvider.getMAPServiceOam().acivate();
            this.realProvider.getMAPServicePdpContextActivation().acivate();
            this.realProvider.getMAPServiceSupplementary().acivate();
            this.realProvider.getMAPServiceSms().acivate();
            this.realProvider.getMAPServiceLsm().acivate();
            this.mapProvider.setWrappedProvider(this.realProvider);
        }
        catch (Exception e) {
            this.tracer.severe("Failed to activate MAP RA ", (Throwable)e);
        }
        this.ss7RAExtInterface.onRaActive(this.resourceAdaptorContext);
    }

    public void raConfigurationUpdate(ConfigProperties properties) {
        this.raConfigure(properties);
    }

    public void raConfigure(ConfigProperties properties) {
        try {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Configuring MAP RA: " + this.resourceAdaptorContext.getEntityName());
            }
            this.mapJndi = (String)properties.getProperty(CONF_MAP_JNDI).getValue();
        }
        catch (Exception e) {
            this.tracer.severe("Configuring of MAP RA failed ", (Throwable)e);
        }
        this.ss7RAExtInterface.onRaConfigure(properties);
    }

    public void raInactive() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("raInactive");
        }
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("MAP Resource Adaptor - inactivating");
        }
        this.realProvider.getMAPServiceMobility().deactivate();
        this.realProvider.getMAPServiceCallHandling().deactivate();
        this.realProvider.getMAPServiceOam().deactivate();
        this.realProvider.getMAPServicePdpContextActivation().deactivate();
        this.realProvider.getMAPServiceSupplementary().deactivate();
        this.realProvider.getMAPServiceLsm().deactivate();
        this.realProvider.getMAPServiceSms().deactivate();
        this.realProvider.getMAPServiceMobility().removeMAPServiceListener((MAPServiceMobilityListener)this);
        this.realProvider.getMAPServiceCallHandling().removeMAPServiceListener((MAPServiceCallHandlingListener)this);
        this.realProvider.getMAPServiceOam().removeMAPServiceListener((MAPServiceOamListener)this);
        this.realProvider.getMAPServicePdpContextActivation().removeMAPServiceListener((MAPServicePdpContextActivationListener)this);
        this.realProvider.getMAPServiceSupplementary().removeMAPServiceListener((MAPServiceSupplementaryListener)this);
        this.realProvider.getMAPServiceLsm().removeMAPServiceListener((MAPServiceLsmListener)this);
        this.realProvider.getMAPServiceSms().removeMAPServiceListener((MAPServiceSmsListener)this);
        this.realProvider.removeMAPDialogListener((MAPDialogListener)this);
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("MAP Resource Adaptor entity inactive.");
        }
    }

    public void raStopping() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("raStopping");
            this.tracer.fine("Ending all activities");
        }
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("MAP Resource Adaptor entity stopping.");
        }
    }

    public void raUnconfigure() {
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("raUnconfigure");
        }
        this.ss7RAExtInterface.onRaUnconfigure();
        this.mapJndi = null;
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("MAP Resource Adaptor unconfigured.");
        }
    }

    public void raVerifyConfiguration(ConfigProperties properties) throws InvalidConfigurationException {
        try {
            if (this.tracer.isInfoEnabled()) {
                this.tracer.info("Verifying configuring MAPRA: " + this.resourceAdaptorContext.getEntityName());
            }
            this.mapJndi = (String)properties.getProperty(CONF_MAP_JNDI).getValue();
            if (this.mapJndi == null) {
                throw new InvalidConfigurationException("MAP JNDI lookup name cannot be null");
            }
            this.ss7RAExtInterface.onRaVerifyConfiguration(properties);
        }
        catch (Exception e) {
            throw new InvalidConfigurationException("Failed to test configuration options!", (Throwable)e);
        }
        if (this.tracer.isInfoEnabled()) {
            this.tracer.info("MAP Resource Adaptor configuration verified.");
        }
    }

    public void serviceActive(ReceivableService receivableService) {
        this.eventIDFilter.serviceActive(receivableService);
    }

    public void serviceInactive(ReceivableService receivableService) {
        this.eventIDFilter.serviceInactive(receivableService);
    }

    public void serviceStopping(ReceivableService receivableService) {
        this.eventIDFilter.serviceStopping(receivableService);
    }

    public void setResourceAdaptorContext(ResourceAdaptorContext raContext) {
        this.resourceAdaptorContext = raContext;
        this.tracer = this.resourceAdaptorContext.getTracer(MAPResourceAdaptor.class.getSimpleName());
        this.sleeEndpoint = raContext.getSleeEndpoint();
        this.eventIdCache = new EventIDCache(this.tracer);
        try {
            this.defaultUsageParameters = (MAPResourceAdaptorStatisticsUsageParameters)raContext.getDefaultUsageParameterSet();
            this.tracer.info("defaultUsageParameters: " + this.defaultUsageParameters);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.ss7RAExtInterface.onSetResourceAdaptorContext(this.tracer);
    }

    public void unsetResourceAdaptorContext() {
        this.resourceAdaptorContext = null;
    }

    public void startActivity(MAPDialogWrapper mapDialogWrapper) throws ActivityAlreadyExistsException, NullPointerException, IllegalStateException, SLEEException, StartActivityException {
        this.sleeEndpoint.startActivity((ActivityHandle)mapDialogWrapper.getActivityHandle(), (Object)mapDialogWrapper, 2);
    }

    public void startSuspendedActivity(MAPDialogWrapper mapDialogWrapper) throws ActivityAlreadyExistsException, NullPointerException, IllegalStateException, SLEEException, StartActivityException {
        this.sleeEndpoint.startActivitySuspended((ActivityHandle)mapDialogWrapper.getActivityHandle(), (Object)mapDialogWrapper, 2);
    }

    private void endActivity(MAPDialogWrapper mapDialog) {
        MAPDialogActivityHandle mapDialogActHndl;
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine("endActivity:" + mapDialog);
        }
        if ((mapDialogActHndl = mapDialog.getActivityHandle()) == null) {
            if (this.tracer.isWarningEnabled()) {
                this.tracer.warning("Activity ended but no MAPDialogActivityHandle found for Dialog ID, ignoring " + mapDialog.getLocalDialogId());
            }
        } else {
            try {
                MAPUserAbortChoice ach = this.realProvider.getMAPParameterFactory().createMAPUserAbortChoice();
                ach.setUserSpecificReason();
                mapDialog.abort(ach);
            }
            catch (MAPException e) {
                this.tracer.warning("Cannot abort dialog ", (Throwable)e);
            }
            this.sleeEndpoint.endActivity((ActivityHandle)mapDialogActHndl);
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("Activity marked to be ended:" + mapDialog.getLocalDialogId());
            }
        }
    }

    private boolean fireEvent(String eventName, ActivityHandle handle, Object event, int flags) {
        FireableEventType eventID = this.eventIdCache.getEventId(this.resourceAdaptorContext.getEventLookupFacility(), eventName);
        if (this.eventIDFilter.filterEvent(eventID)) {
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine("Event " + (eventID == null ? "null" : eventID.getEventType()) + " filtered");
            }
            return false;
        }
        try {
            this.sleeEndpoint.fireEvent(handle, eventID, event, address, null, flags);
        }
        catch (UnrecognizedActivityHandleException e) {
            this.tracer.severe("Error while firing event", (Throwable)e);
        }
        catch (IllegalEventException e) {
            this.tracer.severe("Error while firing event", (Throwable)e);
        }
        catch (ActivityIsEndingException e) {
            this.tracer.severe("Error while firing event", (Throwable)e);
        }
        catch (NullPointerException e) {
            this.tracer.severe("Error while firing event", (Throwable)e);
        }
        catch (SLEEException e) {
            this.tracer.severe("Error while firing event", (Throwable)e);
        }
        catch (FireEventException e) {
            this.tracer.severe("Error while firing event", (Throwable)e);
        }
        return true;
    }

    private MAPDialogActivityHandle onEvent(String eventName, MAPDialogWrapper dw, MAPEvent event) {
        return this.onEvent(eventName, dw, event, 0);
    }

    private MAPDialogActivityHandle onEvent(String eventName, MAPDialogWrapper dw, MAPEvent event, int flags) {
        if (dw == null) {
            this.tracer.severe(String.format("Firing %s but MAPDialogWrapper userObject is null", eventName));
            return null;
        }
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine(String.format("Firing %s for DialogId=%d", eventName, dw.getWrappedDialog().getLocalDialogId()));
        }
        this.fireEvent(eventName, dw.getActivityHandle(), event, flags);
        return dw.getActivityHandle();
    }

    public void onDialogAccept(MAPDialog mapDialog, MAPExtensionContainer extension) {
        MAPDialogWrapper mapDialogWrapper = (MAPDialogWrapper)mapDialog.getUserObject();
        DialogAccept dialogAccept = new DialogAccept((MAPDialog)mapDialogWrapper, extension);
        this.onEvent(dialogAccept.getEventTypeName(), mapDialogWrapper, (MAPEvent)dialogAccept);
    }

    public void onDialogClose(MAPDialog mapDialog) {
        MAPDialogWrapper mapDialogWrapper = (MAPDialogWrapper)mapDialog.getUserObject();
        DialogClose dialogClose = new DialogClose((MAPDialog)mapDialogWrapper);
        MAPDialogActivityHandle handle = this.onEvent(dialogClose.getEventTypeName(), mapDialogWrapper, (MAPEvent)dialogClose);
    }

    public void onDialogDelimiter(MAPDialog mapDialog) {
        MAPDialogWrapper mapDialogWrapper = (MAPDialogWrapper)mapDialog.getUserObject();
        DialogDelimiter dialogDelimiter = new DialogDelimiter((MAPDialog)mapDialogWrapper);
        this.onEvent(dialogDelimiter.getEventTypeName(), mapDialogWrapper, (MAPEvent)dialogDelimiter);
    }

    public void onDialogNotice(MAPDialog mapDialog, MAPNoticeProblemDiagnostic noticeProblemDiagnostic) {
        MAPDialogWrapper mapDialogWrapper = (MAPDialogWrapper)mapDialog.getUserObject();
        DialogNotice dialogNotice = new DialogNotice((MAPDialog)mapDialogWrapper, noticeProblemDiagnostic);
        this.onEvent(dialogNotice.getEventTypeName(), mapDialogWrapper, (MAPEvent)dialogNotice);
    }

    public void onDialogProviderAbort(MAPDialog mapDialog, MAPAbortProviderReason abortProviderReason, MAPAbortSource abortSource, MAPExtensionContainer extensionContainer) {
        MAPDialogWrapper mapDialogWrapper = (MAPDialogWrapper)mapDialog.getUserObject();
        DialogProviderAbort dialogProviderAbort = new DialogProviderAbort((MAPDialog)mapDialogWrapper, abortProviderReason, abortSource, extensionContainer);
        MAPDialogActivityHandle handle = this.onEvent(dialogProviderAbort.getEventTypeName(), mapDialogWrapper, (MAPEvent)dialogProviderAbort);
    }

    public void onDialogReject(MAPDialog mapDialog, MAPRefuseReason refuseReason, ApplicationContextName alternativeApplicationContext, MAPExtensionContainer extensionContainer) {
        MAPDialogWrapper mapDialogWrapper = (MAPDialogWrapper)mapDialog.getUserObject();
        DialogReject dialogReject = new DialogReject((MAPDialog)mapDialogWrapper, refuseReason, alternativeApplicationContext, extensionContainer);
        MAPDialogActivityHandle handle = this.onEvent(dialogReject.getEventTypeName(), mapDialogWrapper, (MAPEvent)dialogReject);
    }

    private void handleDialogRequest(MAPDialog mapDialog, AddressString destReference, AddressString origReference, MAPExtensionContainer extensionContainer, AddressString eriMsisdn, AddressString eriVlrNo) {
        try {
            if (this.tracer.isFineEnabled()) {
                this.tracer.fine(String.format("Received onDialogRequest id=%d ", mapDialog.getLocalDialogId()));
            }
            MAPDialogActivityHandle activityHandle = new MAPDialogActivityHandle(mapDialog.getLocalDialogId());
            MAPDialogWrapper mapDialogWrapper = null;
            if (mapDialog instanceof MAPDialogMobility) {
                mapDialogWrapper = new MAPDialogMobilityWrapper((MAPDialogMobility)mapDialog, activityHandle, this);
            } else if (mapDialog instanceof MAPDialogOam) {
                mapDialogWrapper = new MAPDialogOamWrapper((MAPDialogOam)mapDialog, activityHandle, this);
            } else if (mapDialog instanceof MAPDialogCallHandling) {
                mapDialogWrapper = new MAPDialogCallHandlingWrapper((MAPDialogCallHandling)mapDialog, activityHandle, this);
            } else if (mapDialog instanceof MAPDialogPdpContextActivation) {
                mapDialogWrapper = new MAPDialogPdpContextActivationWrapper((MAPDialogPdpContextActivation)mapDialog, activityHandle, this);
            } else if (mapDialog instanceof MAPDialogSupplementary) {
                mapDialogWrapper = new MAPDialogSupplementaryWrapper((MAPDialogSupplementary)mapDialog, activityHandle, this);
            } else if (mapDialog instanceof MAPDialogSms) {
                mapDialogWrapper = new MAPDialogSmsWrapper((MAPDialogSms)mapDialog, activityHandle, this);
            } else if (mapDialog instanceof MAPDialogLsm) {
                mapDialogWrapper = new MAPDialogLsmWrapper((MAPDialogLsm)mapDialog, activityHandle, this);
            } else {
                this.tracer.severe(String.format("Received onDialogRequest id=%d for unknown MAPDialog class=%s", mapDialog.getLocalDialogId(), mapDialog.getClass().getName()));
                return;
            }
            DialogRequest event = new DialogRequest((MAPDialog)mapDialogWrapper, destReference, origReference, extensionContainer, eriMsisdn, eriVlrNo);
            mapDialog.setUserObject((Object)mapDialogWrapper);
            this.startActivity(mapDialogWrapper);
            this.fireEvent(event.getEventTypeName(), mapDialogWrapper.getActivityHandle(), event, 0);
        }
        catch (Exception e) {
            this.tracer.severe(String.format("Exception when trying to fire event DIALOG_REQUEST for received DialogRequest=%s ", mapDialog), (Throwable)e);
        }
    }

    public void onDialogRequest(MAPDialog mapDialog, AddressString destReference, AddressString origReference, MAPExtensionContainer extensionContainer) {
        this.handleDialogRequest(mapDialog, destReference, origReference, extensionContainer, null, null);
    }

    public void onDialogRequestEricsson(MAPDialog mapDialog, AddressString destReference, AddressString origReference, AddressString eriMsisdn, AddressString eriVlrNo) {
        this.handleDialogRequest(mapDialog, destReference, origReference, null, eriMsisdn, eriVlrNo);
    }

    public void onDialogUserAbort(MAPDialog mapDialog, MAPUserAbortChoice userReason, MAPExtensionContainer extensionContainer) {
        MAPDialogWrapper mapDialogWrapper = (MAPDialogWrapper)mapDialog.getUserObject();
        DialogUserAbort dialogUserAbort = new DialogUserAbort((MAPDialog)mapDialogWrapper, userReason, extensionContainer);
        MAPDialogActivityHandle handle = this.onEvent(dialogUserAbort.getEventTypeName(), mapDialogWrapper, (MAPEvent)dialogUserAbort);
    }

    public void onDialogRelease(MAPDialog mapDialog) {
        try {
            MAPDialogWrapper mapDialogWrapper = (MAPDialogWrapper)mapDialog.getUserObject();
            DialogRelease dialogRelease = new DialogRelease((MAPDialog)mapDialogWrapper);
            MAPDialogActivityHandle handle = this.onEvent(dialogRelease.getEventTypeName(), mapDialogWrapper, (MAPEvent)dialogRelease);
            this.sleeEndpoint.endActivity((ActivityHandle)handle);
        }
        catch (Exception e) {
            this.tracer.severe(String.format("onDialogRelease : Exception while trying to end activity for MAPDialog=%s", mapDialog), (Throwable)e);
        }
    }

    public void onDialogTimeout(MAPDialog mapDialog) {
        boolean fired;
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine(String.format("Rx : onDialogTimeout for DialogId=%d", mapDialog.getLocalDialogId()));
        }
        mapDialog.keepAlive();
        MAPDialogWrapper mapDialogWrapper = (MAPDialogWrapper)mapDialog.getUserObject();
        DialogTimeout dt = new DialogTimeout((MAPDialog)mapDialogWrapper);
        if (mapDialogWrapper == null) {
            this.tracer.severe(String.format("Firing %s but MAPDialogWrapper userObject is null", dt.getEventTypeName()));
            mapDialog.release();
            return;
        }
        mapDialogWrapper.startDialogTimeoutProc();
        if (this.tracer.isFineEnabled()) {
            this.tracer.fine(String.format("Firing %s for DialogId=%d", dt.getEventTypeName(), mapDialogWrapper.getWrappedDialog().getLocalDialogId()));
        }
        if (!(fired = this.fireEvent(dt.getEventTypeName(), mapDialogWrapper.getActivityHandle(), dt, 96))) {
            mapDialogWrapper.release();
        }
    }

    public void onInvokeTimeout(MAPDialog mapDialog, Long invokeId) {
        MAPDialogWrapper mapDialogWrapper = (MAPDialogWrapper)mapDialog.getUserObject();
        InvokeTimeout invokeTimeout = new InvokeTimeout((MAPDialog)mapDialogWrapper, invokeId);
        this.onEvent(invokeTimeout.getEventTypeName(), mapDialogWrapper, (MAPEvent)invokeTimeout);
    }

    public void onErrorComponent(MAPDialog mapDialog, Long invokeId, MAPErrorMessage mapErrorMessage) {
        MAPDialogWrapper mapDialogWrapper = (MAPDialogWrapper)mapDialog.getUserObject();
        ErrorComponent errorComponent = new ErrorComponent((MAPDialog)mapDialogWrapper, invokeId, mapErrorMessage);
        this.onEvent(errorComponent.getEventTypeName(), mapDialogWrapper, (MAPEvent)errorComponent);
    }

    public void onRejectComponent(MAPDialog mapDialog, Long invokeId, Problem problem, boolean isLocalOriginated) {
        MAPDialogWrapper mapDialogWrapper = (MAPDialogWrapper)mapDialog.getUserObject();
        RejectComponent rejectComponent = new RejectComponent((MAPDialog)mapDialogWrapper, invokeId, problem, isLocalOriginated);
        this.onEvent(rejectComponent.getEventTypeName(), mapDialogWrapper, (MAPEvent)rejectComponent);
    }

    public void onUpdateLocationRequest(UpdateLocationRequest ind) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)ind.getMAPDialog().getUserObject();
        UpdateLocationRequestWrapper event = new UpdateLocationRequestWrapper(mapDialogMobilityWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onUpdateLocationResponse(UpdateLocationResponse ind) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)ind.getMAPDialog().getUserObject();
        UpdateLocationResponseWrapper event = new UpdateLocationResponseWrapper(mapDialogMobilityWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onCancelLocationRequest(CancelLocationRequest ind) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)ind.getMAPDialog().getUserObject();
        CancelLocationRequestWrapper event = new CancelLocationRequestWrapper(mapDialogMobilityWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onCancelLocationResponse(CancelLocationResponse ind) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)ind.getMAPDialog().getUserObject();
        CancelLocationResponseWrapper event = new CancelLocationResponseWrapper(mapDialogMobilityWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onSendIdentificationRequest(SendIdentificationRequest ind) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)ind.getMAPDialog().getUserObject();
        SendIdentificationRequestWrapper event = new SendIdentificationRequestWrapper(mapDialogMobilityWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onSendIdentificationResponse(SendIdentificationResponse ind) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)ind.getMAPDialog().getUserObject();
        SendIdentificationResponseWrapper event = new SendIdentificationResponseWrapper(mapDialogMobilityWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onPurgeMSRequest(PurgeMSRequest ind) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)ind.getMAPDialog().getUserObject();
        PurgeMSRequestWrapper event = new PurgeMSRequestWrapper(mapDialogMobilityWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onPurgeMSResponse(PurgeMSResponse ind) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)ind.getMAPDialog().getUserObject();
        PurgeMSResponseWrapper event = new PurgeMSResponseWrapper(mapDialogMobilityWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onUpdateGprsLocationRequest(UpdateGprsLocationRequest ind) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)ind.getMAPDialog().getUserObject();
        UpdateGprsLocationRequestWrapper event = new UpdateGprsLocationRequestWrapper(mapDialogMobilityWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onUpdateGprsLocationResponse(UpdateGprsLocationResponse ind) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)ind.getMAPDialog().getUserObject();
        UpdateGprsLocationResponseWrapper event = new UpdateGprsLocationResponseWrapper(mapDialogMobilityWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onSendAuthenticationInfoRequest(SendAuthenticationInfoRequest ind) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)ind.getMAPDialog().getUserObject();
        SendAuthenticationInfoRequestWrapper event = new SendAuthenticationInfoRequestWrapper(mapDialogMobilityWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onSendAuthenticationInfoResponse(SendAuthenticationInfoResponse ind) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)ind.getMAPDialog().getUserObject();
        SendAuthenticationInfoResponseWrapper event = new SendAuthenticationInfoResponseWrapper(mapDialogMobilityWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onAuthenticationFailureReportRequest(AuthenticationFailureReportRequest ind) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)ind.getMAPDialog().getUserObject();
        AuthenticationFailureReportRequestWrapper event = new AuthenticationFailureReportRequestWrapper(mapDialogMobilityWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onAuthenticationFailureReportResponse(AuthenticationFailureReportResponse ind) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)ind.getMAPDialog().getUserObject();
        AuthenticationFailureReportResponseWrapper event = new AuthenticationFailureReportResponseWrapper(mapDialogMobilityWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onResetRequest(ResetRequest ind) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)ind.getMAPDialog().getUserObject();
        ResetRequestWrapper event = new ResetRequestWrapper(mapDialogMobilityWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onForwardCheckSSIndicationRequest(ForwardCheckSSIndicationRequest ind) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)ind.getMAPDialog().getUserObject();
        ForwardCheckSSIndicationRequestWrapper event = new ForwardCheckSSIndicationRequestWrapper(mapDialogMobilityWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onRestoreDataRequest(RestoreDataRequest ind) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)ind.getMAPDialog().getUserObject();
        RestoreDataRequestWrapper event = new RestoreDataRequestWrapper(mapDialogMobilityWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onRestoreDataResponse(RestoreDataResponse ind) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)ind.getMAPDialog().getUserObject();
        RestoreDataResponseWrapper event = new RestoreDataResponseWrapper(mapDialogMobilityWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onCheckImeiRequest(CheckImeiRequest ind) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)ind.getMAPDialog().getUserObject();
        CheckImeiRequestWrapper event = new CheckImeiRequestWrapper(mapDialogMobilityWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onCheckImeiResponse(CheckImeiResponse ind) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)ind.getMAPDialog().getUserObject();
        CheckImeiResponseWrapper event = new CheckImeiResponseWrapper(mapDialogMobilityWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onInsertSubscriberDataRequest(InsertSubscriberDataRequest ind) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)ind.getMAPDialog().getUserObject();
        InsertSubscriberDataRequestWrapper event = new InsertSubscriberDataRequestWrapper(mapDialogMobilityWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onInsertSubscriberDataResponse(InsertSubscriberDataResponse ind) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)ind.getMAPDialog().getUserObject();
        InsertSubscriberDataResponseWrapper event = new InsertSubscriberDataResponseWrapper(mapDialogMobilityWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onDeleteSubscriberDataRequest(DeleteSubscriberDataRequest request) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)request.getMAPDialog().getUserObject();
        DeleteSubscriberDataRequestWrapper event = new DeleteSubscriberDataRequestWrapper(mapDialogMobilityWrapper, request);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onDeleteSubscriberDataResponse(DeleteSubscriberDataResponse request) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)request.getMAPDialog().getUserObject();
        DeleteSubscriberDataResponseWrapper event = new DeleteSubscriberDataResponseWrapper(mapDialogMobilityWrapper, request);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onAnyTimeInterrogationRequest(AnyTimeInterrogationRequest anyTimeInterrogationRequest) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)anyTimeInterrogationRequest.getMAPDialog().getUserObject();
        AnyTimeInterrogationRequestWrapper event = new AnyTimeInterrogationRequestWrapper(mapDialogMobilityWrapper, anyTimeInterrogationRequest);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onAnyTimeInterrogationResponse(AnyTimeInterrogationResponse anyTimeInterrogationResponse) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)anyTimeInterrogationResponse.getMAPDialog().getUserObject();
        AnyTimeInterrogationResponseWrapper event = new AnyTimeInterrogationResponseWrapper(mapDialogMobilityWrapper, anyTimeInterrogationResponse);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onAnyTimeSubscriptionInterrogationRequest(AnyTimeSubscriptionInterrogationRequest request) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)request.getMAPDialog().getUserObject();
        AnyTimeSubscriptionInterrogationRequestWrapper event = new AnyTimeSubscriptionInterrogationRequestWrapper(mapDialogMobilityWrapper, request);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onAnyTimeSubscriptionInterrogationResponse(AnyTimeSubscriptionInterrogationResponse response) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)response.getMAPDialog().getUserObject();
        AnyTimeSubscriptionInterrogationResponseWrapper event = new AnyTimeSubscriptionInterrogationResponseWrapper(mapDialogMobilityWrapper, response);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onProvideSubscriberInfoRequest(ProvideSubscriberInfoRequest request) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)request.getMAPDialog().getUserObject();
        ProvideSubscriberInfoRequestWrapper event = new ProvideSubscriberInfoRequestWrapper(mapDialogMobilityWrapper, request);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onProvideSubscriberInfoResponse(ProvideSubscriberInfoResponse response) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)response.getMAPDialog().getUserObject();
        ProvideSubscriberInfoResponseWrapper event = new ProvideSubscriberInfoResponseWrapper(mapDialogMobilityWrapper, response);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onSendImsiRequest(SendImsiRequest request) {
        MAPDialogOamWrapper mapDialogOamWrapper = (MAPDialogOamWrapper)request.getMAPDialog().getUserObject();
        SendImsiRequestWrapper event = new SendImsiRequestWrapper(mapDialogOamWrapper, request);
        this.onEvent(event.getEventTypeName(), mapDialogOamWrapper, event);
    }

    public void onSendImsiResponse(SendImsiResponse request) {
        MAPDialogOamWrapper mapDialogOamWrapper = (MAPDialogOamWrapper)request.getMAPDialog().getUserObject();
        SendImsiResponseWrapper event = new SendImsiResponseWrapper(mapDialogOamWrapper, request);
        this.onEvent(event.getEventTypeName(), mapDialogOamWrapper, event);
    }

    public void onActivateTraceModeRequest_Oam(ActivateTraceModeRequest_Oam request) {
        MAPDialogOamWrapper mapDialogOamWrapper = (MAPDialogOamWrapper)request.getMAPDialog().getUserObject();
        ActivateTraceModeRequest_OamWrapper event = new ActivateTraceModeRequest_OamWrapper(mapDialogOamWrapper, request);
        this.onEvent(event.getEventTypeName(), mapDialogOamWrapper, event);
    }

    public void onActivateTraceModeResponse_Oam(ActivateTraceModeResponse_Oam response) {
        MAPDialogOamWrapper mapDialogOamWrapper = (MAPDialogOamWrapper)response.getMAPDialog().getUserObject();
        ActivateTraceModeResponse_OamWrapper event = new ActivateTraceModeResponse_OamWrapper(mapDialogOamWrapper, response);
        this.onEvent(event.getEventTypeName(), mapDialogOamWrapper, event);
    }

    public void onActivateTraceModeRequest_Mobility(ActivateTraceModeRequest_Mobility request) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)request.getMAPDialog().getUserObject();
        ActivateTraceModeRequest_MobilityWrapper event = new ActivateTraceModeRequest_MobilityWrapper(mapDialogMobilityWrapper, request);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onActivateTraceModeResponse_Mobility(ActivateTraceModeResponse_Mobility response) {
        MAPDialogMobilityWrapper mapDialogMobilityWrapper = (MAPDialogMobilityWrapper)response.getMAPDialog().getUserObject();
        ActivateTraceModeResponse_MobilityWrapper event = new ActivateTraceModeResponse_MobilityWrapper(mapDialogMobilityWrapper, response);
        this.onEvent(event.getEventTypeName(), mapDialogMobilityWrapper, event);
    }

    public void onSendRoutingInformationRequest(SendRoutingInformationRequest ind) {
        MAPDialogCallHandlingWrapper mapDialogCallHandlingWrapper = (MAPDialogCallHandlingWrapper)ind.getMAPDialog().getUserObject();
        SendRoutingInformationRequestWrapper event = new SendRoutingInformationRequestWrapper(mapDialogCallHandlingWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogCallHandlingWrapper, event);
    }

    public void onSendRoutingInformationResponse(SendRoutingInformationResponse ind) {
        MAPDialogCallHandlingWrapper mapDialogCallHandlingWrapper = (MAPDialogCallHandlingWrapper)ind.getMAPDialog().getUserObject();
        SendRoutingInformationResponseWrapper event = new SendRoutingInformationResponseWrapper(mapDialogCallHandlingWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogCallHandlingWrapper, event);
    }

    public void onProvideRoamingNumberRequest(ProvideRoamingNumberRequest ind) {
        MAPDialogCallHandlingWrapper mapDialogCallHandlingWrapper = (MAPDialogCallHandlingWrapper)ind.getMAPDialog().getUserObject();
        ProvideRoamingNumberRequestWrapper event = new ProvideRoamingNumberRequestWrapper(mapDialogCallHandlingWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogCallHandlingWrapper, event);
    }

    public void onProvideRoamingNumberResponse(ProvideRoamingNumberResponse ind) {
        MAPDialogCallHandlingWrapper mapDialogCallHandlingWrapper = (MAPDialogCallHandlingWrapper)ind.getMAPDialog().getUserObject();
        ProvideRoamingNumberResponseWrapper event = new ProvideRoamingNumberResponseWrapper(mapDialogCallHandlingWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogCallHandlingWrapper, event);
    }

    public void onIstCommandRequest(IstCommandRequest ind) {
        MAPDialogCallHandlingWrapper mapDialogCallHandlingWrapper = (MAPDialogCallHandlingWrapper)ind.getMAPDialog().getUserObject();
        IstCommandRequestWrapper event = new IstCommandRequestWrapper(mapDialogCallHandlingWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogCallHandlingWrapper, event);
    }

    public void onIstCommandResponse(IstCommandResponse ind) {
        MAPDialogCallHandlingWrapper mapDialogCallHandlingWrapper = (MAPDialogCallHandlingWrapper)ind.getMAPDialog().getUserObject();
        IstCommandResponseWrapper event = new IstCommandResponseWrapper(mapDialogCallHandlingWrapper, ind);
        this.onEvent(event.getEventTypeName(), mapDialogCallHandlingWrapper, event);
    }

    public void onRegisterSSRequest(RegisterSSRequest request) {
        MAPDialogSupplementaryWrapper mapDialogSupplementaryWrapper = (MAPDialogSupplementaryWrapper)request.getMAPDialog().getUserObject();
        RegisterSSRequestWrapper event = new RegisterSSRequestWrapper(mapDialogSupplementaryWrapper, request);
        this.onEvent(event.getEventTypeName(), mapDialogSupplementaryWrapper, event);
    }

    public void onRegisterSSResponse(RegisterSSResponse response) {
        MAPDialogSupplementaryWrapper mapDialogSupplementaryWrapper = (MAPDialogSupplementaryWrapper)response.getMAPDialog().getUserObject();
        RegisterSSResponseWrapper event = new RegisterSSResponseWrapper(mapDialogSupplementaryWrapper, response);
        this.onEvent(event.getEventTypeName(), mapDialogSupplementaryWrapper, event);
    }

    public void onEraseSSRequest(EraseSSRequest request) {
        MAPDialogSupplementaryWrapper mapDialogSupplementaryWrapper = (MAPDialogSupplementaryWrapper)request.getMAPDialog().getUserObject();
        EraseSSRequestWrapper event = new EraseSSRequestWrapper(mapDialogSupplementaryWrapper, request);
        this.onEvent(event.getEventTypeName(), mapDialogSupplementaryWrapper, event);
    }

    public void onEraseSSResponse(EraseSSResponse response) {
        MAPDialogSupplementaryWrapper mapDialogSupplementaryWrapper = (MAPDialogSupplementaryWrapper)response.getMAPDialog().getUserObject();
        EraseSSResponseWrapper event = new EraseSSResponseWrapper(mapDialogSupplementaryWrapper, response);
        this.onEvent(event.getEventTypeName(), mapDialogSupplementaryWrapper, event);
    }

    public void onActivateSSRequest(ActivateSSRequest request) {
        MAPDialogSupplementaryWrapper mapDialogSupplementaryWrapper = (MAPDialogSupplementaryWrapper)request.getMAPDialog().getUserObject();
        ActivateSSRequestWrapper event = new ActivateSSRequestWrapper(mapDialogSupplementaryWrapper, request);
        this.onEvent(event.getEventTypeName(), mapDialogSupplementaryWrapper, event);
    }

    public void onActivateSSResponse(ActivateSSResponse response) {
        MAPDialogSupplementaryWrapper mapDialogSupplementaryWrapper = (MAPDialogSupplementaryWrapper)response.getMAPDialog().getUserObject();
        ActivateSSResponseWrapper event = new ActivateSSResponseWrapper(mapDialogSupplementaryWrapper, response);
        this.onEvent(event.getEventTypeName(), mapDialogSupplementaryWrapper, event);
    }

    public void onDeactivateSSRequest(DeactivateSSRequest request) {
        MAPDialogSupplementaryWrapper mapDialogSupplementaryWrapper = (MAPDialogSupplementaryWrapper)request.getMAPDialog().getUserObject();
        DeactivateSSRequestWrapper event = new DeactivateSSRequestWrapper(mapDialogSupplementaryWrapper, request);
        this.onEvent(event.getEventTypeName(), mapDialogSupplementaryWrapper, event);
    }

    public void onDeactivateSSResponse(DeactivateSSResponse response) {
        MAPDialogSupplementaryWrapper mapDialogSupplementaryWrapper = (MAPDialogSupplementaryWrapper)response.getMAPDialog().getUserObject();
        DeactivateSSResponseWrapper event = new DeactivateSSResponseWrapper(mapDialogSupplementaryWrapper, response);
        this.onEvent(event.getEventTypeName(), mapDialogSupplementaryWrapper, event);
    }

    public void onInterrogateSSRequest(InterrogateSSRequest request) {
        MAPDialogSupplementaryWrapper mapDialogSupplementaryWrapper = (MAPDialogSupplementaryWrapper)request.getMAPDialog().getUserObject();
        InterrogateSSRequestWrapper event = new InterrogateSSRequestWrapper(mapDialogSupplementaryWrapper, request);
        this.onEvent(event.getEventTypeName(), mapDialogSupplementaryWrapper, event);
    }

    public void onInterrogateSSResponse(InterrogateSSResponse response) {
        MAPDialogSupplementaryWrapper mapDialogSupplementaryWrapper = (MAPDialogSupplementaryWrapper)response.getMAPDialog().getUserObject();
        InterrogateSSResponseWrapper event = new InterrogateSSResponseWrapper(mapDialogSupplementaryWrapper, response);
        this.onEvent(event.getEventTypeName(), mapDialogSupplementaryWrapper, event);
    }

    public void onGetPasswordRequest(GetPasswordRequest request) {
        MAPDialogSupplementaryWrapper mapDialogSupplementaryWrapper = (MAPDialogSupplementaryWrapper)request.getMAPDialog().getUserObject();
        GetPasswordRequestWrapper event = new GetPasswordRequestWrapper(mapDialogSupplementaryWrapper, request);
        this.onEvent(event.getEventTypeName(), mapDialogSupplementaryWrapper, event);
    }

    public void onGetPasswordResponse(GetPasswordResponse response) {
        MAPDialogSupplementaryWrapper mapDialogSupplementaryWrapper = (MAPDialogSupplementaryWrapper)response.getMAPDialog().getUserObject();
        GetPasswordResponseWrapper event = new GetPasswordResponseWrapper(mapDialogSupplementaryWrapper, response);
        this.onEvent(event.getEventTypeName(), mapDialogSupplementaryWrapper, event);
    }

    public void onRegisterPasswordRequest(RegisterPasswordRequest request) {
        MAPDialogSupplementaryWrapper mapDialogSupplementaryWrapper = (MAPDialogSupplementaryWrapper)request.getMAPDialog().getUserObject();
        RegisterPasswordRequestWrapper event = new RegisterPasswordRequestWrapper(mapDialogSupplementaryWrapper, request);
        this.onEvent(event.getEventTypeName(), mapDialogSupplementaryWrapper, event);
    }

    public void onRegisterPasswordResponse(RegisterPasswordResponse response) {
        MAPDialogSupplementaryWrapper mapDialogSupplementaryWrapper = (MAPDialogSupplementaryWrapper)response.getMAPDialog().getUserObject();
        RegisterPasswordResponseWrapper event = new RegisterPasswordResponseWrapper(mapDialogSupplementaryWrapper, response);
        this.onEvent(event.getEventTypeName(), mapDialogSupplementaryWrapper, event);
    }

    public void onProcessUnstructuredSSRequest(ProcessUnstructuredSSRequest processUnstrSSInd) {
        MAPDialogSupplementaryWrapper mapDialogSupplementaryWrapper = (MAPDialogSupplementaryWrapper)processUnstrSSInd.getMAPDialog().getUserObject();
        ProcessUnstructuredSSRequestWrapper event = new ProcessUnstructuredSSRequestWrapper(mapDialogSupplementaryWrapper, processUnstrSSInd);
        this.onEvent(event.getEventTypeName(), mapDialogSupplementaryWrapper, event);
    }

    public void onProcessUnstructuredSSResponse(ProcessUnstructuredSSResponse processUnstructuredSSResponse) {
        MAPDialogSupplementaryWrapper mapDialogSupplementaryWrapper = (MAPDialogSupplementaryWrapper)processUnstructuredSSResponse.getMAPDialog().getUserObject();
        ProcessUnstructuredSSResponseWrapper event = new ProcessUnstructuredSSResponseWrapper(mapDialogSupplementaryWrapper, processUnstructuredSSResponse);
        this.onEvent(event.getEventTypeName(), mapDialogSupplementaryWrapper, event);
    }

    public void onUnstructuredSSRequest(UnstructuredSSRequest unstructuredSSRequest) {
        MAPDialogSupplementaryWrapper mapDialogSupplementaryWrapper = (MAPDialogSupplementaryWrapper)unstructuredSSRequest.getMAPDialog().getUserObject();
        UnstructuredSSRequestWrapper event = new UnstructuredSSRequestWrapper(mapDialogSupplementaryWrapper, unstructuredSSRequest);
        this.onEvent(event.getEventTypeName(), mapDialogSupplementaryWrapper, event);
    }

    public void onUnstructuredSSResponse(UnstructuredSSResponse unstructuredSSResponse) {
        MAPDialogSupplementaryWrapper mapDialogSupplementaryWrapper = (MAPDialogSupplementaryWrapper)unstructuredSSResponse.getMAPDialog().getUserObject();
        UnstructuredSSResponseWrapper event = new UnstructuredSSResponseWrapper(mapDialogSupplementaryWrapper, unstructuredSSResponse);
        this.onEvent(event.getEventTypeName(), mapDialogSupplementaryWrapper, event);
    }

    public void onUnstructuredSSNotifyRequest(UnstructuredSSNotifyRequest unstructuredSSNotifyRequest) {
        MAPDialogSupplementaryWrapper mapDialogSupplementaryWrapper = (MAPDialogSupplementaryWrapper)unstructuredSSNotifyRequest.getMAPDialog().getUserObject();
        UnstructuredSSNotifyRequestWrapper event = new UnstructuredSSNotifyRequestWrapper(mapDialogSupplementaryWrapper, unstructuredSSNotifyRequest);
        this.onEvent(event.getEventTypeName(), mapDialogSupplementaryWrapper, event);
    }

    public void onUnstructuredSSNotifyResponse(UnstructuredSSNotifyResponse unstructuredSSNotifyResponse) {
        MAPDialogSupplementaryWrapper mapDialogSupplementaryWrapper = (MAPDialogSupplementaryWrapper)unstructuredSSNotifyResponse.getMAPDialog().getUserObject();
        UnstructuredSSNotifyResponseWrapper event = new UnstructuredSSNotifyResponseWrapper(mapDialogSupplementaryWrapper, unstructuredSSNotifyResponse);
        this.onEvent(event.getEventTypeName(), mapDialogSupplementaryWrapper, event);
    }

    public void onForwardShortMessageRequest(ForwardShortMessageRequest forwardShortMessageRequest) {
        this.defaultUsageParameters.incrementMessages(1L);
        MAPDialogSmsWrapper mapDialogSmsWrapper = (MAPDialogSmsWrapper)forwardShortMessageRequest.getMAPDialog().getUserObject();
        ForwardShortMessageRequestWrapper event = new ForwardShortMessageRequestWrapper(mapDialogSmsWrapper, forwardShortMessageRequest);
        this.onEvent(event.getEventTypeName(), mapDialogSmsWrapper, event);
    }

    public void onForwardShortMessageResponse(ForwardShortMessageResponse forwardShortMessageResponse) {
        MAPDialogSmsWrapper mapDialogSmsWrapper = (MAPDialogSmsWrapper)forwardShortMessageResponse.getMAPDialog().getUserObject();
        ForwardShortMessageResponseWrapper event = new ForwardShortMessageResponseWrapper(mapDialogSmsWrapper, forwardShortMessageResponse);
        this.onEvent(event.getEventTypeName(), mapDialogSmsWrapper, event);
    }

    public void onMoForwardShortMessageRequest(MoForwardShortMessageRequest moForwardShortMessageRequest) {
        this.defaultUsageParameters.incrementMessages(1L);
        MAPDialogSmsWrapper mapDialogSmsWrapper = (MAPDialogSmsWrapper)moForwardShortMessageRequest.getMAPDialog().getUserObject();
        MoForwardShortMessageRequestWrapper event = new MoForwardShortMessageRequestWrapper(mapDialogSmsWrapper, moForwardShortMessageRequest);
        this.onEvent(event.getEventTypeName(), mapDialogSmsWrapper, event);
    }

    public void onMoForwardShortMessageResponse(MoForwardShortMessageResponse moForwardShortMessageResponse) {
        MAPDialogSmsWrapper mapDialogSmsWrapper = (MAPDialogSmsWrapper)moForwardShortMessageResponse.getMAPDialog().getUserObject();
        MoForwardShortMessageResponseWrapper event = new MoForwardShortMessageResponseWrapper(mapDialogSmsWrapper, moForwardShortMessageResponse);
        this.onEvent(event.getEventTypeName(), mapDialogSmsWrapper, event);
    }

    public void onMtForwardShortMessageRequest(MtForwardShortMessageRequest mtForwardShortMessageRequest) {
        this.defaultUsageParameters.incrementMessages(1L);
        MAPDialogSmsWrapper mapDialogSmsWrapper = (MAPDialogSmsWrapper)mtForwardShortMessageRequest.getMAPDialog().getUserObject();
        MtForwardShortMessageRequestWrapper event = new MtForwardShortMessageRequestWrapper(mapDialogSmsWrapper, mtForwardShortMessageRequest);
        this.onEvent(event.getEventTypeName(), mapDialogSmsWrapper, event);
    }

    public void onMtForwardShortMessageResponse(MtForwardShortMessageResponse mtForwardShortMessageResponse) {
        MAPDialogSmsWrapper mapDialogSmsWrapper = (MAPDialogSmsWrapper)mtForwardShortMessageResponse.getMAPDialog().getUserObject();
        MtForwardShortMessageResponseWrapper event = new MtForwardShortMessageResponseWrapper(mapDialogSmsWrapper, mtForwardShortMessageResponse);
        this.onEvent(event.getEventTypeName(), mapDialogSmsWrapper, event);
    }

    public void onSendRoutingInfoForSMRequest(SendRoutingInfoForSMRequest sendRoutingInfoForSMRequest) {
        MAPDialogSmsWrapper mapDialogSmsWrapper = (MAPDialogSmsWrapper)sendRoutingInfoForSMRequest.getMAPDialog().getUserObject();
        SendRoutingInfoForSMRequestWrapper event = new SendRoutingInfoForSMRequestWrapper(mapDialogSmsWrapper, sendRoutingInfoForSMRequest);
        this.onEvent(event.getEventTypeName(), mapDialogSmsWrapper, event);
    }

    public void onSendRoutingInfoForSMResponse(SendRoutingInfoForSMResponse sendRoutingInfoForSmResponse) {
        MAPDialogSmsWrapper mapDialogSmsWrapper = (MAPDialogSmsWrapper)sendRoutingInfoForSmResponse.getMAPDialog().getUserObject();
        SendRoutingInfoForSMResponseWrapper event = new SendRoutingInfoForSMResponseWrapper(mapDialogSmsWrapper, sendRoutingInfoForSmResponse);
        this.onEvent(event.getEventTypeName(), mapDialogSmsWrapper, event);
    }

    public void onReportSMDeliveryStatusRequest(ReportSMDeliveryStatusRequest reportSmDeliveryStatusRequest) {
        MAPDialogSmsWrapper mapDialogSmsWrapper = (MAPDialogSmsWrapper)reportSmDeliveryStatusRequest.getMAPDialog().getUserObject();
        ReportSMDeliveryStatusRequestWrapper event = new ReportSMDeliveryStatusRequestWrapper(mapDialogSmsWrapper, reportSmDeliveryStatusRequest);
        this.onEvent(event.getEventTypeName(), mapDialogSmsWrapper, event);
    }

    public void onReportSMDeliveryStatusResponse(ReportSMDeliveryStatusResponse reportSmDeliveryStatusResponse) {
        MAPDialogSmsWrapper mapDialogSmsWrapper = (MAPDialogSmsWrapper)reportSmDeliveryStatusResponse.getMAPDialog().getUserObject();
        ReportSMDeliveryStatusResponseWrapper event = new ReportSMDeliveryStatusResponseWrapper(mapDialogSmsWrapper, reportSmDeliveryStatusResponse);
        this.onEvent(event.getEventTypeName(), mapDialogSmsWrapper, event);
    }

    public void onInformServiceCentreRequest(InformServiceCentreRequest informServiCecentreRequest) {
        MAPDialogSmsWrapper mapDialogSmsWrapper = (MAPDialogSmsWrapper)informServiCecentreRequest.getMAPDialog().getUserObject();
        InformServiceCentreRequestWrapper event = new InformServiceCentreRequestWrapper(mapDialogSmsWrapper, informServiCecentreRequest);
        this.onEvent(event.getEventTypeName(), mapDialogSmsWrapper, event);
    }

    public void onAlertServiceCentreRequest(AlertServiceCentreRequest alertServiCecentreRequest) {
        MAPDialogSmsWrapper mapDialogSmsWrapper = (MAPDialogSmsWrapper)alertServiCecentreRequest.getMAPDialog().getUserObject();
        AlertServiceCentreRequestWrapper event = new AlertServiceCentreRequestWrapper(mapDialogSmsWrapper, alertServiCecentreRequest);
        this.onEvent(event.getEventTypeName(), mapDialogSmsWrapper, event);
    }

    public void onAlertServiceCentreResponse(AlertServiceCentreResponse alertServiCecentreResponse) {
        MAPDialogSmsWrapper mapDialogSmsWrapper = (MAPDialogSmsWrapper)alertServiCecentreResponse.getMAPDialog().getUserObject();
        AlertServiceCentreResponseWrapper event = new AlertServiceCentreResponseWrapper(mapDialogSmsWrapper, alertServiCecentreResponse);
        this.onEvent(event.getEventTypeName(), mapDialogSmsWrapper, event);
    }

    public void onReadyForSMRequest(ReadyForSMRequest request) {
        MAPDialogSmsWrapper mapDialogSmsWrapper = (MAPDialogSmsWrapper)request.getMAPDialog().getUserObject();
        ReadyForSMRequestWrapper event = new ReadyForSMRequestWrapper(mapDialogSmsWrapper, request);
        this.onEvent(event.getEventTypeName(), mapDialogSmsWrapper, event);
    }

    public void onReadyForSMResponse(ReadyForSMResponse response) {
        MAPDialogSmsWrapper mapDialogSmsWrapper = (MAPDialogSmsWrapper)response.getMAPDialog().getUserObject();
        ReadyForSMResponseWrapper event = new ReadyForSMResponseWrapper(mapDialogSmsWrapper, response);
        this.onEvent(event.getEventTypeName(), mapDialogSmsWrapper, event);
    }

    public void onNoteSubscriberPresentRequest(NoteSubscriberPresentRequest request) {
        MAPDialogSmsWrapper mapDialogSmsWrapper = (MAPDialogSmsWrapper)request.getMAPDialog().getUserObject();
        NoteSubscriberPresentRequestWrapper event = new NoteSubscriberPresentRequestWrapper(mapDialogSmsWrapper, request);
        this.onEvent(event.getEventTypeName(), mapDialogSmsWrapper, event);
    }

    public void onSendRoutingInfoForGprsRequest(SendRoutingInfoForGprsRequest request) {
        MAPDialogPdpContextActivationWrapper mapDialogPdpContextActivationWrapper = (MAPDialogPdpContextActivationWrapper)request.getMAPDialog().getUserObject();
        SendRoutingInfoForGprsRequestWrapper event = new SendRoutingInfoForGprsRequestWrapper(mapDialogPdpContextActivationWrapper, request);
        this.onEvent(event.getEventTypeName(), mapDialogPdpContextActivationWrapper, event);
    }

    public void onSendRoutingInfoForGprsResponse(SendRoutingInfoForGprsResponse response) {
        MAPDialogPdpContextActivationWrapper mapDialogPdpContextActivationWrapper = (MAPDialogPdpContextActivationWrapper)response.getMAPDialog().getUserObject();
        SendRoutingInfoForGprsResponseWrapper event = new SendRoutingInfoForGprsResponseWrapper(mapDialogPdpContextActivationWrapper, response);
        this.onEvent(event.getEventTypeName(), mapDialogPdpContextActivationWrapper, event);
    }

    public void onProvideSubscriberLocationRequest(ProvideSubscriberLocationRequest provideSubscriberLocationRequest) {
        MAPDialogLsmWrapper mapDialogLsmWrapper = (MAPDialogLsmWrapper)provideSubscriberLocationRequest.getMAPDialog().getUserObject();
        ProvideSubscriberLocationRequestWrapper event = new ProvideSubscriberLocationRequestWrapper(mapDialogLsmWrapper, provideSubscriberLocationRequest);
        this.onEvent(event.getEventTypeName(), mapDialogLsmWrapper, event);
    }

    public void onProvideSubscriberLocationResponse(ProvideSubscriberLocationResponse provideSubscriberLocationResponse) {
        MAPDialogLsmWrapper mapDialogLsmWrapper = (MAPDialogLsmWrapper)provideSubscriberLocationResponse.getMAPDialog().getUserObject();
        ProvideSubscriberLocationResponseWrapper event = new ProvideSubscriberLocationResponseWrapper(mapDialogLsmWrapper, provideSubscriberLocationResponse);
        this.onEvent(event.getEventTypeName(), mapDialogLsmWrapper, event);
    }

    public void onSendRoutingInfoForLCSRequest(SendRoutingInfoForLCSRequest sendRoutingInfoForLCSRequest) {
        MAPDialogLsmWrapper mapDialogLsmWrapper = (MAPDialogLsmWrapper)sendRoutingInfoForLCSRequest.getMAPDialog().getUserObject();
        SendRoutingInfoForLCSRequestWrapper event = new SendRoutingInfoForLCSRequestWrapper(mapDialogLsmWrapper, sendRoutingInfoForLCSRequest);
        this.onEvent(event.getEventTypeName(), mapDialogLsmWrapper, event);
    }

    public void onSendRoutingInfoForLCSResponse(SendRoutingInfoForLCSResponse sendRoutingInfoForLCSResponse) {
        MAPDialogLsmWrapper mapDialogLsmWrapper = (MAPDialogLsmWrapper)sendRoutingInfoForLCSResponse.getMAPDialog().getUserObject();
        SendRoutingInfoForLCSResponseWrapper event = new SendRoutingInfoForLCSResponseWrapper(mapDialogLsmWrapper, sendRoutingInfoForLCSResponse);
        this.onEvent(event.getEventTypeName(), mapDialogLsmWrapper, event);
    }

    public void onSubscriberLocationReportRequest(SubscriberLocationReportRequest subscriberLocationReportRequest) {
        MAPDialogLsmWrapper mapDialogLsmWrapper = (MAPDialogLsmWrapper)subscriberLocationReportRequest.getMAPDialog().getUserObject();
        SubscriberLocationReportRequestWrapper event = new SubscriberLocationReportRequestWrapper(mapDialogLsmWrapper, subscriberLocationReportRequest);
        this.onEvent(event.getEventTypeName(), mapDialogLsmWrapper, event);
    }

    public void onSubscriberLocationReportResponse(SubscriberLocationReportResponse subscriberLocationReportResponse) {
        MAPDialogLsmWrapper mapDialogLsmWrapper = (MAPDialogLsmWrapper)subscriberLocationReportResponse.getMAPDialog().getUserObject();
        SubscriberLocationReportResponseWrapper event = new SubscriberLocationReportResponseWrapper(mapDialogLsmWrapper, subscriberLocationReportResponse);
        this.onEvent(event.getEventTypeName(), mapDialogLsmWrapper, event);
    }

    public void onMAPMessage(MAPMessage arg0) {
    }

    public MAPResourceAdaptorStatisticsUsageParameters getDefaultUsageParameters() {
        return this.defaultUsageParameters;
    }
}

