/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.rest.ch7;

import java.util.Date;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.example.book.rest.ch7.Bookmark;
import org.restlet.example.book.rest.ch7.UserResource;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.representation.Variant;
import org.restlet.resource.ResourceException;

public class BookmarkResource
extends UserResource {
    private Bookmark bookmark;
    private String uri;

    @Override
    public Representation delete() throws ResourceException {
        if (this.isModifiable()) {
            if (this.bookmark != null && this.checkAuthorization() == 1) {
                this.getUser().getBookmarks().remove(this.bookmark);
                this.getContainer().delete((Object)this.bookmark);
                this.getContainer().store((Object)this.getUser());
                this.getContainer().commit();
                this.setStatus(Status.SUCCESS_OK);
            } else {
                this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
            }
        } else {
            return super.delete();
        }
        return null;
    }

    @Override
    public void doInit() {
        super.doInit();
        if (this.getUser() != null) {
            this.uri = (String)this.getRequestAttributes().get("URI");
            this.bookmark = this.getUser().getBookmark(this.uri);
            if (this.bookmark != null) {
                if (this.checkAuthorization() != 1 && this.bookmark.isRestricting()) {
                    this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                }
            } else {
                this.getVariants().clear();
            }
        } else {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        }
    }

    @Override
    public Representation get(Variant variant) throws ResourceException {
        StringRepresentation result = null;
        if (variant.getMediaType().equals((Object)MediaType.TEXT_PLAIN)) {
            StringBuilder sb = new StringBuilder();
            sb.append("----------------\n");
            sb.append("Bookmark details\n");
            sb.append("----------------\n\n");
            sb.append("User:     ").append(this.bookmark.getUser().getName()).append('\n');
            sb.append("URI:      ").append(this.bookmark.getUri()).append('\n');
            sb.append("Short:    ").append(this.bookmark.getShortDescription()).append('\n');
            sb.append("Long:     ").append(this.bookmark.getLongDescription()).append('\n');
            sb.append("Date:     ").append(this.bookmark.getDateTime()).append('\n');
            sb.append("Restrict: ").append(Boolean.toString(this.bookmark.isRestricting())).append('\n');
            result = new StringRepresentation((CharSequence)sb);
        }
        return result;
    }

    @Override
    public Representation put(Representation entity) throws ResourceException {
        if (this.checkAuthorization() == 1) {
            if (entity.getMediaType().equals((Object)MediaType.APPLICATION_WWW_FORM, true)) {
                Form form = new Form(entity);
                if (this.bookmark == null) {
                    this.bookmark = new Bookmark(this.getUser(), this.uri);
                    this.getUser().getBookmarks().add(this.bookmark);
                    this.setStatus(Status.SUCCESS_CREATED);
                } else {
                    this.setStatus(Status.SUCCESS_NO_CONTENT);
                }
                this.bookmark.setShortDescription(form.getFirstValue("bookmark[short_description]"));
                this.bookmark.setLongDescription(form.getFirstValue("bookmark[long_description]"));
                this.bookmark.setDateTime(new Date());
                this.bookmark.setRestricting(new Boolean(form.getFirstValue("bookmark[restrict]")));
                this.getContainer().store((Object)this.bookmark);
                this.getContainer().store((Object)this.getUser());
                this.getContainer().commit();
            }
        } else {
            this.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
        }
        return null;
    }
}

