/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch05.sec4.server;

import java.io.File;
import java.io.FilenameFilter;
import java.security.AccessControlException;
import java.security.PrivilegedAction;
import org.restlet.data.ClientInfo;
import org.restlet.data.Status;
import org.restlet.ext.jaas.JaasUtils;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.Get;
import org.restlet.resource.ResourceException;
import org.restlet.resource.ServerResource;

public class FilesServerResource
extends ServerResource {
    @Get(value="txt")
    public Representation retrieve() throws ResourceException {
        StringBuilder result = null;
        PrivilegedAction<StringBuilder> action = new PrivilegedAction<StringBuilder>(){

            @Override
            public StringBuilder run() {
                File dir = new File(System.getProperty("user.home"));
                String[] filenames = dir.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return !name.startsWith(".");
                    }
                });
                StringBuilder sb = new StringBuilder("Files in the home directory: \n\n");
                for (String filename : filenames) {
                    sb.append(filename);
                    sb.append("\n");
                }
                return sb;
            }
        };
        try {
            result = (StringBuilder)JaasUtils.doAsPriviledged((ClientInfo)this.getRequest().getClientInfo(), (PrivilegedAction)action);
        }
        catch (AccessControlException ace) {
            this.setStatus(Status.CLIENT_ERROR_FORBIDDEN);
        }
        return result == null ? null : new StringRepresentation((CharSequence)result);
    }
}

