/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch07.sec5.website;

import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Cookie;
import org.restlet.data.CookieSetting;
import org.restlet.data.Form;
import org.restlet.data.LocalReference;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Status;
import org.restlet.ext.freemarker.TemplateRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;
import org.restlet.security.ChallengeAuthenticator;
import org.restlet.security.Verifier;

public class CookieAuthenticator
extends ChallengeAuthenticator {
    public CookieAuthenticator(Context context, boolean optional, String realm) {
        super(context, optional, ChallengeScheme.HTTP_COOKIE, realm);
    }

    public CookieAuthenticator(Context context, boolean optional, String realm, Verifier verifier) {
        super(context, optional, ChallengeScheme.HTTP_COOKIE, realm, verifier);
    }

    public CookieAuthenticator(Context context, String realm) {
        super(context, ChallengeScheme.HTTP_COOKIE, realm);
    }

    protected int beforeHandle(Request request, Response response) {
        Cookie cookie = (Cookie)request.getCookies().getFirst("Credentials");
        if (cookie != null) {
            String[] credentials = cookie.getValue().split("=");
            if (credentials.length == 2) {
                String identifier = credentials[0];
                String secret = credentials[1];
                request.setChallengeResponse(new ChallengeResponse(ChallengeScheme.HTTP_COOKIE, identifier, secret));
            }
        } else if (Method.POST.equals((Object)request.getMethod()) && request.getResourceRef().getQueryAsForm().getFirst("login") != null) {
            Form credentials = new Form(request.getEntity());
            String identifier = credentials.getFirstValue("identifier");
            String secret = credentials.getFirstValue("secret");
            request.setChallengeResponse(new ChallengeResponse(ChallengeScheme.HTTP_COOKIE, identifier, secret));
            request.setMethod(Method.GET);
        }
        return super.beforeHandle(request, response);
    }

    public void challenge(Response response, boolean stale) {
        Representation ftl = new ClientResource(LocalReference.createClapReference((Package)((Object)((Object)this)).getClass().getPackage()) + "/Login.ftl").get();
        response.setEntity((Representation)new TemplateRepresentation(ftl, (Object)response.getRequest().getResourceRef(), MediaType.TEXT_HTML));
        response.setStatus(Status.CLIENT_ERROR_UNAUTHORIZED);
    }

    protected void afterHandle(Request request, Response response) {
        super.afterHandle(request, response);
        Cookie cookie = (Cookie)request.getCookies().getFirst("Credentials");
        if (request.getClientInfo().isAuthenticated() && cookie == null) {
            String identifier = request.getChallengeResponse().getIdentifier();
            String secret = new String(request.getChallengeResponse().getSecret());
            CookieSetting cookieSetting = new CookieSetting("Credentials", identifier + "=" + secret);
            cookieSetting.setAccessRestricted(true);
            cookieSetting.setPath("/");
            cookieSetting.setComment("Unsecured cookie based authentication");
            cookieSetting.setMaxAge(30);
            response.getCookieSettings().add((Object)cookieSetting);
        }
    }
}

