/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.book.restlet.ch08.gae.server;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.restlet.data.MediaType;
import org.restlet.example.book.restlet.ch08.gae.common.AccountRepresentation;
import org.restlet.example.book.restlet.ch08.gae.common.AccountsResource;
import org.restlet.ext.wadl.ApplicationInfo;
import org.restlet.ext.wadl.DocumentationInfo;
import org.restlet.ext.wadl.MethodInfo;
import org.restlet.ext.wadl.RepresentationInfo;
import org.restlet.ext.wadl.WadlServerResource;
import org.restlet.representation.Variant;
import org.restlet.resource.ResourceException;

public class AccountsServerResource
extends WadlServerResource
implements AccountsResource {
    private static final List<AccountRepresentation> accounts = new CopyOnWriteArrayList<AccountRepresentation>();

    protected void describe(ApplicationInfo applicationInfo) {
        RepresentationInfo rep = new RepresentationInfo(MediaType.TEXT_PLAIN);
        rep.setIdentifier("account");
        applicationInfo.getRepresentations().add(rep);
        DocumentationInfo doc = new DocumentationInfo();
        doc.setTitle("Account");
        doc.setTextContent("Simple string containing the account ID");
        rep.getDocumentations().add(doc);
    }

    protected RepresentationInfo describe(MethodInfo methodInfo, Class<?> representationClass, Variant variant) {
        RepresentationInfo result = new RepresentationInfo(variant);
        result.setReference("account");
        return result;
    }

    protected void doInit() throws ResourceException {
        this.setName("Mail accounts resource");
        this.setDescription("The resource containing the list of mail accounts");
    }

    public static List<AccountRepresentation> getAccounts() {
        return accounts;
    }

    @Override
    public String represent() {
        StringBuilder result = new StringBuilder();
        for (AccountRepresentation account : AccountsServerResource.getAccounts()) {
            result.append(account == null ? "" : account).append('\n');
        }
        return result.toString();
    }

    @Override
    public String add(AccountRepresentation account) {
        AccountsServerResource.getAccounts().add(account);
        return Integer.toString(AccountsServerResource.getAccounts().indexOf(account));
    }
}

