/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Named;
import org.restlet.Application;
import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.data.Protocol;
import org.restlet.example.ext.guice.HelloWorld;
import org.restlet.ext.guice.FinderFactory;
import org.restlet.ext.guice.RestletGuice;
import org.restlet.resource.Get;
import org.restlet.resource.ServerResource;
import org.restlet.routing.Router;

public class Main
extends Application {
    static final String HELLO_MSG = "Hello, Restlet 2.0 - Guice 2.0!";
    static final String HELLO_PATH = "/hello";
    static volatile Mode mode = Mode.AUTO_INJECTOR;
    static final String MSG_QUALIFIER = "hello.message";
    static final String PATH_QUALIFIER = "hello.path";

    public static void main(String[] args) throws Exception {
        if (args.length > 0) {
            if ("explicit".startsWith(args[0])) {
                mode = Mode.EXPLICIT_INJECTOR;
            } else if (!"auto".startsWith(args[0])) {
                System.out.println("Call with prefix of 'auto' (default) or 'explicit'");
                System.exit(1);
            }
        }
        Component component = new Component();
        component.getServers().add(Protocol.HTTP, 8182);
        component.getDefaultHost().attach((Restlet)new Main());
        component.start();
    }

    public Restlet createInboundRoot() {
        AbstractModule bindings = new AbstractModule(){

            protected void configure() {
                this.bind(ServerResource.class).annotatedWith(HelloWorld.class).to(HelloServerResource.class);
                this.bindConstant().annotatedWith((Annotation)Names.named((String)Main.MSG_QUALIFIER)).to(Main.HELLO_MSG);
                this.bindConstant().annotatedWith((Annotation)Names.named((String)Main.PATH_QUALIFIER)).to(Main.HELLO_PATH);
            }
        };
        RestletGuice.Module ff = null;
        switch (mode) {
            case EXPLICIT_INJECTOR: {
                Injector injector = RestletGuice.createInjector((Module[])new Module[]{bindings});
                ff = (FinderFactory)injector.getInstance(FinderFactory.class);
                break;
            }
            default: {
                ff = new RestletGuice.Module(new Module[]{bindings});
            }
        }
        assert (ff != null) : "Must specify Injector creation mode.";
        Router router = new Router(this.getContext());
        router.attach(HELLO_PATH, (Restlet)ff.finder(ServerResource.class, HelloWorld.class));
        router.attachDefault((Restlet)ff.finder(DefaultResource.class));
        return router;
    }

    static enum Mode {
        AUTO_INJECTOR,
        EXPLICIT_INJECTOR;

    }

    public static class HelloServerResource
    extends ServerResource {
        private static final AtomicInteger count = new AtomicInteger();
        private final String msg;

        @Inject
        public HelloServerResource(@Named(value="hello.message") String msg) {
            this.msg = msg;
        }

        @Get
        public String asString() {
            return String.format("%d: %s", count.incrementAndGet(), this.msg);
        }
    }

    public static class DefaultResource
    extends ServerResource {
        private final String path;

        @Inject
        DefaultResource(@Named(value="hello.path") String path) {
            this.path = path;
        }

        @Get
        public String represent() {
            return String.format("Default resource, try %s -- mode is %s", new Object[]{this.path, mode});
        }
    }
}

