/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.oauth.server;

import java.io.IOException;
import org.json.JSONException;
import org.json.JSONObject;
import org.restlet.data.Status;
import org.restlet.example.ext.oauth.server.OAuth2Sample;
import org.restlet.example.ext.oauth.server.SampleUser;
import org.restlet.ext.json.JsonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.Get;
import org.restlet.resource.Put;
import org.restlet.resource.ServerResource;
import org.restlet.security.User;

public class StatusServerResource
extends ServerResource {
    @Get(value="json")
    public Representation getUserStatus() throws JSONException {
        User user = this.getRequest().getClientInfo().getUser();
        this.getLogger().info("getUserStatus: " + user.getIdentifier());
        SampleUser sampleUser = OAuth2Sample.getSampleUserManager().findUserById(user.getIdentifier());
        if (sampleUser == null) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return null;
        }
        JSONObject result = new JSONObject();
        String status = sampleUser.getStatus();
        if (status != null) {
            result.put("status", (Object)status);
        } else {
            result.put("status", (Object)"");
        }
        return new JsonRepresentation(result);
    }

    @Put(value="json")
    public Representation updateUserStatus(Representation representation) throws IOException, JSONException {
        JSONObject request = new JsonRepresentation(representation).getJsonObject();
        Object status = request.get("status");
        if (status == null) {
            this.setStatus(Status.CLIENT_ERROR_BAD_REQUEST);
            return null;
        }
        User user = this.getRequest().getClientInfo().getUser();
        this.getLogger().info("updateUserStatus: " + user.getIdentifier());
        SampleUser sampleUser = OAuth2Sample.getSampleUserManager().findUserById(user.getIdentifier());
        if (sampleUser != null) {
            sampleUser.setStatus(status.toString());
        }
        JSONObject result = new JSONObject();
        result.put("status", status);
        return new JsonRepresentation(result);
    }
}

