/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.rdf.foaf.resources;

import java.util.List;
import java.util.TreeMap;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.example.ext.rdf.foaf.objects.Contact;
import org.restlet.example.ext.rdf.foaf.objects.User;
import org.restlet.example.ext.rdf.foaf.resources.BaseResource;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class ContactsResource
extends BaseResource {
    private List<Contact> contacts;
    private User user;

    @Post
    public void acceptContact(Representation entity) throws ResourceException {
        Form form = new Form(entity);
        Contact contact = new Contact();
        contact.setFirstName(form.getFirstValue("firstName"));
        contact.setLastName(form.getFirstValue("lastName"));
        contact.setImage(form.getFirstValue("image"));
        contact.setNickname(form.getFirstValue("nickname"));
        contact.setFoafUri(form.getFirstValue("foafUri"));
        contact = this.getObjectsFacade().createContact(this.user, contact);
        this.getResponse().redirectSeeOther(this.getChildReference(this.getRequest().getResourceRef(), contact.getId()));
    }

    protected void doInit() throws ResourceException {
        String userId = (String)this.getRequestAttributes().get("userId");
        this.user = this.getObjectsFacade().getUserById(userId);
        if (this.user != null) {
            this.contacts = this.user.getContacts();
        } else {
            this.setExisting(false);
        }
    }

    @Get
    public Representation toHtml(Variant variant) throws ResourceException {
        TreeMap<String, Object> dataModel = new TreeMap<String, Object>();
        dataModel.put("user", this.user);
        dataModel.put("contacts", this.contacts);
        dataModel.put("resourceRef", this.getRequest().getResourceRef());
        dataModel.put("rootRef", this.getRequest().getRootRef());
        return this.getTemplateRepresentation("contacts.html", dataModel, MediaType.TEXT_HTML);
    }
}

