/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.rdf.foaf.resources;

import java.util.List;
import java.util.TreeMap;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.example.ext.rdf.foaf.objects.ObjectsException;
import org.restlet.example.ext.rdf.foaf.objects.User;
import org.restlet.example.ext.rdf.foaf.resources.BaseResource;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;
import org.restlet.resource.Get;
import org.restlet.resource.Post;
import org.restlet.resource.ResourceException;

public class UsersResource
extends BaseResource {
    private List<User> users;

    protected void doInit() throws ResourceException {
        this.users = this.getObjectsFacade().getUsers();
    }

    @Post
    public void acceptUser(Representation entity) throws ResourceException {
        Form form = new Form(entity);
        User user = new User();
        user.setFirstName(form.getFirstValue("firstName"));
        user.setLastName(form.getFirstValue("lastName"));
        user.setImage(form.getFirstValue("image"));
        try {
            user = this.getObjectsFacade().createUser(user);
            this.getResponse().redirectSeeOther(this.getChildReference(this.getRequest().getResourceRef(), user.getId()));
        }
        catch (ObjectsException e) {
            TreeMap<String, Object> dataModel = new TreeMap<String, Object>();
            dataModel.put("users", this.users);
            dataModel.put("resourceRef", this.getRequest().getResourceRef());
            dataModel.put("rootRef", this.getRequest().getRootRef());
            dataModel.put("firstName", form.getFirstValue("firstName"));
            dataModel.put("lastName", form.getFirstValue("lastName"));
            dataModel.put("image", form.getFirstValue("image"));
            dataModel.put("errorMessage", e.getMessage());
            this.getResponse().setEntity(this.getTemplateRepresentation("users.html", dataModel, MediaType.TEXT_HTML));
        }
    }

    @Get
    public Representation toHtml(Variant variant) throws ResourceException {
        TreeMap<String, Object> dataModel = new TreeMap<String, Object>();
        dataModel.put("users", this.users);
        dataModel.put("resourceRef", this.getRequest().getResourceRef());
        dataModel.put("rootRef", this.getRequest().getRootRef());
        return this.getTemplateRepresentation("users.html", dataModel, MediaType.TEXT_HTML);
    }
}

