/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.example.ext.sip;

import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.Uniform;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.example.ext.sip.UacServerResource;
import org.restlet.ext.sip.SipRecipientInfo;
import org.restlet.ext.sip.SipRequest;
import org.restlet.ext.sip.SipResponse;
import org.restlet.routing.Redirector;
import org.restlet.routing.Template;

public class B2buaRedirector
extends Redirector {
    public static void main(String[] args) throws Exception {
        String[] arguments = new String[]{"8111"};
        UacServerResource.main(arguments);
        Component c = new Component();
        Server server = new Server(Protocol.SIP);
        c.getServers().add(server);
        server.getContext().getParameters().add("tracing", "true");
        Client client = new Client(Protocol.SIP);
        c.getClients().add(client);
        client.getContext().getParameters().add("proxyHost", "localhost");
        client.getContext().getParameters().add("proxyPort", arguments[0]);
        client.getContext().getParameters().add("tracing", "false");
        client.getContext().getParameters().add("pipeliningConnections", "false");
        c.getDefaultHost().attachDefault((Restlet)new B2buaRedirector(null, "sip:localhost:8111"));
        c.start();
    }

    public B2buaRedirector(Context context, String targetTemplate) {
        super(context, targetTemplate);
    }

    public B2buaRedirector(Context context, String targetTemplate, int mode) {
        super(context, targetTemplate, mode);
    }

    protected void outboundServerRedirect(Reference targetRef, Request request, Response response) {
        SipRequest r = (SipRequest)request;
        SipRecipientInfo sri = new SipRecipientInfo();
        sri.setProtocol(Protocol.SIP);
        sri.setTransport("TCP");
        sri.setName("127.0.0.1:5060");
        sri.getParameters().add("branch", "z9hG4bK-20369-1-0");
        r.getSipRecipientsInfo().add(0, sri);
        super.outboundServerRedirect(targetRef, (Request)r, response);
    }

    protected void serverRedirect(Restlet next, Reference targetRef, final Request request, final Response response) {
        final Reference resourceRef = request.getResourceRef();
        final Reference baseRef = resourceRef.getBaseRef();
        final String targetTemplate = this.getTargetTemplate();
        request.getAttributes().remove("org.restlet.http.headers");
        request.setOnResponse(new Uniform(){

            public void handle(Request req, Response resp) {
                SipResponse r = (SipResponse)resp;
                if (!resp.getStatus().isInformational()) {
                    response.setEntity(B2buaRedirector.this.rewrite(response.getEntity()));
                    response.getAttributes().remove("org.restlet.http.headers");
                    request.setResourceRef(resourceRef);
                    if (response.getLocationRef() != null) {
                        String remainingPart;
                        Template rt = new Template(targetTemplate);
                        rt.setLogger(B2buaRedirector.this.getLogger());
                        int matched = rt.parse(response.getLocationRef().toString(), request);
                        if (matched > 0 && (remainingPart = (String)request.getAttributes().get("rr")) != null) {
                            response.setLocationRef(baseRef.toString() + remainingPart);
                        }
                    }
                    if (!r.getSipRecipientsInfo().isEmpty()) {
                        r.getSipRecipientsInfo().remove(0);
                    }
                    resp.commit();
                } else {
                    SipResponse provisionalResponse = new SipResponse(request);
                    provisionalResponse.setStatus(resp.getStatus());
                    provisionalResponse.commit();
                }
            }
        });
        request.setResourceRef(targetRef);
        SipRequest r = new SipRequest((SipRequest)request);
        response.setAutoCommitting(false);
        next.handle((Request)r, response);
    }
}

