/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.atom;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.restlet.data.Reference;
import org.restlet.engine.util.DateUtils;
import org.restlet.ext.atom.Category;
import org.restlet.ext.atom.Generator;
import org.restlet.ext.atom.Link;
import org.restlet.ext.atom.Person;
import org.restlet.ext.atom.Text;
import org.restlet.ext.xml.XmlWriter;
import org.xml.sax.SAXException;

public class Source {
    private volatile List<Person> authors = null;
    private volatile List<Category> categories = null;
    private volatile List<Person> contributors = null;
    private volatile Generator generator = null;
    private volatile Reference icon = null;
    private volatile String id = null;
    private volatile List<Link> links = null;
    private volatile Reference logo = null;
    private volatile Text rights = null;
    private volatile Text subtitle = null;
    private volatile Text title = null;
    private volatile Date updated = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Person> getAuthors() {
        List<Person> a = this.authors;
        if (a == null) {
            Source source = this;
            synchronized (source) {
                a = this.authors;
                if (a == null) {
                    this.authors = a = new ArrayList<Person>();
                }
            }
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Category> getCategories() {
        List<Category> c = this.categories;
        if (c == null) {
            Source source = this;
            synchronized (source) {
                c = this.categories;
                if (c == null) {
                    this.categories = c = new ArrayList<Category>();
                }
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Person> getContributors() {
        List<Person> c = this.contributors;
        if (c == null) {
            Source source = this;
            synchronized (source) {
                c = this.contributors;
                if (c == null) {
                    this.contributors = c = new ArrayList<Person>();
                }
            }
        }
        return c;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public Reference getIcon() {
        return this.icon;
    }

    public String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Link> getLinks() {
        List<Link> l = this.links;
        if (l == null) {
            Source source = this;
            synchronized (source) {
                l = this.links;
                if (l == null) {
                    this.links = l = new ArrayList<Link>();
                }
            }
        }
        return l;
    }

    public Reference getLogo() {
        return this.logo;
    }

    public Text getRights() {
        return this.rights;
    }

    public Text getSubtitle() {
        return this.subtitle;
    }

    public Text getTitle() {
        return this.title;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setGenerator(Generator generator) {
        this.generator = generator;
    }

    public void setIcon(Reference icon) {
        this.icon = icon;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLogo(Reference logo) {
        this.logo = logo;
    }

    public void setRights(Text rights) {
        this.rights = rights;
    }

    public void setSubtitle(Text subtitle) {
        this.subtitle = subtitle;
    }

    public void setTitle(Text title) {
        this.title = title;
    }

    public void setUpdated(Date updated) {
        this.updated = DateUtils.unmodifiable((Date)updated);
    }

    public void writeElement(XmlWriter writer) throws SAXException {
        writer.startElement("http://www.w3.org/2005/Atom", "source");
        if (this.getAuthors() != null) {
            for (Person person : this.getAuthors()) {
                person.writeElement(writer, "author");
            }
        }
        if (this.getCategories() != null) {
            for (Category category : this.getCategories()) {
                category.writeElement(writer);
            }
        }
        if (this.getContributors() != null) {
            for (Person person : this.getContributors()) {
                person.writeElement(writer, "contributor");
            }
        }
        if (this.getGenerator() != null) {
            this.getGenerator().writeElement(writer);
        }
        if (this.getIcon() != null && this.getIcon().toString() != null) {
            writer.dataElement("http://www.w3.org/2005/Atom", "icon", this.getIcon().toString());
        }
        if (this.getId() != null) {
            writer.dataElement("http://www.w3.org/2005/Atom", "id", this.getId());
        }
        if (this.getLinks() != null) {
            for (Link link : this.getLinks()) {
                link.writeElement(writer);
            }
        }
        if (this.getLogo() != null && this.getLogo().toString() != null) {
            writer.dataElement("http://www.w3.org/2005/Atom", "logo", this.getLogo().toString());
        }
        if (this.getRights() != null) {
            this.getRights().writeElement(writer, "rights");
        }
        if (this.getSubtitle() != null) {
            this.getSubtitle().writeElement(writer, "subtitle");
        }
        if (this.getTitle() != null) {
            this.getTitle().writeElement(writer, "title");
        }
        if (this.getUpdated() != null) {
            Text.writeElement(writer, this.getUpdated(), "http://www.w3.org/2005/Atom", "updated");
        }
        writer.endElement("http://www.w3.org/2005/Atom", "source");
    }
}

