/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.atom.internal;

import java.util.ArrayList;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.ext.atom.Collection;
import org.restlet.ext.atom.Service;
import org.restlet.ext.atom.Workspace;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ServiceContentReader
extends DefaultHandler {
    private static final int IN_ACCEPT = 1;
    private static final int IN_COLLECTION = 2;
    private static final int IN_COLLECTION_TITLE = 3;
    private static final int IN_NONE = 0;
    private static final int IN_SERVICE = 4;
    private static final int IN_WORKSPACE = 5;
    private static final int IN_WORKSPACE_TITLE = 6;
    private StringBuilder contentBuffer = null;
    private Collection currentCollection = null;
    private Service currentService = null;
    private Workspace currentWorkspace = null;
    private int state = 0;

    public ServiceContentReader(Service service) {
        this.currentService = service;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.state == 1 || this.state == 3 || this.state == 6) {
            this.contentBuffer.append(ch, start, length);
        }
    }

    @Override
    public void endDocument() throws SAXException {
        this.state = 0;
        this.currentWorkspace = null;
        this.currentCollection = null;
        this.contentBuffer = null;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri.equalsIgnoreCase("http://www.w3.org/2007/app")) {
            if (localName.equalsIgnoreCase("service")) {
                this.state = 0;
            } else if (localName.equalsIgnoreCase("workspace")) {
                if (this.state == 5) {
                    this.currentService.getWorkspaces().add(this.currentWorkspace);
                    this.currentWorkspace = null;
                    this.state = 4;
                }
            } else if (localName.equalsIgnoreCase("collection")) {
                if (this.state == 2) {
                    this.currentWorkspace.getCollections().add(this.currentCollection);
                    this.currentCollection = null;
                    this.state = 5;
                }
            } else if (localName.equalsIgnoreCase("accept") && this.state == 1) {
                ArrayList<MediaType> mediaTypes = null;
                String accept = this.contentBuffer.toString();
                if (accept != null && accept.length() > 0) {
                    String[] acceptTokens = accept.split(",");
                    mediaTypes = new ArrayList<MediaType>();
                    for (String acceptToken : acceptTokens) {
                        mediaTypes.add(MediaType.valueOf((String)acceptToken));
                    }
                }
                this.currentCollection.setAccept(mediaTypes);
                this.state = 2;
            }
        } else if (uri.equalsIgnoreCase("http://www.w3.org/2005/Atom") && localName.equalsIgnoreCase("title")) {
            if (this.state == 3) {
                String title = this.contentBuffer.toString();
                this.currentCollection.setTitle(title);
                this.state = 2;
            } else if (this.state == 6) {
                String title = this.contentBuffer.toString();
                this.currentWorkspace.setTitle(title);
                this.state = 5;
            }
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.state = 0;
        this.currentWorkspace = null;
        this.currentCollection = null;
        this.contentBuffer = null;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        if (uri.equalsIgnoreCase("http://www.w3.org/2007/app")) {
            if (localName.equalsIgnoreCase("service")) {
                String attr = attrs.getValue("xml:base");
                if (attr != null) {
                    this.currentService.setBaseReference(new Reference(attr));
                }
                this.state = 4;
            } else if (localName.equalsIgnoreCase("workspace")) {
                if (this.state == 4) {
                    this.currentWorkspace = new Workspace(this.currentService);
                    String attr = attrs.getValue("xml:base");
                    if (attr != null) {
                        this.currentWorkspace.setBaseReference(new Reference(attr));
                    }
                    this.state = 5;
                }
            } else if (localName.equalsIgnoreCase("collection")) {
                if (this.state == 5) {
                    this.currentCollection = new Collection(this.currentWorkspace, attrs.getValue("title"), attrs.getValue("href"));
                    String attr = attrs.getValue("xml:base");
                    if (attr != null) {
                        this.currentCollection.setBaseReference(new Reference(attr));
                    }
                    this.state = 2;
                }
            } else if (localName.equalsIgnoreCase("accept") && this.state == 2) {
                this.contentBuffer = new StringBuilder();
                this.state = 1;
            }
        } else if (uri.equalsIgnoreCase("http://www.w3.org/2005/Atom") && localName.equalsIgnoreCase("title")) {
            if (this.state == 2) {
                this.contentBuffer = new StringBuilder();
                this.state = 3;
            } else if (this.state == 5) {
                this.contentBuffer = new StringBuilder();
                this.state = 6;
            }
        }
    }
}

