/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.nio.internal.way;

import java.io.IOException;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Reference;
import org.restlet.engine.header.Header;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.engine.util.ReferenceUtils;
import org.restlet.ext.nio.internal.connection.Connection;
import org.restlet.ext.nio.internal.way.OutboundWay;
import org.restlet.util.Series;

public abstract class ClientOutboundWay
extends OutboundWay {
    public ClientOutboundWay(Connection<?> connection, int bufferSize) {
        super(connection, bufferSize);
    }

    @Override
    protected void addHeaders(Series<Header> headers) {
        Request request = this.getMessage().getRequest();
        this.addGeneralHeaders(headers);
        this.addEntityHeaders(request.getEntity(), headers);
        this.addRequestHeaders(headers);
    }

    protected void addRequestHeaders(Series<Header> headers) {
        HeaderUtils.addRequestHeaders((Request)this.getMessage().getRequest(), headers);
    }

    public Request getActualMessage() {
        return this.getMessage() == null ? null : this.getMessage().getRequest();
    }

    public Connection<Client> getConnection() {
        return super.getConnection();
    }

    @Override
    public void onMessageCompleted(boolean endDetected) throws IOException {
        Request request;
        Response message = this.getMessage();
        if (message != null && (request = message.getRequest()).getOnSent() != null) {
            request.getOnSent().handle(request, message);
        }
        super.onMessageCompleted(endDetected);
    }

    @Override
    protected void writeStartLine() throws IOException {
        Request request = this.getMessage().getRequest();
        this.getLineBuilder().append(request.getMethod().getName());
        this.getLineBuilder().append(' ');
        this.getLineBuilder().append(ReferenceUtils.format((Reference)request.getResourceRef(), (boolean)this.getHelper().isProxying(), (Request)request));
        this.getLineBuilder().append(' ');
        this.getLineBuilder().append(ClientOutboundWay.getVersion(request));
        this.getLineBuilder().append("\r\n");
    }
}

