/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.nio.internal.way;

import java.io.IOException;
import org.restlet.Message;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.ext.nio.ServerConnectionHelper;
import org.restlet.ext.nio.internal.connection.Connection;
import org.restlet.ext.nio.internal.request.InboundRequest;
import org.restlet.ext.nio.internal.state.ConnectionState;
import org.restlet.ext.nio.internal.state.IoState;
import org.restlet.ext.nio.internal.state.MessageState;
import org.restlet.ext.nio.internal.way.InboundWay;
import org.restlet.representation.Representation;

public abstract class ServerInboundWay
extends InboundWay {
    public ServerInboundWay(Connection<?> connection, int bufferSize) {
        super(connection, bufferSize);
    }

    protected abstract Response createResponse(Request var1);

    @Override
    public Message getActualMessage() {
        return this.getMessage().getRequest();
    }

    public Connection<Server> getConnection() {
        return super.getConnection();
    }

    public ServerConnectionHelper getHelper() {
        return (ServerConnectionHelper)super.getHelper();
    }

    @Override
    protected boolean hasIoInterest() {
        return this.getMessageState() == MessageState.START || this.getIoState() == IoState.IDLE && this.getConnection().isPipelining();
    }

    @Override
    protected void onHeadersCompleted() throws IOException {
        super.onHeadersCompleted();
        InboundRequest request = (InboundRequest)this.getMessage().getRequest();
        if (this.getHeaders() != null) {
            request.setHeaders(this.getHeaders());
        }
        if (HeaderUtils.isConnectionClose(this.getHeaders())) {
            this.getConnection().setState(ConnectionState.CLOSING);
        }
        Representation entity = this.createEntity(this.getHeaders());
        this.getMessage().getRequest().setEntity(entity);
        this.getMessage().getServerInfo().setAddress(((Server)this.getConnection().getHelper().getHelped()).getAddress());
        this.getMessage().getServerInfo().setPort(((Server)this.getConnection().getHelper().getHelped()).getPort());
        this.onReceived(this.getMessage());
    }

    @Override
    protected void onReceived(Response message) throws IOException {
        if (message.getRequest() != null) {
            this.getHelper().getInboundMessages().add(message);
            if (!message.getRequest().isEntityAvailable()) {
                this.onMessageCompleted(false);
            }
        }
    }

    @Override
    protected void readStartLine() throws IOException {
        String requestMethod = null;
        String requestUri = null;
        String protocol = null;
        int i = 0;
        int start = 0;
        int size = this.getLineBuilder().length();
        if (size != 0) {
            char next;
            for (i = start; requestMethod == null && i < size; ++i) {
                next = this.getLineBuilder().charAt(i);
                if (!HeaderUtils.isSpace((int)next)) continue;
                requestMethod = this.getLineBuilder().substring(start, i);
                start = i + 1;
            }
            if (requestMethod == null || i == size) {
                throw new IOException("Unable to parse the request method. End of line reached too early.");
            }
            for (i = start; requestUri == null && i < size; ++i) {
                next = this.getLineBuilder().charAt(i);
                if (!HeaderUtils.isSpace((int)next)) continue;
                requestUri = this.getLineBuilder().substring(start, i);
                start = i + 1;
            }
            if (i == size) {
                throw new IOException("Unable to parse the request URI. End of line reached too early.");
            }
            if (requestUri == null || requestUri.equals("")) {
                requestUri = "/";
            }
            for (i = start; protocol == null && i < size; ++i) {
                next = this.getLineBuilder().charAt(i);
            }
            if (i == size) {
                protocol = this.getLineBuilder().substring(start, i);
                start = i + 1;
            }
            if (protocol == null) {
                throw new IOException("Unable to parse the protocol version. End of line reached too early.");
            }
            Request request = this.getHelper().createRequest(this.getConnection(), requestMethod, requestUri, protocol);
            Response response = this.createResponse(request);
            this.setMessage(response);
            this.setMessageState(MessageState.HEADERS);
            this.clearLineBuilder();
        }
    }

    @Override
    public void updateState() {
        if (this.getMessageState() == MessageState.IDLE) {
            this.setMessageState(MessageState.START);
        }
        super.updateState();
    }
}

