/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.nio.internal.way;

import java.io.IOException;
import java.util.logging.Level;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Server;
import org.restlet.data.Method;
import org.restlet.data.Status;
import org.restlet.engine.header.Header;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.ext.nio.internal.connection.Connection;
import org.restlet.ext.nio.internal.way.OutboundWay;
import org.restlet.representation.Representation;
import org.restlet.util.Series;

public abstract class ServerOutboundWay
extends OutboundWay {
    public ServerOutboundWay(Connection<Server> connection, int bufferSize) {
        super(connection, bufferSize);
    }

    @Override
    protected void addHeaders(Series<Header> headers) {
        Response response = this.getMessage();
        Request request = response.getRequest();
        if (Status.SUCCESS_RESET_CONTENT.equals((Object)response.getStatus()) && response.isEntityAvailable()) {
            this.getLogger().warning("Responses with a 205 (Reset content) status can't have an entity. Ignoring the entity for resource \"" + request.getResourceRef() + "\".");
            response.setEntity(null);
        } else if (Status.REDIRECTION_NOT_MODIFIED.equals((Object)response.getStatus()) && request.getEntity() != null) {
            HeaderUtils.addNotModifiedEntityHeaders((Representation)response.getEntity(), headers);
            response.setEntity(null);
        } else if (response.getStatus().isInformational() && response.isEntityAvailable()) {
            this.getLogger().warning("Responses with an informational (1xx) status can't have an entity. Ignoring the entity for resource \"" + request.getResourceRef() + "\".");
            response.setEntity(null);
        }
        this.addGeneralHeaders(headers);
        this.addResponseHeaders(headers);
        this.addEntityHeaders(response.getEntity(), headers);
        if (!response.isEntityAvailable()) {
            if (response.getEntity() != null && response.getEntity().getAvailableSize() != 0L) {
                this.getLogger().warning("A response with an unavailable and potentially non empty entity was returned. Ignoring the entity for resource \"" + response.getRequest().getResourceRef() + "\".");
            }
            response.setEntity(null);
        }
        if (Method.GET.equals((Object)request.getMethod()) && Status.SUCCESS_OK.equals((Object)response.getStatus()) && !response.isEntityAvailable()) {
            this.getLogger().warning("A response with a 200 (Ok) status should have an entity. Make sure that resource \"" + request.getResourceRef() + "\" returns one or set the status to 204 (No content).");
        } else if (Status.SUCCESS_NO_CONTENT.equals((Object)response.getStatus()) && response.isEntityAvailable()) {
            this.getLogger().fine("Responses with a 204 (No content) status generally don't have an entity available. Only adding entity headers for resource \"" + request.getResourceRef() + "\".");
            response.setEntity(null);
        }
        if (Method.HEAD.equals((Object)request.getMethod())) {
            response.setEntity(null);
        }
    }

    protected void addResponseHeaders(Series<Header> headers) {
        HeaderUtils.addResponseHeaders((Response)this.getMessage(), headers);
    }

    public Response getActualMessage() {
        return this.getMessage();
    }

    public Connection<Server> getConnection() {
        return super.getConnection();
    }

    @Override
    public void onMessageCompleted(boolean endDetected) throws IOException {
        if (this.getMessage() != null) {
            Representation requestEntity = this.getMessage().getRequest().getEntity();
            if (this.getMessage().isFinal() && requestEntity != null && requestEntity.isAvailable()) {
                try {
                    if (this.getLogger().isLoggable(Level.FINE)) {
                        this.getLogger().log(Level.FINE, "Automatically exhausting the request entity as it is still available after writing the final response.");
                    }
                    requestEntity.exhaust();
                    requestEntity.release();
                }
                catch (IOException e) {
                    this.getLogger().log(Level.WARNING, "Unable to automatically exhaust the request entity.", e);
                }
            }
        }
        if (!this.getConnection().isPersistent() || HeaderUtils.isConnectionClose(this.getHeaders())) {
            this.getConnection().close(true);
        }
        super.onMessageCompleted(endDetected);
    }

    @Override
    protected void writeStartLine() throws IOException {
        this.getLineBuilder().append(ServerOutboundWay.getVersion(this.getMessage().getRequest()));
        this.getLineBuilder().append(' ');
        this.getLineBuilder().append(this.getMessage().getStatus().getCode());
        this.getLineBuilder().append(' ');
        if (this.getMessage().getStatus().getReasonPhrase() != null) {
            this.getLineBuilder().append(this.getMessage().getStatus().getReasonPhrase());
        } else {
            this.getLineBuilder().append("Status " + this.getMessage().getStatus().getCode());
        }
        this.getLineBuilder().append("\r\n");
    }
}

