/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.sdc.internal;

import com.google.dataconnector.protocol.proto.SdcFrame;
import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Uniform;
import org.restlet.data.Method;
import org.restlet.data.Status;
import org.restlet.engine.adapter.ClientCall;
import org.restlet.engine.adapter.HttpClientHelper;
import org.restlet.engine.connector.ConnectorHelper;
import org.restlet.engine.header.Header;
import org.restlet.engine.io.IoUtils;
import org.restlet.ext.sdc.SdcClientHelper;
import org.restlet.ext.sdc.internal.SdcServerConnection;
import org.restlet.representation.Representation;
import org.restlet.service.ConnectorService;
import org.restlet.util.Series;

public class SdcClientCall
extends ClientCall {
    private final SdcServerConnection connection;
    private volatile SdcFrame.FetchReply fetchReply;
    private volatile SdcFrame.FetchRequest fetchRequest;
    private final CountDownLatch latch;
    private final ByteArrayOutputStream requestEntityStream;
    private volatile boolean responseHeadersAdded;

    public SdcClientCall(SdcClientHelper sdcClientHelper, SdcServerConnection connection, String method, String requestUri) throws IOException {
        super((HttpClientHelper)sdcClientHelper, method, requestUri);
        this.connection = connection;
        this.latch = new CountDownLatch(1);
        this.requestEntityStream = new ByteArrayOutputStream();
    }

    public SdcServerConnection getConnection() {
        return this.connection;
    }

    public SdcFrame.FetchReply getFetchReply() {
        return this.fetchReply;
    }

    public SdcFrame.FetchRequest getFetchRequest() {
        return this.fetchRequest;
    }

    public SdcClientHelper getHelper() {
        return (SdcClientHelper)super.getHelper();
    }

    public CountDownLatch getLatch() {
        return this.latch;
    }

    public String getReasonPhrase() {
        try {
            return Status.valueOf((int)this.getStatusCode()).getDescription();
        }
        catch (IOException e) {
            return null;
        }
    }

    public WritableByteChannel getRequestEntityChannel() {
        return null;
    }

    public OutputStream getRequestEntityStream() {
        return this.requestEntityStream;
    }

    public OutputStream getRequestHeadStream() {
        return null;
    }

    public ReadableByteChannel getResponseEntityChannel(long size) {
        return null;
    }

    public InputStream getResponseEntityStream(long size) {
        return this.getFetchReply().getContents().newInput();
    }

    public Series<Header> getResponseHeaders() {
        Series result = super.getResponseHeaders();
        if (!this.responseHeadersAdded) {
            for (SdcFrame.MessageHeader mh : this.getFetchReply().getHeadersList()) {
                result.add(mh.getKey(), mh.getValue());
            }
            this.responseHeadersAdded = true;
        }
        return result;
    }

    public String getServerAddress() {
        return null;
    }

    public int getStatusCode() throws IOException {
        return this.getFetchReply().getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status sendRequest(Request request) {
        Status result = null;
        Representation entity = request.isEntityAvailable() ? request.getEntity() : null;
        ConnectorService connectorService = ConnectorHelper.getConnectorService();
        if (connectorService != null) {
            connectorService.beforeSend(entity);
        }
        try {
            try {
                CopyOnWriteArrayList<SdcFrame.MessageHeader> headers = new CopyOnWriteArrayList<SdcFrame.MessageHeader>();
                for (Header header : this.getRequestHeaders()) {
                    if (header.getName().equals("Content-Length") || header.getName().equals("Proxy-Authorization")) continue;
                    headers.add(SdcFrame.MessageHeader.newBuilder().setKey(header.getName()).setValue(header.getValue()).build());
                }
                if (!Method.GET.equals((Object)request.getMethod())) {
                    headers.add(SdcFrame.MessageHeader.newBuilder().setKey("x-sdc-http-method").setValue(request.getMethod().getName()).build());
                }
                if (entity != null) {
                    OutputStream requestStream = this.getRequestEntityStream();
                    if (requestStream != null) {
                        entity.write(requestStream);
                        requestStream.flush();
                        requestStream.close();
                        this.setFetchRequest(SdcFrame.FetchRequest.newBuilder().setId(UUID.randomUUID().toString()).setResource(request.getResourceRef().toString()).setStrategy("HTTPClient").addAllHeaders(headers).setContents(ByteString.copyFrom((byte[])this.requestEntityStream.toByteArray())).build());
                    }
                } else {
                    this.setFetchRequest(SdcFrame.FetchRequest.newBuilder().setId(UUID.randomUUID().toString()).setResource(request.getResourceRef().toString()).setStrategy("HTTPClient").addAllHeaders(headers).build());
                }
                this.getConnection().sendRequest(this);
                result = !this.getLatch().await(IoUtils.TIMEOUT_MS, TimeUnit.MILLISECONDS) ? new Status(Status.CONNECTOR_ERROR_INTERNAL, "The calling thread timed out while waiting for a response to unblock it.") : Status.valueOf((int)this.getFetchReply().getStatus());
            }
            catch (Exception e) {
                this.getHelper().getLogger().log(Level.FINE, "An unexpected error occurred during the sending of the HTTP request.", e);
                result = new Status(Status.CONNECTOR_ERROR_INTERNAL, (Throwable)e);
            }
            result = new Status(this.getStatusCode(), null, this.getReasonPhrase(), null);
        }
        catch (IOException ioe) {
            this.getHelper().getLogger().log(Level.FINE, "An error occured during the communication with the remote HTTP server.", ioe);
            result = new Status(Status.CONNECTOR_ERROR_COMMUNICATION, (Throwable)ioe);
        }
        finally {
            if (entity != null) {
                entity.release();
            }
            if (connectorService != null) {
                connectorService.afterSend(entity);
            }
        }
        return result;
    }

    public void sendRequest(Request request, Response response, Uniform callback) throws Exception {
        this.sendRequest(request);
        if (request.getOnSent() != null) {
            request.getOnSent().handle(request, response);
        }
        if (callback != null) {
            callback.handle(request, response);
        }
    }

    public void setFetchReply(SdcFrame.FetchReply fetchReply) {
        this.fetchReply = fetchReply;
    }

    public void setFetchRequest(SdcFrame.FetchRequest fetchRequest) {
        this.fetchRequest = fetchRequest;
    }
}

