/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.ext.wadl;

import java.util.List;
import java.util.Map;
import org.restlet.data.Reference;
import org.restlet.ext.wadl.DocumentationInfo;
import org.restlet.ext.wadl.DocumentedInfo;
import org.restlet.ext.xml.XmlWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class LinkInfo
extends DocumentedInfo {
    private String relationship;
    private Reference resourceType;
    private String reverseRelationship;

    public LinkInfo() {
    }

    public LinkInfo(DocumentationInfo documentation) {
        super(documentation);
    }

    public LinkInfo(List<DocumentationInfo> documentations) {
        super(documentations);
    }

    public LinkInfo(String documentation) {
        super(documentation);
    }

    public String getRelationship() {
        return this.relationship;
    }

    public Reference getResourceType() {
        return this.resourceType;
    }

    public String getReverseRelationship() {
        return this.reverseRelationship;
    }

    public void setRelationship(String relationship) {
        this.relationship = relationship;
    }

    public void setResourceType(Reference resourceType) {
        this.resourceType = resourceType;
    }

    public void setReverseRelationship(String reverseRelationship) {
        this.reverseRelationship = reverseRelationship;
    }

    @Override
    public void updateNamespaces(Map<String, String> namespaces) {
        namespaces.putAll(this.resolveNamespaces());
    }

    public void writeElement(XmlWriter writer) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        if (this.getRelationship() != null && !this.getRelationship().equals("")) {
            attributes.addAttribute("", "rel", null, "xs:token", this.getRelationship());
        }
        if (this.getReverseRelationship() != null && !this.getReverseRelationship().equals("")) {
            attributes.addAttribute("", "rev", null, "xs:token", this.getReverseRelationship());
        }
        if (this.getResourceType() != null && this.getResourceType().toString() != null) {
            attributes.addAttribute("", "resource_type", null, "xs:anyURI", this.getResourceType().toString());
        }
        if (this.getDocumentations().isEmpty()) {
            writer.emptyElement("http://wadl.dev.java.net/2009/02", "link", null, (Attributes)attributes);
        } else {
            writer.startElement("http://wadl.dev.java.net/2009/02", "link", null, (Attributes)attributes);
            for (DocumentationInfo documentationInfo : this.getDocumentations()) {
                documentationInfo.writeElement(writer);
            }
            writer.endElement("http://wadl.dev.java.net/2009/02", "link");
        }
    }
}

