/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client;

import com.google.gdata.client.CookieManager;
import com.google.gdata.client.http.GoogleGDataRequest;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class SimpleCookieManager
implements CookieManager {
    protected Set<GoogleGDataRequest.GoogleCookie> cookies = new HashSet<GoogleGDataRequest.GoogleCookie>();
    protected boolean cookiesEnabled = true;

    @Override
    public void setCookiesEnabled(boolean cookiesEnabled) {
        this.cookiesEnabled = cookiesEnabled;
        if (!this.cookiesEnabled) {
            this.clearCookies();
        }
    }

    @Override
    public boolean cookiesEnabled() {
        return this.cookiesEnabled;
    }

    @Override
    public void clearCookies() {
        this.cookies.clear();
    }

    @Override
    public void addCookie(GoogleGDataRequest.GoogleCookie cookie) {
        assert (this.cookiesEnabled);
        this.cookies.remove(cookie);
        this.cookies.add(cookie);
    }

    @Override
    public Set<GoogleGDataRequest.GoogleCookie> getCookies() {
        Iterator<GoogleGDataRequest.GoogleCookie> cookieIter = this.cookies.iterator();
        while (cookieIter.hasNext()) {
            GoogleGDataRequest.GoogleCookie cookie = cookieIter.next();
            if (!cookie.hasExpired()) continue;
            cookieIter.remove();
        }
        return this.cookies;
    }
}

