/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;

public abstract class AbstractExtension
implements Extension {
    protected final XmlNamespace namespace;
    protected final String localName;
    private boolean immutable;

    public final boolean isImmutable() {
        return this.immutable;
    }

    public final void setImmutable(boolean isImmutable) {
        this.immutable = isImmutable;
    }

    protected AbstractExtension() {
        Class<?> extensionClass = this.getClass();
        ExtensionDescription.Default defAnnot = extensionClass.getAnnotation(ExtensionDescription.Default.class);
        if (defAnnot != null) {
            this.namespace = new XmlNamespace(defAnnot.nsAlias(), defAnnot.nsUri());
            this.localName = defAnnot.localName();
        } else {
            this.namespace = null;
            this.localName = null;
        }
    }

    protected AbstractExtension(XmlNamespace namespace, String localName) {
        this.namespace = namespace;
        this.localName = localName;
    }

    public final XmlNamespace getExtensionNamespace() {
        return this.namespace;
    }

    public final String getExtensionLocalName() {
        return this.localName;
    }

    protected void validate() throws IllegalStateException {
    }

    protected void putAttributes(AttributeGenerator generator) {
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
    }

    protected void generate(XmlWriter w, ExtensionProfile p, XmlNamespace namespace, String localName, List<XmlWriter.Attribute> attrs, AttributeGenerator generator) throws IOException {
        w.simpleElement(namespace, localName, attrs, generator.getContent());
    }

    @Override
    public void generate(XmlWriter w, ExtensionProfile p) throws IOException {
        if (this.namespace == null) {
            String name = this.getClass().getName();
            throw new IllegalStateException("No @ExtensionDescription.Default annotation found on subclass " + name.substring(name.lastIndexOf(46) + 1));
        }
        this.validate();
        AttributeGenerator generator = new AttributeGenerator();
        this.putAttributes(generator);
        ArrayList<XmlWriter.Attribute> attrs = new ArrayList<XmlWriter.Attribute>();
        this.generateAttributes(attrs, generator);
        this.generate(w, p, this.namespace, this.localName, attrs, generator);
    }

    protected void generateAttributes(List<XmlWriter.Attribute> attrs, AttributeGenerator generator) {
        for (Map.Entry entry : generator.entrySet()) {
            String value = (String)entry.getValue();
            if (value == null) continue;
            attrs.add(new XmlWriter.Attribute((String)entry.getKey(), value));
        }
    }

    @Override
    public XmlParser.ElementHandler getHandler(ExtensionProfile p, String namespace, String localName, Attributes attrs) throws ParseException {
        return new AttributesHandler(attrs);
    }

    protected final void throwExceptionIfImmutable() {
        if (this.immutable) {
            throw new IllegalStateException(this.localName + " instance is read only");
        }
    }

    protected static final void throwExceptionForMissingAttribute(String attrName) {
        throw new IllegalStateException("Missing attribute: " + attrName);
    }

    protected boolean sameClassAs(Object o) {
        return o != null && this.getClass().equals(o.getClass());
    }

    protected static boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    protected class AttributesHandler
    extends XmlParser.ElementHandler {
        private final AttributeHelper helper;

        public AttributesHandler(Attributes attrs) {
            AttributeHelper attributeHelper = this.helper = attrs == null ? null : new AttributeHelper(attrs);
            if (AbstractExtension.this.immutable) {
                throw new IllegalStateException("Cannot parse into immutable instance");
            }
        }

        @Override
        public void processEndElement() throws ParseException {
            if (this.helper != null) {
                this.helper.setContent(this.value);
                AbstractExtension.this.consumeAttributes(this.helper);
                this.helper.assertAllConsumed();
            }
            try {
                AbstractExtension.this.validate();
            }
            catch (IllegalStateException e) {
                throw new ParseException(e.getMessage(), (Throwable)e);
            }
        }
    }
}

