/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.IContent;
import com.google.gdata.data.OtherContent;
import com.google.gdata.data.OutOfLineContent;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.data.TextContent;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import org.xml.sax.Attributes;

public abstract class Content
implements IContent {
    @Override
    public abstract int getType();

    @Override
    public abstract String getLang();

    public abstract void generateAtom(XmlWriter var1, ExtensionProfile var2) throws IOException;

    public abstract void generateRss(XmlWriter var1, ExtensionProfile var2) throws IOException;

    public static ChildHandlerInfo getChildHandler(ExtensionProfile extProfile, Attributes attrs) throws ParseException, IOException {
        String type = attrs.getValue("", "type");
        ChildHandlerInfo childHandlerInfo = new ChildHandlerInfo();
        String src = attrs.getValue("", "src");
        if (src == null) {
            if (type == null || type.equals("text") || type.equals("text/plain") || type.equals("html") || type.equals("text/html") || type.equals("xhtml")) {
                TextContent tc = new TextContent();
                TextConstruct.ChildHandlerInfo chi = TextConstruct.getChildHandler(attrs);
                tc.setContent(chi.textConstruct);
                childHandlerInfo.handler = chi.handler;
                childHandlerInfo.content = tc;
            } else {
                OtherContent oc;
                OtherContent otherContent = oc = new OtherContent();
                otherContent.getClass();
                childHandlerInfo.handler = new OtherContent.AtomHandler(otherContent, extProfile, attrs);
                childHandlerInfo.content = oc;
            }
        } else {
            OutOfLineContent oolc = new OutOfLineContent();
            childHandlerInfo.handler = new OutOfLineContent.AtomHandler(oolc);
            childHandlerInfo.content = oolc;
        }
        return childHandlerInfo;
    }

    public static class ChildHandlerInfo {
        public XmlParser.ElementHandler handler;
        public Content content;
    }

    public static class Type {
        public static final int TEXT = 1;
        public static final int HTML = 2;
        public static final int XHTML = 3;
        public static final int OTHER_TEXT = 4;
        public static final int OTHER_XML = 5;
        public static final int OTHER_BINARY = 6;
        public static final int MEDIA = 7;
    }
}

