/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.data.Category;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.ServiceException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Kind {
    private static Map<String, List<Class<Adaptor>>> kindAdaptors = new HashMap<String, List<Class<Adaptor>>>();

    public static boolean isKindCategory(Category category) {
        return "http://schemas.google.com/g/2005#kind".equals(category.getScheme());
    }

    public static String getKindServiceName(String kindTerm) {
        StringBuilder serviceName = new StringBuilder(kindTerm.length());
        try {
            int lastIndex;
            URL termUrl = new URL(kindTerm);
            String[] hostComponents = termUrl.getHost().split("\\W");
            for (int i = lastIndex = hostComponents.length - 1; i >= 0; --i) {
                if (i != lastIndex) {
                    serviceName.append(".");
                }
                serviceName.append(hostComponents[i]);
            }
            String[] pathComponents = termUrl.getPath().split("\\W");
            for (int i = 0; i < pathComponents.length; ++i) {
                if (pathComponents[i].length() <= 0) continue;
                serviceName.append(".");
                serviceName.append(pathComponents[i]);
            }
            if (termUrl.getRef() != null) {
                String[] refComponents = termUrl.getRef().split("\\W");
                for (int i = 0; i < refComponents.length; ++i) {
                    if (refComponents[i].length() <= 0) continue;
                    serviceName.append(".");
                    serviceName.append(refComponents[i]);
                }
            }
        }
        catch (MalformedURLException mue) {
            throw new IllegalArgumentException("Kind term must be a valid URL", mue);
        }
        return serviceName.toString();
    }

    public static Class<Adaptor> getAdaptorClass(String kindTerm, Adaptable adaptable) throws AdaptorException {
        ClassLoader cl = adaptable.getClass().getClassLoader();
        List<Class<Adaptor>> adaptorList = kindAdaptors.get(kindTerm);
        if (adaptorList == null) {
            adaptorList = new ArrayList<Class<Adaptor>>();
            String termService = Kind.getKindServiceName(kindTerm);
            try {
                String line;
                InputStream serviceStream = cl.getResourceAsStream("META-INF/gdata/kinds/" + termService);
                if (serviceStream == null) {
                    return null;
                }
                BufferedReader rdr = new BufferedReader(new InputStreamReader(serviceStream));
                while ((line = rdr.readLine()) != null) {
                    if (line.charAt(0) == '#') continue;
                    adaptorList.add(cl.loadClass(line));
                }
            }
            catch (IOException ioe) {
                throw new AdaptorException("Unable to load Adaptor service info", (Throwable)ioe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new AdaptorException("Unable to load Adaptor class", (Throwable)cnfe);
            }
            kindAdaptors.put(kindTerm, adaptorList);
        }
        if (adaptorList.size() == 1) {
            return adaptorList.get(0);
        }
        Object adaptorclass = null;
        for (Class<Adaptor> adaptorClass : adaptorList) {
            Class<Adaptor> checkClass = adaptable.getClass();
            while (Adaptable.class.isAssignableFrom(checkClass)) {
                if (checkClass.isAssignableFrom(adaptorClass)) {
                    return adaptorClass;
                }
                checkClass = checkClass.getSuperclass();
            }
        }
        return null;
    }

    public static Adaptor getAdaptor(String kindTerm, Adaptable adaptable) throws AdaptorException {
        Class<Adaptor> adaptorClass = Kind.getAdaptorClass(kindTerm, adaptable);
        if (adaptorClass == null) {
            return null;
        }
        Adaptor adaptor = adaptable.getAdaptor(adaptorClass);
        if (adaptor == null) {
            Class<?> constructorArgClass;
            Constructor<Adaptor> adaptorConstructor = null;
            for (constructorArgClass = adaptable.getClass(); constructorArgClass != null; constructorArgClass = constructorArgClass.getSuperclass()) {
                try {
                    adaptorConstructor = adaptorClass.getConstructor(constructorArgClass);
                    break;
                }
                catch (NoSuchMethodException nsme) {
                    continue;
                }
            }
            if (adaptorConstructor == null) {
                try {
                    adaptorConstructor = adaptorClass.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException nsme) {
                    throw new AdaptorException("Unable to construct Adaptor " + adaptorClass + " instance for " + adaptable.getClass());
                }
            }
            try {
                adaptor = constructorArgClass == null ? adaptorConstructor.newInstance(new Object[0]) : adaptorConstructor.newInstance(adaptable);
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new AdaptorException("Unable to create kind Adaptor", (Throwable)e);
            }
            adaptable.addAdaptor(adaptor);
        }
        return adaptor;
    }

    public static class AdaptorException
    extends ServiceException {
        public AdaptorException(String message) {
            super(message);
            this.setHttpErrorCodeOverride(500);
        }

        public AdaptorException(String message, Throwable cause) {
            super(message, cause);
            this.setHttpErrorCodeOverride(500);
        }

        public AdaptorException(Throwable cause) {
            super(cause);
            this.setHttpErrorCodeOverride(500);
        }
    }

    public static class AdaptableHelper
    implements Adaptable {
        private List<Adaptor> adaptors = new ArrayList<Adaptor>();

        @Override
        public void addAdaptor(Adaptor adaptor) {
            this.adaptors.add(adaptor);
        }

        @Override
        public Collection<Adaptor> getAdaptors() {
            return this.adaptors;
        }

        @Override
        public <E extends Adaptor> E getAdaptor(Class<E> adaptorClass) {
            for (Adaptor adaptor : this.adaptors) {
                if (!adaptor.getClass().equals(adaptorClass)) continue;
                return (E)((Adaptor)adaptorClass.cast(adaptor));
            }
            return null;
        }
    }

    public static interface Adaptor {
        public void declareExtensions(ExtensionProfile var1);
    }

    public static interface Adaptable {
        public void addAdaptor(Adaptor var1);

        public Collection<Adaptor> getAdaptors();

        public <E extends Adaptor> E getAdaptor(Class<E> var1);
    }

    @Target(value={ElementType.TYPE})
    public static @interface Term {
        public String value();
    }
}

