/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.data.Category;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Generator;
import com.google.gdata.data.Kind;
import com.google.gdata.data.Link;
import com.google.gdata.data.Person;
import com.google.gdata.data.Rfc3339Handler;
import com.google.gdata.data.TextConstruct;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.xml.sax.Attributes;

public class Source
extends ExtensionPoint {
    protected SourceState srcState;

    public Source() {
        this.srcState = new SourceState();
    }

    protected Source(Source sourceSource) {
        super(sourceSource);
        this.srcState = sourceSource.srcState;
    }

    public String getId() {
        return this.srcState.id;
    }

    public void setId(String v) {
        this.srcState.id = v;
    }

    public DateTime getUpdated() {
        return this.srcState.updated;
    }

    public void setUpdated(DateTime v) {
        this.srcState.updated = v;
    }

    public Set<Category> getCategories() {
        return this.srcState.categories;
    }

    public TextConstruct getTitle() {
        return this.srcState.title;
    }

    public void setTitle(TextConstruct v) {
        this.srcState.title = v;
    }

    public TextConstruct getSubtitle() {
        return this.srcState.subtitle;
    }

    public void setSubtitle(TextConstruct v) {
        this.srcState.subtitle = v;
    }

    public TextConstruct getRights() {
        return this.srcState.rights;
    }

    public void setRights(TextConstruct v) {
        this.srcState.rights = v;
    }

    public String getIcon() {
        return this.srcState.icon;
    }

    public void setIcon(String v) {
        this.srcState.icon = v;
    }

    public String getLogo() {
        return this.srcState.logo;
    }

    public void setLogo(String v) {
        this.srcState.logo = v;
    }

    public List<Link> getLinks() {
        return this.srcState.links;
    }

    public List<Person> getAuthors() {
        return this.srcState.authors;
    }

    public List<Person> getContributors() {
        return this.srcState.contributors;
    }

    public Generator getGenerator() {
        return this.srcState.generator;
    }

    public void setGenerator(Generator v) {
        this.srcState.generator = v;
    }

    public Generator setGenerator(String version, String uri, String name) {
        Generator gen = new Generator();
        gen.setVersion(version);
        gen.setUri(uri);
        gen.setName(name);
        this.setGenerator(gen);
        return gen;
    }

    public Link getLink(String rel, String type) {
        for (Link link : this.srcState.links) {
            if (!link.matches(rel, type)) continue;
            return link;
        }
        return null;
    }

    public List<Link> getLinks(String relToMatch, String typeToMatch) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link link : this.srcState.links) {
            if (!link.matches(relToMatch, typeToMatch)) continue;
            result.add(link);
        }
        return result;
    }

    public void addLink(Link link) {
        this.srcState.links.add(link);
    }

    public Link addLink(String rel, String type, String href) {
        Link link = new Link(rel, type, href);
        this.addLink(link);
        return link;
    }

    public void removeLinks(String relToMatch, String typeToMatch) {
        Iterator iterator = this.srcState.links.iterator();
        while (iterator.hasNext()) {
            Link link = (Link)iterator.next();
            if (!link.matches(relToMatch, typeToMatch)) continue;
            iterator.remove();
        }
    }

    public void addHtmlLink(String htmlUri, String lang, String title) {
        Link link = new Link();
        link.setRel("alternate");
        link.setType(Link.Type.HTML);
        link.setHref(htmlUri);
        if (lang != null) {
            link.setHrefLang(lang);
        }
        if (title != null) {
            link.setTitle(title);
        }
        this.srcState.links.add(link);
    }

    public Link getHtmlLink() {
        Link htmlLink = this.getLink("alternate", Link.Type.HTML);
        return htmlLink;
    }

    public void generateAtom(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        this.generateStartElement(w, Namespaces.atomNs, "source", null, null);
        this.generateInnerAtom(w, extProfile);
        this.generateExtensions(w, extProfile);
        w.endElement(Namespaces.atomNs, "source");
    }

    protected void generateInnerAtom(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        if (this.srcState.id != null) {
            w.simpleElement(Namespaces.atomNs, "id", null, this.srcState.id);
        }
        if (this.srcState.updated != null) {
            w.simpleElement(Namespaces.atomNs, "updated", null, this.srcState.updated.toString());
        }
        w.startRepeatingElement();
        for (Category cat : this.srcState.categories) {
            cat.generateAtom(w);
        }
        w.endRepeatingElement();
        if (this.srcState.title != null) {
            this.srcState.title.generateAtom(w, "title");
        }
        if (this.srcState.subtitle != null) {
            this.srcState.subtitle.generateAtom(w, "subtitle");
        }
        if (this.srcState.rights != null) {
            this.srcState.rights.generateAtom(w, "rights");
        }
        if (this.srcState.icon != null) {
            w.simpleElement(Namespaces.atomNs, "icon", null, this.srcState.icon);
        }
        if (this.srcState.logo != null) {
            w.simpleElement(Namespaces.atomNs, "logo", null, this.srcState.logo);
        }
        w.startRepeatingElement();
        for (Link link : this.srcState.links) {
            link.generateAtom(w, extProfile);
        }
        w.endRepeatingElement();
        w.startRepeatingElement();
        for (Person author : this.srcState.authors) {
            author.generateAtom(extProfile, w, "author");
        }
        w.endRepeatingElement();
        w.startRepeatingElement();
        for (Person contributor : this.srcState.contributors) {
            contributor.generateAtom(extProfile, w, "contributor");
        }
        w.endRepeatingElement();
        if (this.srcState.generator != null) {
            this.srcState.generator.generateAtom(w);
        }
    }

    public void parseAtom(ExtensionProfile extProfile, InputStream stream) throws IOException, ParseException {
        SourceHandler handler = new SourceHandler(extProfile);
        new XmlParser().parse(stream, (XmlParser.ElementHandler)handler, "http://www.w3.org/2005/Atom", "source");
    }

    public void parseAtom(ExtensionProfile extProfile, Reader reader) throws IOException, ParseException {
        SourceHandler handler = new SourceHandler(extProfile);
        new XmlParser().parse(reader, (XmlParser.ElementHandler)handler, "http://www.w3.org/2005/Atom", "source");
    }

    public class SourceHandler
    extends ExtensionPoint.ExtensionHandler {
        public SourceHandler(ExtensionProfile extProfile) {
            super(extProfile, Source.class);
        }

        protected SourceHandler(ExtensionProfile extProfile, Class<? extends ExtensionPoint> extClass) {
            super(extProfile, extClass);
        }

        @Override
        public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
            if (namespace.equals("http://www.w3.org/2005/Atom")) {
                if (localName.equals("id")) {
                    return new IdHandler();
                }
                if (localName.equals("updated")) {
                    return new UpdatedHandler();
                }
                if (localName.equals("category")) {
                    Category cat = new Category();
                    Kind.Adaptable adaptable = Source.this instanceof Kind.Adaptable ? (Kind.Adaptable)((Object)Source.this) : null;
                    Category category = cat;
                    category.getClass();
                    return category.new Category.AtomHandler(this.extProfile, Source.this.srcState.categories, adaptable);
                }
                if (localName.equals("title")) {
                    TextConstruct.ChildHandlerInfo chi = TextConstruct.getChildHandler(attrs);
                    if (Source.this.srcState.title != null) {
                        throw new ParseException(CoreErrorDomain.ERR.duplicateTitle);
                    }
                    Source.this.srcState.title = chi.textConstruct;
                    return chi.handler;
                }
                if (localName.equals("subtitle")) {
                    TextConstruct.ChildHandlerInfo chi = TextConstruct.getChildHandler(attrs);
                    if (Source.this.srcState.subtitle != null) {
                        throw new ParseException(CoreErrorDomain.ERR.duplicateSubtitle);
                    }
                    Source.this.srcState.subtitle = chi.textConstruct;
                    return chi.handler;
                }
                if (localName.equals("rights")) {
                    TextConstruct.ChildHandlerInfo chi = TextConstruct.getChildHandler(attrs);
                    if (Source.this.srcState.rights != null) {
                        throw new ParseException(CoreErrorDomain.ERR.duplicateRights);
                    }
                    Source.this.srcState.rights = chi.textConstruct;
                    return chi.handler;
                }
                if (localName.equals("icon")) {
                    return new IconHandler();
                }
                if (localName.equals("logo")) {
                    return new LogoHandler();
                }
                if (localName.equals("link")) {
                    Link link = new Link();
                    Source.this.srcState.links.add(link);
                    Link link2 = link;
                    link2.getClass();
                    return link2.new Link.AtomHandler(this.extProfile);
                }
                if (localName.equals("author")) {
                    Person author = new Person();
                    Source.this.srcState.authors.add(author);
                    Person person = author;
                    person.getClass();
                    return person.new Person.AtomHandler(this.extProfile);
                }
                if (localName.equals("contributor")) {
                    Person contributor = new Person();
                    Source.this.srcState.contributors.add(contributor);
                    Person person = contributor;
                    person.getClass();
                    return person.new Person.AtomHandler(this.extProfile);
                }
                if (localName.equals("generator")) {
                    if (Source.this.srcState.generator != null) {
                        throw new ParseException(CoreErrorDomain.ERR.duplicateGenerator);
                    }
                    Source.this.srcState.generator = new Generator();
                    return Source.this.srcState.generator.new Generator.AtomHandler();
                }
            } else {
                return super.getChildHandler(namespace, localName, attrs);
            }
            return null;
        }

        private class LogoHandler
        extends XmlParser.ElementHandler {
            private LogoHandler() {
            }

            @Override
            public void processEndElement() throws ParseException {
                if (Source.this.srcState.logo != null) {
                    throw new ParseException(CoreErrorDomain.ERR.duplicateLogo);
                }
                if (this.value == null) {
                    throw new ParseException(CoreErrorDomain.ERR.logoValueRequired);
                }
                Source.this.srcState.logo = this.value;
            }
        }

        private class IconHandler
        extends XmlParser.ElementHandler {
            private IconHandler() {
            }

            @Override
            public void processEndElement() throws ParseException {
                if (Source.this.srcState.icon != null) {
                    throw new ParseException(CoreErrorDomain.ERR.duplicateIcon);
                }
                if (this.value == null) {
                    throw new ParseException(CoreErrorDomain.ERR.iconValueRequired);
                }
                Source.this.srcState.icon = this.value;
            }
        }

        class UpdatedHandler
        extends Rfc3339Handler {
            UpdatedHandler() {
            }

            @Override
            public void processEndElement() throws ParseException {
                super.processEndElement();
                Source.this.srcState.updated = this.getDateTime();
            }
        }

        private class IdHandler
        extends XmlParser.ElementHandler {
            private IdHandler() {
            }

            @Override
            public void processEndElement() throws ParseException {
                if (Source.this.srcState.id != null) {
                    throw new ParseException(CoreErrorDomain.ERR.duplicateFeedId);
                }
                if (this.value == null) {
                    throw new ParseException(CoreErrorDomain.ERR.idValueRequired);
                }
                Source.this.srcState.id = this.value;
            }
        }
    }

    protected static class SourceState {
        public String id;
        public DateTime updated;
        public HashSet<Category> categories = new HashSet();
        public TextConstruct title;
        public TextConstruct subtitle;
        public TextConstruct rights;
        public String icon;
        public String logo;
        public LinkedList<Link> links = new LinkedList();
        public LinkedList<Person> authors = new LinkedList();
        public LinkedList<Person> contributors = new LinkedList();
        public Generator generator;

        protected SourceState() {
        }
    }
}

