/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.geo.impl;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.geo.Point;
import com.google.gdata.data.geo.PointData;
import com.google.gdata.data.geo.impl.GeoRssPoint;
import com.google.gdata.data.geo.impl.GeoRssWhere;
import com.google.gdata.data.geo.impl.W3CPoint;

public class PointDataImpl
implements PointData {
    private ExtensionPoint extPoint;

    public PointDataImpl(ExtensionPoint extensionPoint) {
        this.extPoint = extensionPoint;
    }

    @Override
    public void setGeoLocation(Double lat, Double lon) throws IllegalArgumentException {
        this.setGeoLocation(new GeoRssWhere(lat, lon));
    }

    @Override
    public void setGeoLocation(Point point) {
        PointDataImpl.setPoint(this.extPoint, point);
    }

    @Override
    public Point getGeoLocation() {
        return PointDataImpl.getPoint(this.extPoint);
    }

    @Override
    public void clearPoint() {
        PointDataImpl.clearPoint(this.extPoint);
    }

    public void declareExtensions(ExtensionProfile extProfile) {
        Class<?> extClass = this.extPoint.getClass();
        this.declare(extProfile, extClass, W3CPoint.getDefaultDescription(false));
        this.declare(extProfile, extClass, GeoRssPoint.getDefaultDescription(false));
        this.declare(extProfile, extClass, GeoRssWhere.getDefaultDescription(false));
        new W3CPoint().declareExtensions(extProfile);
        new GeoRssWhere().declareExtensions(extProfile);
    }

    private void declare(ExtensionProfile extProfile, Class<? extends ExtensionPoint> extClass, ExtensionDescription desc) {
        extProfile.declare(extClass, desc);
        if (BaseEntry.class.isAssignableFrom(extClass)) {
            extProfile.declare(BaseEntry.class, desc);
        }
    }

    public static void setPoint(ExtensionPoint ext, Point point) {
        Point existing = PointDataImpl.getPointExtension(ext);
        if (existing != null) {
            Double lat = point != null ? point.getLatitude() : null;
            Double lon = point != null ? point.getLongitude() : null;
            existing.setGeoLocation(lat, lon);
        } else if (point != null) {
            ext.setExtension(point);
        }
    }

    static Point getPointExtension(ExtensionPoint ext) {
        for (Extension e : ext.getExtensions()) {
            if (!(e instanceof Point)) continue;
            return (Point)e;
        }
        return null;
    }

    public static Point getPoint(ExtensionPoint ext) {
        Point p = PointDataImpl.getPointExtension(ext);
        if (p != null) {
            if (p instanceof GeoRssWhere) {
                GeoRssWhere geoWhere = (GeoRssWhere)p;
                if (geoWhere.hasPoint()) {
                    return geoWhere;
                }
            } else {
                return p;
            }
        }
        return null;
    }

    public static void clearPoint(ExtensionPoint ext) {
        Point p = PointDataImpl.getPointExtension(ext);
        if (p != null) {
            GeoRssWhere where;
            if (p instanceof GeoRssWhere && (where = (GeoRssWhere)p).hasBox()) {
                where.clearPoint();
                return;
            }
            ext.removeExtension(p);
        }
    }
}

