/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test;

import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.routing.Filter;
import org.restlet.test.RestletTestCase;

public abstract class AbstractFilterTestCase
extends RestletTestCase {
    protected abstract Filter getFilter();

    protected abstract Request getRequest();

    protected abstract Response getResponse(Request var1);

    protected abstract Restlet getRestlet();

    protected abstract Class<?> getRestletClass();

    public void testAttachDetachInstance() throws Exception {
        Filter filter = this.getFilter();
        AbstractFilterTestCase.assertFalse((boolean)filter.hasNext());
        filter.setNext(this.getRestlet());
        filter.start();
        AbstractFilterTestCase.assertTrue((boolean)filter.isStarted());
        AbstractFilterTestCase.assertFalse((boolean)filter.isStopped());
        Request request = this.getRequest();
        Response response = this.getResponse(request);
        filter.handle(request, response);
        AbstractFilterTestCase.assertTrue((boolean)filter.hasNext());
        filter.setNext((Restlet)null);
        AbstractFilterTestCase.assertFalse((boolean)filter.hasNext());
    }

    public void testIllegalStartedState() throws Exception {
        Filter filter = this.getFilter();
        filter.setNext(this.getRestlet());
        AbstractFilterTestCase.assertTrue((boolean)filter.hasNext());
        AbstractFilterTestCase.assertFalse((boolean)filter.isStarted());
        AbstractFilterTestCase.assertTrue((boolean)filter.isStopped());
        Request request = this.getRequest();
        Response response = this.getResponse(request);
        try {
            filter.handle(request, response);
            if (!filter.isStarted()) {
                AbstractFilterTestCase.fail((String)"Filter handles call without being started");
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    public void testIllegalTarget() throws Exception {
        Filter filter = this.getFilter();
        filter.start();
        AbstractFilterTestCase.assertTrue((boolean)filter.isStarted());
        AbstractFilterTestCase.assertFalse((boolean)filter.isStopped());
        AbstractFilterTestCase.assertFalse((boolean)filter.hasNext());
        Request request = this.getRequest();
        Response response = this.getResponse(request);
        try {
            filter.handle(request, response);
            AbstractFilterTestCase.fail((String)"Filter handles call without a target");
        }
        catch (Exception ex) {
            // empty catch block
        }
    }
}

