/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test;

import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Status;
import org.restlet.engine.header.Header;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.test.RestletTestCase;
import org.restlet.util.Series;

public class HeaderTestCase
extends RestletTestCase {
    private static final String TEST_HEADER = "testHeader";
    private Component component;
    private Client client;

    private static Series<Header> getHttpHeaders(Request request) {
        Series headers = (Series)request.getAttributes().get("org.restlet.http.headers");
        if (headers == null) {
            headers = new Series(Header.class);
            request.getAttributes().put("org.restlet.http.headers", headers);
        }
        return headers;
    }

    private Response getWithParams(Header ... additionalHeaders) throws Exception {
        Request request = new Request(Method.GET, "http://localhost:" + TEST_PORT);
        Series<Header> headers = HeaderTestCase.getHttpHeaders(request);
        for (Header header : additionalHeaders) {
            headers.add((Object)header);
        }
        Response result = this.client.handle(request);
        return result;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.client = new Client(Protocol.HTTP);
        if (this.component == null) {
            this.component = new Component();
            this.component.getServers().add(Protocol.HTTP, TEST_PORT);
            this.component.getDefaultHost().attachDefault((Restlet)new TestHeaderRestlet());
        }
        if (!this.component.isStarted()) {
            this.component.start();
        }
    }

    @Override
    public void tearDown() throws Exception {
        this.client.stop();
        this.component.stop();
        this.component = null;
        super.tearDown();
    }

    public void test0() throws Exception {
        Response response = this.getWithParams(new Header[0]);
        HeaderTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        HeaderTestCase.assertEquals(null, (String)response.getEntity().getText());
    }

    public void test1() throws Exception {
        Response response = this.getWithParams(new Header(TEST_HEADER, "a"));
        HeaderTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        HeaderTestCase.assertEquals((String)"a\n", (String)response.getEntity().getText());
    }

    public void test2() throws Exception {
        Response response = this.getWithParams(new Header(TEST_HEADER, "a"), new Header(TEST_HEADER, "b"));
        HeaderTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
        HeaderTestCase.assertEquals((String)"a\nb\n", (String)response.getEntity().getText());
    }

    public static class TestHeaderRestlet
    extends Restlet {
        public void handle(Request request, Response response) {
            StringBuilder stb = new StringBuilder();
            Series headers = HeaderTestCase.getHttpHeaders(request);
            for (Header header : headers) {
                if (!HeaderTestCase.TEST_HEADER.equalsIgnoreCase(header.getName())) continue;
                stb.append(header.getValue());
                stb.append('\n');
            }
            response.setEntity((Representation)new StringRepresentation((CharSequence)stb, MediaType.TEXT_PLAIN));
        }
    }
}

