/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test;

import junit.framework.TestCase;
import org.restlet.engine.Engine;
import org.restlet.engine.connector.HttpServerHelper;
import org.restlet.ext.httpclient.HttpClientHelper;
import org.restlet.representation.ObjectRepresentation;

public abstract class RestletTestCase
extends TestCase {
    public static final int DEFAULT_TEST_PORT = 1337;
    private static final String PROPERTY_TEST_PORT = "org.restlet.test.port";
    public static int TEST_PORT = RestletTestCase.getTestPort();

    private static int getTestPort() {
        if (System.getProperties().containsKey(PROPERTY_TEST_PORT)) {
            return Integer.parseInt(System.getProperty(PROPERTY_TEST_PORT));
        }
        return 1337;
    }

    protected void setUp() throws Exception {
        super.setUp();
        System.out.println("Setting up test " + ((Object)((Object)this)).getClass().getName() + "#" + this.getName());
        this.setUpEngine();
    }

    protected void setUpEngine() {
        Engine.clearThreadLocalVariables();
        Engine.register();
        Engine.getInstance().getRegisteredServers().add(0, new HttpServerHelper(null));
        Engine.getInstance().getRegisteredClients().add(0, new HttpClientHelper(null));
        ObjectRepresentation.VARIANT_OBJECT_XML_SUPPORTED = true;
        ObjectRepresentation.VARIANT_OBJECT_BINARY_SUPPORTED = true;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.tearDownEngine();
    }

    protected void tearDownEngine() {
        Engine.clearThreadLocalVariables();
    }
}

