/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.data;

import java.util.ArrayList;
import org.restlet.Request;
import org.restlet.data.ClientInfo;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Preference;
import org.restlet.representation.Variant;
import org.restlet.service.ConnegService;
import org.restlet.service.MetadataService;
import org.restlet.test.RestletTestCase;

public class ClientInfoTestCase
extends RestletTestCase {
    MetadataService ms;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.ms = new MetadataService();
    }

    @Override
    protected void tearDown() throws Exception {
        this.ms = null;
        super.tearDown();
    }

    public void testConneg() throws Exception {
        ConnegService connegService = new ConnegService();
        Request request = new Request();
        ClientInfo ci = request.getClientInfo();
        ci.getAcceptedLanguages().add(new Preference((Metadata)Language.ENGLISH_US, 1.0f));
        ci.getAcceptedLanguages().add(new Preference((Metadata)Language.FRENCH_FRANCE, 0.9f));
        ci.getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.TEXT_XML, 1.0f));
        ArrayList<Variant> variants = new ArrayList<Variant>();
        variants.add(new Variant(MediaType.TEXT_XML, Language.ENGLISH_US));
        variants.add(new Variant(MediaType.TEXT_XML, Language.FRENCH_FRANCE));
        Variant pv = connegService.getPreferredVariant(variants, request, this.ms);
        ClientInfoTestCase.assertEquals((Object)MediaType.TEXT_XML, (Object)pv.getMediaType());
        ClientInfoTestCase.assertEquals((Object)Language.ENGLISH_US, pv.getLanguages().get(0));
        variants.clear();
        variants.add(new Variant(MediaType.TEXT_XML, Language.ENGLISH));
        variants.add(new Variant(MediaType.TEXT_XML, Language.FRENCH));
        pv = connegService.getPreferredVariant(variants, request, this.ms);
        ClientInfoTestCase.assertEquals((Object)MediaType.TEXT_XML, (Object)pv.getMediaType());
        ClientInfoTestCase.assertEquals((Object)Language.ENGLISH, pv.getLanguages().get(0));
        variants.clear();
        variants.add(new Variant(MediaType.TEXT_PLAIN, Language.ENGLISH));
        variants.add(new Variant(MediaType.TEXT_XML, Language.FRENCH_FRANCE));
        pv = connegService.getPreferredVariant(variants, request, this.ms);
        ClientInfoTestCase.assertEquals((Object)MediaType.TEXT_XML, (Object)pv.getMediaType());
        ClientInfoTestCase.assertEquals((Object)Language.FRENCH_FRANCE, pv.getLanguages().get(0));
        variants.clear();
        variants.add(new Variant(MediaType.APPLICATION_XML, Language.ENGLISH_US));
        variants.add(new Variant(MediaType.TEXT_XML, Language.FRENCH_FRANCE));
        pv = connegService.getPreferredVariant(variants, request, this.ms);
        ClientInfoTestCase.assertEquals((Object)MediaType.TEXT_XML, (Object)pv.getMediaType());
        ClientInfoTestCase.assertEquals((Object)Language.FRENCH_FRANCE, pv.getLanguages().get(0));
        variants.clear();
        variants.add(new Variant(MediaType.APPLICATION_XML, Language.ENGLISH_US));
        variants.add(new Variant(MediaType.APPLICATION_XML, Language.FRENCH_FRANCE));
        pv = connegService.getPreferredVariant(variants, request, this.ms);
        ClientInfoTestCase.assertEquals((Object)MediaType.APPLICATION_XML, (Object)pv.getMediaType());
        ClientInfoTestCase.assertEquals((Object)Language.ENGLISH_US, pv.getLanguages().get(0));
    }

    public void testConnegIO() throws Exception {
        ClientInfo ci = new ClientInfo();
        ci.getAcceptedMediaTypes().add(new Preference((Metadata)MediaType.ALL, 1.0f));
        ArrayList<MediaType> types = new ArrayList<MediaType>();
        types.add(MediaType.TEXT_XML);
        types.add(MediaType.APPLICATION_JSON);
        MediaType pmt = ci.getPreferredMediaType(types);
        ClientInfoTestCase.assertEquals((Object)MediaType.TEXT_XML, (Object)pmt);
    }
}

