/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.engine;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.junit.Assert;
import org.restlet.data.Reference;
import org.restlet.engine.util.AlphaNumericComparator;
import org.restlet.test.RestletTestCase;

public class AlphaNumericComparatorTestCase
extends RestletTestCase {
    private static List<Reference> unsorted = AlphaNumericComparatorTestCase.refs("1", "2", "3", "1.0", "1.1", "1.1.1", "2.0", "2.2", "2.2.2", "3.0", "3.3");
    private static List<Reference> expected = AlphaNumericComparatorTestCase.refs("1", "1.0", "1.1", "1.1.1", "2", "2.0", "2.2", "2.2.2", "3", "3.0", "3.3");

    private static List<Reference> refs(String ... uris) {
        LinkedList<Reference> result = new LinkedList<Reference>();
        for (String uri : uris) {
            result.add(new Reference(uri));
        }
        return result;
    }

    public void testBug() {
        ArrayList<Reference> result = new ArrayList<Reference>(unsorted);
        Collections.sort(result, new AlphaNumericComparator());
        Assert.assertEquals(expected, result);
    }

    public void test02() throws Exception {
        AlphaNumericComparator anc = new AlphaNumericComparator();
        System.out.println(anc.compare("Intel 5000X", "Intel 5500"));
        System.out.println(anc.compare("66", "3"));
        System.out.println(anc.compare("200", "66"));
        System.out.println(anc.compare("18", "2"));
    }
}

