/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.engine;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.restlet.data.ClientInfo;
import org.restlet.data.Encoding;
import org.restlet.data.MediaType;
import org.restlet.data.Preference;
import org.restlet.engine.header.EncodingReader;
import org.restlet.engine.header.Header;
import org.restlet.engine.header.HeaderReader;
import org.restlet.engine.header.HeaderUtils;
import org.restlet.engine.header.PreferenceReader;
import org.restlet.engine.header.TokenReader;
import org.restlet.engine.util.Base64;
import org.restlet.engine.util.DateUtils;
import org.restlet.representation.Representation;
import org.restlet.test.RestletTestCase;

public class HeaderTestCase
extends RestletTestCase {
    public void testAddValues() {
        ArrayList list = new ArrayList();
        new EncodingReader("gzip,deflate").addValues(list);
        HeaderTestCase.assertEquals((int)list.size(), (int)2);
        HeaderTestCase.assertEquals(list.get(0), (Object)Encoding.GZIP);
        HeaderTestCase.assertEquals(list.get(1), (Object)Encoding.DEFLATE);
        list = new ArrayList();
        new EncodingReader("gzip,identity, deflate").addValues(list);
        HeaderTestCase.assertEquals((int)list.size(), (int)2);
        HeaderTestCase.assertEquals(list.get(0), (Object)Encoding.GZIP);
        HeaderTestCase.assertEquals(list.get(1), (Object)Encoding.DEFLATE);
        list = new ArrayList();
        new EncodingReader("identity").addValues(list);
        HeaderTestCase.assertTrue((boolean)list.isEmpty());
        list = new ArrayList();
        new EncodingReader("identity,").addValues(list);
        HeaderTestCase.assertTrue((boolean)list.isEmpty());
        list = new ArrayList();
        new EncodingReader("").addValues(list);
        HeaderTestCase.assertTrue((boolean)list.isEmpty());
        list = new ArrayList();
        new EncodingReader(null).addValues(list);
        HeaderTestCase.assertTrue((boolean)list.isEmpty());
        TokenReader tr = new TokenReader("bytes");
        List l = tr.readValues();
        HeaderTestCase.assertTrue((boolean)l.contains("bytes"));
        tr = new TokenReader("bytes,");
        l = tr.readValues();
        HeaderTestCase.assertTrue((boolean)l.contains("bytes"));
        HeaderTestCase.assertEquals((int)l.size(), (int)1);
        tr = new TokenReader("");
        l = tr.readValues();
        HeaderTestCase.assertEquals((int)l.size(), (int)1);
    }

    public void testExtracting() {
        ArrayList<Header> headers = new ArrayList<Header>();
        String md5hash = "aaaaaaaaaaaaaaaa";
        String encodedWithPadding = Base64.encode((byte[])md5hash.getBytes(), (boolean)false);
        String encodedNoPadding = encodedWithPadding.substring(0, 22);
        Header header = new Header("Content-MD5", encodedWithPadding);
        headers.add(header);
        Representation rep = HeaderUtils.extractEntityHeaders(headers, null);
        HeaderTestCase.assertEquals((String)rep.getDigest().getAlgorithm(), (String)"MD5");
        HeaderTestCase.assertEquals((String)new String(rep.getDigest().getValue()), (String)md5hash);
        header.setValue(encodedNoPadding);
        rep = HeaderUtils.extractEntityHeaders(headers, null);
        HeaderTestCase.assertEquals((String)rep.getDigest().getAlgorithm(), (String)"MD5");
        HeaderTestCase.assertEquals((String)new String(rep.getDigest().getValue()), (String)md5hash);
    }

    public void testInvalidDate() {
        String headerValue = "-1";
        Date date = DateUtils.parse((String)"-1", (List)DateUtils.FORMAT_RFC_1123);
        HeaderTestCase.assertNull((Object)date);
        Date unmodifiableDate = DateUtils.unmodifiable((Date)date);
        HeaderTestCase.assertNull((Object)unmodifiableDate);
    }

    public void testParsing() {
        String header1 = "Accept-Encoding,User-Agent";
        String header2 = "Accept-Encoding , User-Agent";
        String header3 = "Accept-Encoding,\r\tUser-Agent";
        String header4 = "Accept-Encoding,\r User-Agent";
        String header5 = "Accept-Encoding, \r \t User-Agent";
        String[] values = new String[]{"Accept-Encoding", "User-Agent"};
        this.testValues(header1, values);
        this.testValues(header2, values);
        this.testValues("Accept-Encoding,\r\tUser-Agent", values);
        this.testValues("Accept-Encoding,\r User-Agent", values);
        this.testValues("Accept-Encoding, \r \t User-Agent", values);
        header1 = "Accept-Encoding, Accept-Language, Accept";
        header2 = "Accept-Encoding,Accept-Language,Accept";
        values = new String[]{"Accept-Encoding", "Accept-Language", "Accept"};
        this.testValues(header1, values);
        this.testValues(header2, values);
        header1 = "gzip;q=1.0, identity;q=0.5 , *;q=0";
        ClientInfo clientInfo = new ClientInfo();
        PreferenceReader.addEncodings((String)header1, (ClientInfo)clientInfo);
        HeaderTestCase.assertEquals((Object)((Preference)clientInfo.getAcceptedEncodings().get(0)).getMetadata(), (Object)Encoding.GZIP);
        HeaderTestCase.assertEquals((Object)Float.valueOf(((Preference)clientInfo.getAcceptedEncodings().get(0)).getQuality()), (Object)Float.valueOf(1.0f));
        HeaderTestCase.assertEquals((Object)((Preference)clientInfo.getAcceptedEncodings().get(1)).getMetadata(), (Object)Encoding.IDENTITY);
        HeaderTestCase.assertEquals((Object)Float.valueOf(((Preference)clientInfo.getAcceptedEncodings().get(1)).getQuality()), (Object)Float.valueOf(0.5f));
        HeaderTestCase.assertEquals((Object)((Preference)clientInfo.getAcceptedEncodings().get(2)).getMetadata(), (Object)Encoding.ALL);
        HeaderTestCase.assertEquals((Object)Float.valueOf(((Preference)clientInfo.getAcceptedEncodings().get(2)).getQuality()), (Object)Float.valueOf(0.0f));
        header1 = "text/html, image/gif, image/jpeg, *; q=.2, */*; q=.2";
        clientInfo = new ClientInfo();
        PreferenceReader.addMediaTypes((String)header1, (ClientInfo)clientInfo);
        HeaderTestCase.assertEquals((Object)((Preference)clientInfo.getAcceptedMediaTypes().get(0)).getMetadata(), (Object)MediaType.TEXT_HTML);
        HeaderTestCase.assertEquals((Object)Float.valueOf(((Preference)clientInfo.getAcceptedMediaTypes().get(0)).getQuality()), (Object)Float.valueOf(1.0f));
        HeaderTestCase.assertEquals((Object)((Preference)clientInfo.getAcceptedMediaTypes().get(1)).getMetadata(), (Object)MediaType.IMAGE_GIF);
        HeaderTestCase.assertEquals((Object)Float.valueOf(((Preference)clientInfo.getAcceptedMediaTypes().get(1)).getQuality()), (Object)Float.valueOf(1.0f));
        HeaderTestCase.assertEquals((Object)((Preference)clientInfo.getAcceptedMediaTypes().get(2)).getMetadata(), (Object)MediaType.IMAGE_JPEG);
        HeaderTestCase.assertEquals((Object)Float.valueOf(((Preference)clientInfo.getAcceptedMediaTypes().get(2)).getQuality()), (Object)Float.valueOf(1.0f));
        HeaderTestCase.assertEquals((Object)((Preference)clientInfo.getAcceptedMediaTypes().get(3)).getMetadata(), (Object)new MediaType("*"));
        HeaderTestCase.assertEquals((Object)Float.valueOf(((Preference)clientInfo.getAcceptedMediaTypes().get(3)).getQuality()), (Object)Float.valueOf(0.2f));
        HeaderTestCase.assertEquals((Object)((Preference)clientInfo.getAcceptedMediaTypes().get(4)).getMetadata(), (Object)MediaType.ALL);
        HeaderTestCase.assertEquals((Object)Float.valueOf(((Preference)clientInfo.getAcceptedMediaTypes().get(4)).getQuality()), (Object)Float.valueOf(0.2f));
        header1 = "text/html, application/vnd.wap.xhtml+xml, application/xhtml+xml; profile=\"http://www.wapforum.org/xhtml\", image/gif, image/jpeg, image/pjpeg, audio/amr, */*";
        clientInfo = new ClientInfo();
        PreferenceReader.addMediaTypes((String)header1, (ClientInfo)clientInfo);
        HeaderTestCase.assertEquals((Object)((Preference)clientInfo.getAcceptedMediaTypes().get(0)).getMetadata(), (Object)MediaType.TEXT_HTML);
        HeaderTestCase.assertEquals((Object)Float.valueOf(((Preference)clientInfo.getAcceptedMediaTypes().get(0)).getQuality()), (Object)Float.valueOf(1.0f));
    }

    public void testValues(String header, String[] values) {
        HeaderReader hr = new HeaderReader(header);
        String value = hr.readRawValue();
        int index = 0;
        while (value != null) {
            HeaderTestCase.assertEquals((String)value, (String)values[index]);
            ++index;
            value = hr.readRawValue();
        }
    }
}

