/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.engine;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.restlet.engine.io.UnclosableOutputStream;
import org.restlet.test.RestletTestCase;

public class UnclosableOutputStreamTestCase
extends RestletTestCase {
    public void testClose() throws IOException {
        MockOutputStream stream = new MockOutputStream();
        UnclosableOutputStream out = new UnclosableOutputStream((OutputStream)stream);
        out.close();
        UnclosableOutputStreamTestCase.assertFalse((boolean)stream.closed);
        stream.close();
        UnclosableOutputStreamTestCase.assertTrue((boolean)stream.closed);
    }

    public void testWrite() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        UnclosableOutputStream out = new UnclosableOutputStream((OutputStream)stream);
        out.write(97);
        UnclosableOutputStreamTestCase.assertEquals((String)"a", (String)new String(stream.toByteArray()));
        out.write(new byte[]{98, 99});
        UnclosableOutputStreamTestCase.assertEquals((String)"abc", (String)new String(stream.toByteArray()));
        out.write(new byte[]{100, 101, 102, 103}, 0, 2);
        UnclosableOutputStreamTestCase.assertEquals((String)"abcde", (String)new String(stream.toByteArray()));
        out.close();
    }

    static class MockOutputStream
    extends OutputStream {
        boolean closed = false;

        MockOutputStream() {
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }

        @Override
        public void write(int b) throws IOException {
        }
    }
}

