/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.engine.connector;

import java.util.concurrent.CountDownLatch;
import junit.framework.TestCase;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Context;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.Server;
import org.restlet.Uniform;
import org.restlet.data.MediaType;
import org.restlet.data.Method;
import org.restlet.data.Protocol;
import org.restlet.data.Reference;
import org.restlet.data.Status;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.test.RestletTestCase;

public class AsynchroneTestCase
extends RestletTestCase {
    private Context context;
    private Component clientComponent;
    private Component originComponent;

    private boolean requestEntityExpected(Method method) {
        return method == Method.POST || method == Method.PUT;
    }

    private boolean responseEntityExpected(Method method) {
        return method == Method.GET || method == Method.PUT;
    }

    private void testCall(Context context, int count, Method method) throws Exception {
        final CountDownLatch latch = new CountDownLatch(count);
        Uniform responseHandler = new Uniform(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handle(Request request, Response response) {
                String item = request.getResourceRef().getQueryAsForm().getFirstValue("item");
                try {
                    TestCase.assertEquals((String)item, (String)Integer.toString(response.getAge()));
                    if (AsynchroneTestCase.this.responseEntityExpected(request.getMethod())) {
                        TestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)response.getStatus());
                        TestCase.assertTrue((boolean)response.isEntityAvailable());
                        TestCase.assertNotNull((Object)response.getEntityAsText());
                    } else {
                        TestCase.assertEquals((Object)Status.SUCCESS_NO_CONTENT, (Object)response.getStatus());
                        TestCase.assertFalse((boolean)response.isEntityAvailable());
                    }
                }
                finally {
                    latch.countDown();
                }
            }
        };
        Restlet client = context.getClientDispatcher();
        for (int i = 0; i < count; ++i) {
            StringRepresentation rep = null;
            if (this.requestEntityExpected(method)) {
                rep = new StringRepresentation((CharSequence)("Item: " + i));
            }
            Reference ref = new Reference("http://localhost:" + TEST_PORT + "/?item=" + i);
            Request request = new Request(method, ref, (Representation)rep);
            request.setOnResponse(responseHandler);
            client.handle(request);
        }
        latch.await();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.clientComponent = new Component();
        this.originComponent = new Component();
        Restlet trace = new Restlet(this.originComponent.getContext().createChildContext()){

            public void handle(Request request, Response response) {
                response.setAge(Integer.valueOf(request.getResourceRef().getQueryAsForm().getFirstValue("item")).intValue());
                if (AsynchroneTestCase.this.responseEntityExpected(request.getMethod())) {
                    String message = "Resource URI:  " + request.getResourceRef() + '\n' + "Base URI:      " + request.getResourceRef().getBaseRef() + '\n' + "Remaining part: " + request.getResourceRef().getRemainingPart() + '\n' + "Method name: " + request.getMethod() + '\n';
                    if (AsynchroneTestCase.this.requestEntityExpected(request.getMethod())) {
                        message = message + request.getEntityAsText();
                        request.getEntity().release();
                    }
                    response.setEntity((Representation)new StringRepresentation((CharSequence)message, MediaType.TEXT_PLAIN));
                    response.setStatus(Status.SUCCESS_OK);
                } else {
                    if (AsynchroneTestCase.this.requestEntityExpected(request.getMethod())) {
                        request.getEntityAsText();
                    }
                    response.setStatus(Status.SUCCESS_NO_CONTENT);
                }
            }
        };
        this.originComponent.getDefaultHost().attach("", trace);
        Server server = this.originComponent.getServers().add(Protocol.HTTP, TEST_PORT);
        server.getContext().getParameters().add("maxQueued", "-1");
        Client client = this.clientComponent.getClients().add(Protocol.HTTP);
        this.context = client.getContext();
        this.context.getParameters().add("maxQueued", "-1");
        this.context.getParameters().add("maxConnectionsPerHost", "6");
        this.originComponent.start();
        this.clientComponent.start();
    }

    public void testGet() throws Exception {
        this.testCall(this.context, 10, Method.GET);
    }

    public void testPost() throws Exception {
        this.testCall(this.context, 10, Method.POST);
    }

    public void testPut() throws Exception {
        this.testCall(this.context, 10, Method.PUT);
    }

    public void testDelete() throws Exception {
        this.testCall(this.context, 10, Method.DELETE);
    }

    @Override
    protected void tearDown() throws Exception {
        this.clientComponent.stop();
        this.originComponent.stop();
        super.tearDown();
    }
}

