/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.atom;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.engine.io.IoUtils;
import org.restlet.ext.atom.Categories;
import org.restlet.ext.atom.Category;
import org.restlet.ext.atom.Collection;
import org.restlet.ext.atom.Entry;
import org.restlet.ext.atom.Feed;
import org.restlet.ext.atom.Person;
import org.restlet.ext.atom.Service;
import org.restlet.ext.atom.Workspace;
import org.restlet.representation.FileRepresentation;
import org.restlet.representation.Representation;
import org.restlet.test.RestletTestCase;

public class AtomTestCase
extends RestletTestCase {
    public void testCategories() throws Exception {
        Categories atomCategories = new Categories("clap://class/org/restlet/test/ext/atom/categories.xml");
        AtomTestCase.assertEquals((Object)new Reference("http://example.com/cats/big3"), (Object)atomCategories.getScheme());
        AtomTestCase.assertEquals((String)"animal", (String)((Category)atomCategories.getEntries().get(0)).getTerm());
    }

    public void testAtom() throws Exception {
        File testDir = new File(System.getProperty("java.io.tmpdir"), "AtomTestCase");
        IoUtils.delete((File)testDir, (boolean)true);
        testDir.mkdir();
        Service atomService = new Service("clap://class/org/restlet/test/ext/atom/service.xml");
        AtomTestCase.assertEquals((String)"AtomPub Test Site", (String)((Workspace)atomService.getWorkspaces().get(0)).getTitle());
        AtomTestCase.assertEquals((String)"entry", (String)((Collection)((Workspace)atomService.getWorkspaces().get(0)).getCollections().get(0)).getTitle());
        Feed atomFeed = ((Collection)((Workspace)atomService.getWorkspaces().get(0)).getCollections().get(0)).getFeed();
        File feedFile = new File(testDir, "feed.xml");
        atomFeed.write((OutputStream)new BufferedOutputStream(new FileOutputStream(feedFile)));
        FileRepresentation fileRepresentation = new FileRepresentation(feedFile, MediaType.TEXT_XML);
        Feed atomFeed2 = new Feed((Representation)fileRepresentation);
        AtomTestCase.assertEquals((String)((Person)atomFeed2.getAuthors().get(0)).getName(), (String)((Person)atomFeed.getAuthors().get(0)).getName());
        AtomTestCase.assertEquals((String)((Entry)atomFeed2.getEntries().get(0)).getContent().getInlineContent().getText(), (String)((Entry)atomFeed2.getEntries().get(0)).getContent().getInlineContent().getText());
        AtomTestCase.assertEquals((String)((Entry)atomFeed2.getEntries().get(0)).getTitle().getContent(), (String)((Entry)atomFeed2.getEntries().get(0)).getTitle().getContent());
        IoUtils.delete((File)testDir, (boolean)true);
    }
}

