/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.crypto;

import org.restlet.Application;
import org.restlet.Component;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.Uniform;
import org.restlet.data.CookieSetting;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Status;
import org.restlet.ext.crypto.CookieAuthenticator;
import org.restlet.resource.ClientResource;
import org.restlet.resource.ResourceException;
import org.restlet.security.MapVerifier;
import org.restlet.security.Verifier;
import org.restlet.test.RestletTestCase;

public class CookieAuthenticatorTestCase
extends RestletTestCase {
    public void testCookieAuth1() {
        CookieGuardedApplication cga = new CookieGuardedApplication();
        Component c = new Component();
        c.getDefaultHost().attachDefault((Restlet)cga);
        ClientResource cr = new ClientResource("http://toto.com/");
        cr.setNext((Uniform)c);
        try {
            cr.get();
            CookieAuthenticatorTestCase.fail((String)"A resource exception should have been thrown");
        }
        catch (ResourceException re) {
            CookieAuthenticatorTestCase.assertEquals((Object)Status.CLIENT_ERROR_UNAUTHORIZED, (Object)re.getStatus());
        }
        ClientResource loginCr = cr.getChild("/login");
        Form loginForm = new Form();
        loginForm.add("login", "scott");
        loginForm.add("password", "titi");
        try {
            loginCr.post((Object)loginForm);
            CookieAuthenticatorTestCase.fail((String)"A resource exception should have been thrown");
        }
        catch (ResourceException re) {
            CookieAuthenticatorTestCase.assertEquals((Object)Status.CLIENT_ERROR_UNAUTHORIZED, (Object)re.getStatus());
        }
        loginForm.set("password", "tiger");
        loginCr.post((Object)loginForm);
        CookieAuthenticatorTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)loginCr.getStatus());
        CookieSetting cs = (CookieSetting)loginCr.getCookieSettings().getFirst("Credentials");
        CookieAuthenticatorTestCase.assertNotNull((String)"No cookie credentials found", (Object)cs);
        cr.getCookies().add(cs.getName(), cs.getValue());
        CookieAuthenticatorTestCase.assertEquals((String)"Hello, world!", (String)((String)cr.get(String.class)));
        ClientResource logoutCr = cr.getChild("/logout");
        logoutCr.get();
        CookieAuthenticatorTestCase.assertEquals((Object)Status.SUCCESS_OK, (Object)logoutCr.getStatus());
        cs = (CookieSetting)logoutCr.getCookieSettings().getFirst("Credentials");
        CookieAuthenticatorTestCase.assertEquals((int)0, (int)cs.getMaxAge());
    }

    public class CookieGuardedApplication
    extends Application {
        public Restlet createInboundRoot() {
            CookieAuthenticator co = new CookieAuthenticator(this.getContext(), false, "My cookie realm", "MyExtraSecretKey".getBytes());
            MapVerifier mapVerifier = new MapVerifier();
            mapVerifier.getLocalSecrets().put("scott", "tiger".toCharArray());
            co.setVerifier((Verifier)mapVerifier);
            Restlet hr = new Restlet(){

                public void handle(Request request, Response response) {
                    response.setEntity("Hello, world!", MediaType.TEXT_PLAIN);
                }
            };
            co.setNext(hr);
            return co;
        }
    }
}

