/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.crypto;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.restlet.Request;
import org.restlet.data.Method;
import org.restlet.data.Reference;
import org.restlet.engine.header.Header;
import org.restlet.ext.crypto.internal.AwsUtils;
import org.restlet.test.RestletTestCase;
import org.restlet.util.Series;

public class HttpAwsS3SigningTestCase
extends RestletTestCase {
    private static final String ACCESS_KEY = "uV3F3YluFJax1cknvbcGwgjvx4QpvB+leU8dUj2o";
    private Request getRequest;
    private Request putRequest;
    private Request uploadRequest;

    @Override
    @Before
    public void setUp() throws Exception {
        this.getRequest = new Request();
        Series headers = new Series(Header.class);
        this.getRequest.getAttributes().put("org.restlet.http.headers", headers);
        headers.add("Date", "Tue, 27 Mar 2007 19:36:42 +0000");
        this.getRequest.setMethod(Method.GET);
        this.getRequest.setResourceRef("http://johnsmith.s3.amazonaws.com/photos/puppy.jpg");
        this.putRequest = new Request();
        headers = new Series(Header.class);
        this.putRequest.getAttributes().put("org.restlet.http.headers", headers);
        headers.add("Content-Length", "94328");
        headers.add("Content-Type", "image/jpeg");
        headers.add("Date", "Tue, 27 Mar 2007 21:15:45 +0000");
        this.putRequest.setMethod(Method.PUT);
        this.putRequest.setResourceRef("http://johnsmith.s3.amazonaws.com/photos/puppy.jpg");
        this.uploadRequest = new Request();
        headers = new Series(Header.class);
        this.uploadRequest.getAttributes().put("org.restlet.http.headers", headers);
        headers.add("Content-Length", "5913339");
        headers.add("Content-MD5", "4gJE4saaMU4BqNR0kLY+lw==");
        headers.add("Content-Type", "application/x-download");
        headers.add("Date", "Tue, 27 Mar 2007 21:06:08 +0000");
        this.uploadRequest.setMethod(Method.PUT);
        this.uploadRequest.setResourceRef("http://static.johnsmith.net:8080/db-backup.dat.gz");
        headers.add("x-amz-acl", "public-read");
        headers.add("X-Amz-Meta-ReviewedBy", "joe@johnsmith.net");
        headers.add("X-Amz-Meta-ReviewedBy", "jane@johnsmith.net");
        headers.add("X-Amz-Meta-FileChecksum", "0x02661779");
        headers.add("X-Amz-Meta-ChecksumAlgorithm", "crc32");
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.getRequest = null;
        this.putRequest = null;
        this.uploadRequest = null;
    }

    @Test
    public void testGetCanonicalizedAmzHeaders() {
        Series headers = (Series)this.getRequest.getAttributes().get("org.restlet.http.headers");
        String expected = "";
        String actual = AwsUtils.getCanonicalizedAmzHeaders((Series)headers);
        Assert.assertEquals((Object)expected, (Object)actual);
        headers = (Series)this.uploadRequest.getAttributes().get("org.restlet.http.headers");
        expected = "x-amz-acl:public-read\nx-amz-meta-checksumalgorithm:crc32\nx-amz-meta-filechecksum:0x02661779\nx-amz-meta-reviewedby:joe@johnsmith.net,jane@johnsmith.net\n";
        actual = AwsUtils.getCanonicalizedAmzHeaders((Series)headers);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testGetCanonicalizedResourceName() {
        String result = AwsUtils.getCanonicalizedResourceName((Reference)this.getRequest.getResourceRef());
        Assert.assertEquals((Object)"/johnsmith/photos/puppy.jpg", (Object)result);
    }

    @Test
    public void testGetSignature() {
        String result = AwsUtils.getS3Signature((Request)this.getRequest, (char[])ACCESS_KEY.toCharArray());
        Assert.assertEquals((Object)"xXjDGYUmKxnwqr5KXNPGldn5LbA=", (Object)result);
        result = AwsUtils.getS3Signature((Request)this.putRequest, (char[])ACCESS_KEY.toCharArray());
        Assert.assertEquals((Object)"hcicpDDvL9SsO6AkvxqmIWkmOuQ=", (Object)result);
        result = AwsUtils.getS3Signature((Request)this.uploadRequest, (char[])ACCESS_KEY.toCharArray());
        Assert.assertEquals((Object)"C0FlOtU8Ylb9KDTpZqYkZPX91iI=", (Object)result);
    }

    @Test
    public void testGetStringToSign() {
        String expected = "GET\n\n\nTue, 27 Mar 2007 19:36:42 +0000\n/johnsmith/photos/puppy.jpg";
        String actual = AwsUtils.getS3StringToSign((Request)this.getRequest);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = "PUT\n\nimage/jpeg\nTue, 27 Mar 2007 21:15:45 +0000\n/johnsmith/photos/puppy.jpg";
        actual = AwsUtils.getS3StringToSign((Request)this.putRequest);
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = "PUT\n4gJE4saaMU4BqNR0kLY+lw==\napplication/x-download\nTue, 27 Mar 2007 21:06:08 +0000\nx-amz-acl:public-read\nx-amz-meta-checksumalgorithm:crc32\nx-amz-meta-filechecksum:0x02661779\nx-amz-meta-reviewedby:joe@johnsmith.net,jane@johnsmith.net\n/static.johnsmith.net/db-backup.dat.gz";
        actual = AwsUtils.getS3StringToSign((Request)this.uploadRequest);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

