/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.crypto;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.restlet.Request;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.data.Method;
import org.restlet.engine.header.Header;
import org.restlet.ext.crypto.internal.AwsUtils;
import org.restlet.ext.crypto.internal.AwsVerifier;
import org.restlet.security.LocalVerifier;
import org.restlet.test.RestletTestCase;
import org.restlet.util.Series;

public class HttpAwsS3VerifierTestCase
extends RestletTestCase {
    private static final String ACCESS_ID = "0PN5J17HBGZHT7JJ3X82";
    private static final String ACCESS_KEY = "uV3F3YluFJax1cknvbcGwgjvx4QpvB+leU8dUj2o";
    private AwsVerifier awsVerifier;
    private LocalVerifier localVerifier;

    private Request createRequest() {
        Request request = new Request();
        Series headers = new Series(Header.class);
        request.getAttributes().put("org.restlet.http.headers", headers);
        request.setMethod(Method.GET);
        request.setResourceRef("http://johnsmith.s3.amazonaws.com/photos/puppy.jpg");
        return request;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.localVerifier = new LocalVerifier(){

            public char[] getLocalSecret(String identifier) {
                if (HttpAwsS3VerifierTestCase.ACCESS_ID.equals(identifier)) {
                    return HttpAwsS3VerifierTestCase.ACCESS_KEY.toCharArray();
                }
                return "password".toCharArray();
            }
        };
        this.awsVerifier = new AwsVerifier(this.localVerifier);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.awsVerifier = null;
        this.localVerifier = null;
    }

    @Test
    public void testVerify() {
        Request request = this.createRequest();
        Series headers = (Series)request.getAttributes().get("org.restlet.http.headers");
        Assert.assertEquals((long)0L, (long)this.awsVerifier.verify(request, null));
        ChallengeResponse cr = new ChallengeResponse(ChallengeScheme.HTTP_AWS_S3);
        request.setChallengeResponse(cr);
        Assert.assertEquals((long)0L, (long)this.awsVerifier.verify(request, null));
        String sig = AwsUtils.getS3Signature((Request)request, (char[])"badpassword".toCharArray());
        cr.setRawValue("0PN5J17HBGZHT7JJ3X82:" + sig);
        Assert.assertEquals((long)-1L, (long)this.awsVerifier.verify(request, null));
        sig = AwsUtils.getS3Signature((Request)request, (char[])ACCESS_KEY.toCharArray());
        cr.setRawValue("0PN5J17HBGZHT7JJ3X82:" + sig);
        Assert.assertEquals((long)4L, (long)this.awsVerifier.verify(request, null));
        headers.removeAll("Date", true);
        Assert.assertEquals((long)-1L, (long)this.awsVerifier.verify(request, null));
        headers.add("Date", "Tue, 27 Mar 1999 19:36:42 +0000");
        Assert.assertEquals((long)1L, (long)this.awsVerifier.verify(request, null));
    }
}

