/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.gson;

import com.google.gson.annotations.Since;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.restlet.data.MediaType;
import org.restlet.ext.gson.GsonConverter;
import org.restlet.ext.gson.GsonRepresentation;
import org.restlet.representation.EmptyRepresentation;
import org.restlet.representation.ReaderRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.Variant;

public class GsonTestCase {
    private GsonConverter c;
    private User user;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
        this.user = new User("hello", "secret", 1, true, new Date(), new Date());
        this.c = new GsonConverter();
    }

    @Test
    public final void testCreateMediaTypeT() {
        GsonRepresentation rep = new GsonRepresentation((Object)this.user);
        Assert.assertNotNull((Object)rep);
        Assert.assertEquals((Object)rep.getMediaType(), (Object)MediaType.APPLICATION_JSON);
    }

    @Test
    public final void testCreateRepresentationClassOfT() {
        GsonRepresentation rep = new GsonRepresentation((Object)this.user);
        GsonRepresentation rep1 = new GsonRepresentation((Representation)rep, User.class);
        Assert.assertEquals((Object)rep1.getMediaType(), (Object)rep1.getMediaType());
        Assert.assertEquals(rep1.getClass(), rep1.getClass());
    }

    @Test
    public final void testGsonRepresentationRead() throws IOException {
        StringReader reader = new StringReader("{\"loginId\":\"hello\",\"password\":\"secret\",\"rate\":1,\"active\":true,\"createAt\":\"2012-05-20T15:41:01.489+08:00\",\"lastLogin\":\"2012-05-20T15:41:01.489+08:00\"}");
        ReaderRepresentation source = new ReaderRepresentation((Reader)reader);
        source.setMediaType(MediaType.APPLICATION_JSON);
        GsonRepresentation gsonRep = new GsonRepresentation((Representation)source, User.class);
        User u = (User)gsonRep.getObject();
        Assert.assertNotNull((Object)u);
        Assert.assertEquals((Object)"hello", (Object)u.getLoginId());
        Assert.assertEquals((Object)"secret", (Object)u.getPassword());
        Assert.assertEquals((long)1L, (long)u.getRate());
        Assert.assertTrue((boolean)u.isActive());
        DateTime time = new DateTime((Object)"2012-05-20T15:41:01.489+08:00");
        Assert.assertEquals((long)time.getMillis(), (long)u.getCreateAt().getTime());
        StringReader reader1 = new StringReader("{\"loginId\":\"hello\",\"password\":\"secret\",\"rate\":1,\"active\":true,\"createAt\":\"2012-05-20T15:41:01.489+08:00\",\"lastLogin\":\"2012-05-20T15:41:01.489+08:00\"}");
        ReaderRepresentation source1 = new ReaderRepresentation((Reader)reader1);
        GsonRepresentation gsonRep1 = new GsonRepresentation((Representation)source1, User.class);
        gsonRep1.getBuilder().setVersion(1.0);
        User u1 = (User)gsonRep1.getObject();
        Assert.assertNull((Object)u1.getLastLogin());
    }

    @Test
    public final void testGsonRepresentationWrite() throws IOException {
        GsonRepresentation source = new GsonRepresentation((Object)this.user);
        Assert.assertEquals(User.class, (Object)source.getObjectClass());
        Assert.assertEquals((Object)this.user, (Object)source.getObject());
        source.write((OutputStream)System.out);
        System.out.println();
        source.getBuilder().setVersion(1.0);
        source.write((OutputStream)System.out);
        System.out.println();
        String text = "What's going on?";
        GsonRepresentation source1 = new GsonRepresentation((Object)text);
        Assert.assertEquals(String.class, (Object)source1.getObjectClass());
        Assert.assertEquals((Object)text, (Object)source1.getObject());
        source1.write((OutputStream)System.out);
        System.out.println();
    }

    @Test
    public final void testScoreObjectVariantResource() {
        Variant v = new Variant(MediaType.APPLICATION_JSON);
        GsonRepresentation source = new GsonRepresentation((Object)this.user);
        float score = this.c.score((Object)this.user, v, null);
        Assert.assertTrue((score == 0.8f ? 1 : 0) != 0);
        float score1 = this.c.score((Object)source, v, null);
        Assert.assertTrue((score1 == 1.0f ? 1 : 0) != 0);
    }

    @Test
    public final void testScoreRepresentationClassOfTResource() {
        GsonRepresentation source = new GsonRepresentation((Object)this.user);
        float score = this.c.score((Representation)source, User.class, null);
        Assert.assertTrue((score == 1.0f ? 1 : 0) != 0);
        EmptyRepresentation source1 = new EmptyRepresentation();
        float score1 = this.c.score((Representation)source1, User.class, null);
        Assert.assertTrue((score1 == 0.8f ? 1 : 0) != 0);
    }

    @Test
    public final void testToObjectRepresentationClassOfTResource() throws IOException {
        GsonRepresentation source = new GsonRepresentation((Object)this.user);
        User u = (User)this.c.toObject((Representation)source, User.class, null);
        Assert.assertNotNull((Object)u);
        Assert.assertEquals((Object)this.user, (Object)u);
        GsonRepresentation source1 = new GsonRepresentation((Object)this.user);
        User u1 = (User)this.c.toObject((Representation)source1, User.class, null);
        Assert.assertNotNull((Object)u1);
        Assert.assertEquals((Object)this.user, (Object)u1);
        GsonRepresentation source2 = new GsonRepresentation(null);
        User u2 = (User)this.c.toObject((Representation)source2, User.class, null);
        Assert.assertNull((Object)u2);
    }

    @Test
    public final void testToRepresentationObjectVariantResource() throws IOException {
        Variant v = new Variant(MediaType.APPLICATION_JSON);
        Representation rep = this.c.toRepresentation((Object)this.user, v, null);
        Assert.assertNotNull((Object)rep);
        Assert.assertEquals((Object)rep.getMediaType(), (Object)MediaType.APPLICATION_JSON);
        Variant v1 = new Variant(MediaType.APPLICATION_XML);
        Representation rep1 = this.c.toRepresentation((Object)this.user, v1, null);
        Assert.assertNull((Object)rep1);
    }

    private class User {
        private boolean active;
        private Date createAt;
        @Since(value=2.0)
        private Date lastLogin;
        private String loginId;
        private String password;
        private int rate;

        public User(String loginId, String password, int rate, boolean active, Date createAt, Date lastLogin) {
            this.loginId = loginId;
            this.password = password;
            this.rate = rate;
            this.active = active;
            this.createAt = createAt;
            this.lastLogin = lastLogin;
        }

        public Date getCreateAt() {
            return this.createAt;
        }

        public Date getLastLogin() {
            return this.lastLogin;
        }

        public String getLoginId() {
            return this.loginId;
        }

        public String getPassword() {
            return this.password;
        }

        public int getRate() {
            return this.rate;
        }

        public boolean isActive() {
            return this.active;
        }
    }
}

