/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Module;
import com.google.inject.Provides;
import javax.inject.Inject;
import javax.inject.Named;
import org.restlet.Application;
import org.restlet.Client;
import org.restlet.Component;
import org.restlet.Restlet;
import org.restlet.data.MediaType;
import org.restlet.data.Metadata;
import org.restlet.data.Protocol;
import org.restlet.ext.guice.SelfInjectingServerResource;
import org.restlet.ext.guice.SelfInjectingServerResourceModule;
import org.restlet.resource.ClientResource;
import org.restlet.resource.Get;
import org.restlet.routing.Router;
import org.restlet.test.RestletTestCase;

public class GuiceSelfInjectingServerResourceModuleTestCase
extends RestletTestCase {
    static final String HELLO_KEY = "hello.message";
    static final String HELLO_MSG = "This resource was injected by Guice!";
    private volatile Client client;
    private volatile Component component;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Guice.createInjector((Module[])new Module[]{new TestModule(), new SelfInjectingServerResourceModule()});
        this.client = new Client(Protocol.HTTP);
        if (this.component == null) {
            this.component = new Component();
            this.component.getServers().add(Protocol.HTTP, TEST_PORT);
            this.component.getDefaultHost().attachDefault((Restlet)new TestApplication());
        }
        if (!this.component.isStarted()) {
            this.component.start();
        }
    }

    @Override
    public void tearDown() throws Exception {
        this.client.stop();
        this.component.stop();
        this.component = null;
        super.tearDown();
    }

    public void testReturnsMessage() {
        ClientResource client = new ClientResource("http://localhost:" + TEST_PORT);
        client.accept(new Metadata[]{MediaType.TEXT_PLAIN});
        String msg = ((HelloResource)client.getChild("/hello", HelloResource.class)).getMessage();
        GuiceSelfInjectingServerResourceModuleTestCase.assertEquals((String)HELLO_MSG, (String)msg);
    }

    static class TestModule
    extends AbstractModule {
        TestModule() {
        }

        protected void configure() {
        }

        @Provides
        @Named(value="hello.message")
        String helloMessage() {
            return GuiceSelfInjectingServerResourceModuleTestCase.HELLO_MSG;
        }
    }

    private static class TestApplication
    extends Application {
        private TestApplication() {
        }

        public Restlet createInboundRoot() {
            Router router = new Router(this.getContext());
            router.attach("/hello", HelloServerResource.class);
            return router;
        }
    }

    public static class HelloServerResource
    extends SelfInjectingServerResource
    implements HelloResource {
        @Inject
        @Named(value="hello.message")
        private String msg;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doInit() {
            System.out.println("before doInit: msg=" + this.msg);
            try {
                super.doInit();
            }
            finally {
                System.out.println("after doInit: msg=" + this.msg);
            }
        }

        @Override
        public String getMessage() {
            return this.msg;
        }
    }

    public static interface HelloResource {
        @Get
        public String getMessage();
    }
}

