/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.html;

import java.io.IOException;
import java.util.Collection;
import org.restlet.data.CharacterSet;
import org.restlet.data.MediaType;
import org.restlet.ext.html.FormDataSet;
import org.restlet.ext.html.internal.FormReader;
import org.restlet.test.RestletTestCase;
import org.restlet.util.Series;

public class FormTestCase
extends RestletTestCase {
    public void testParsing() throws IOException {
        FormDataSet form = new FormDataSet();
        form.add("name", "John D. Mitchell");
        form.add("email", "john@bob.net");
        form.add("email2", "joe@bob.net");
        String query = form.encode();
        Series newFormData = new FormReader(query, CharacterSet.UTF_8, '&').read();
        FormDataSet newForm = new FormDataSet();
        newForm.getEntries().addAll((Collection)newFormData);
        String newQuery = newForm.encode();
        FormTestCase.assertEquals((String)query, (String)newQuery);
    }

    public void testContentType() throws IOException {
        FormDataSet form = null;
        form = new FormDataSet();
        form.setMultipart(true);
        FormTestCase.assertTrue((boolean)form.getMediaType().equals((Object)MediaType.MULTIPART_FORM_DATA, true));
        form = new FormDataSet("test");
        FormTestCase.assertTrue((boolean)form.isMultipart());
        FormTestCase.assertTrue((boolean)form.getMediaType().equals((Object)MediaType.MULTIPART_FORM_DATA, true));
        FormTestCase.assertEquals((String)form.getMediaType().getParameters().getFirstValue("boundary"), (String)"test");
        form = new FormDataSet();
        form.setMultipartBoundary("test2");
        FormTestCase.assertTrue((boolean)form.isMultipart());
        FormTestCase.assertTrue((boolean)form.getMediaType().equals((Object)MediaType.MULTIPART_FORM_DATA, true));
        FormTestCase.assertEquals((String)form.getMediaType().getParameters().getFirstValue("boundary"), (String)"test2");
    }
}

