/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jackson;

import java.io.IOException;
import java.util.Date;
import org.restlet.data.MediaType;
import org.restlet.ext.jackson.JacksonRepresentation;
import org.restlet.representation.Representation;
import org.restlet.representation.StringRepresentation;
import org.restlet.resource.ClientResource;
import org.restlet.test.RestletTestCase;
import org.restlet.test.ext.jackson.Customer;
import org.restlet.test.ext.jackson.Invoice;

public class JacksonTestCase
extends RestletTestCase {
    protected Customer createCustomer() {
        Date date = new Date(1356533333882L);
        Customer result = new Customer();
        result.setFirstName("Foo");
        result.setLastName("Bar");
        Invoice invoice = new Invoice();
        invoice.setAmount(12456);
        invoice.setDate(date);
        invoice.setPaid(false);
        result.getInvoices().add(invoice);
        invoice = new Invoice();
        invoice.setAmount(7890);
        invoice.setDate(date);
        invoice.setPaid(true);
        result.getInvoices().add(invoice);
        return result;
    }

    protected Invoice createInvoice() {
        Date date = new Date(1356533333882L);
        Invoice invoice = new Invoice();
        invoice.setAmount(12456);
        invoice.setDate(date);
        invoice.setPaid(false);
        return invoice;
    }

    public void testCsv() throws Exception {
        Invoice invoice = this.createInvoice();
        JacksonRepresentation rep = new JacksonRepresentation(MediaType.TEXT_CSV, (Object)invoice);
        String text = rep.getText();
        JacksonTestCase.assertEquals((String)"1356533333882,12456,false\n", (String)text);
        rep = new JacksonRepresentation((Representation)new StringRepresentation((CharSequence)text, rep.getMediaType()), Invoice.class);
        this.verify(invoice, (Invoice)rep.getObject());
    }

    public void testJson() throws Exception {
        Customer customer = this.createCustomer();
        JacksonRepresentation rep = new JacksonRepresentation(MediaType.APPLICATION_JSON, (Object)customer);
        String text = rep.getText();
        JacksonTestCase.assertEquals((String)"{\"firstName\":\"Foo\",\"lastName\":\"Bar\",\"invoices\":[{\"date\":1356533333882,\"amount\":12456,\"paid\":false},{\"date\":1356533333882,\"amount\":7890,\"paid\":true}]}", (String)text);
        rep = new JacksonRepresentation((Representation)new StringRepresentation((CharSequence)text, rep.getMediaType()), Customer.class);
        this.verify(customer, (Customer)rep.getObject());
    }

    public void testSmile() throws Exception {
        Customer customer = this.createCustomer();
        JacksonRepresentation rep = new JacksonRepresentation(MediaType.APPLICATION_JSON_SMILE, (Object)customer);
        rep = new JacksonRepresentation((Representation)rep, Customer.class);
        this.verify(customer, (Customer)rep.getObject());
    }

    public void testXml() throws Exception {
        Customer customer = this.createCustomer();
        JacksonRepresentation rep = new JacksonRepresentation(MediaType.APPLICATION_XML, (Object)customer);
        String text = rep.getText();
        JacksonTestCase.assertEquals((String)"<Customer><firstName>Foo</firstName><lastName>Bar</lastName><invoices><invoices><date>1356533333882</date><amount>12456</amount><paid>false</paid></invoices><invoices><date>1356533333882</date><amount>7890</amount><paid>true</paid></invoices></invoices></Customer>", (String)text);
        rep = new JacksonRepresentation((Representation)new StringRepresentation((CharSequence)text, rep.getMediaType()), Customer.class);
        this.verify(customer, (Customer)rep.getObject());
    }

    public void testXmlBomb() throws IOException {
        ClientResource cr = new ClientResource("clap://class/org/restlet/test/ext/jackson/jacksonBomb.xml");
        Representation xmlRep = cr.get();
        xmlRep.setMediaType(MediaType.APPLICATION_XML);
        boolean error = false;
        try {
            new JacksonRepresentation(xmlRep, Customer.class).getObject();
        }
        catch (Exception e) {
            error = true;
        }
        JacksonTestCase.assertTrue((boolean)error);
    }

    public void testYaml() throws Exception {
        Customer customer = this.createCustomer();
        JacksonRepresentation rep = new JacksonRepresentation(MediaType.APPLICATION_YAML, (Object)customer);
        String text = rep.getText();
        JacksonTestCase.assertEquals((String)"---\nfirstName: \"Foo\"\nlastName: \"Bar\"\ninvoices:\n- date: 1356533333882\n  amount: 12456\n  paid: false\n- date: 1356533333882\n  amount: 7890\n  paid: true\n", (String)text);
        rep = new JacksonRepresentation((Representation)new StringRepresentation((CharSequence)text, rep.getMediaType()), Customer.class);
        this.verify(customer, (Customer)rep.getObject());
    }

    protected void verify(Customer customer1, Customer customer2) {
        JacksonTestCase.assertEquals((String)customer1.getFirstName(), (String)customer2.getFirstName());
        JacksonTestCase.assertEquals((String)customer1.getLastName(), (String)customer2.getLastName());
        JacksonTestCase.assertEquals((int)customer1.getInvoices().size(), (int)customer2.getInvoices().size());
        JacksonTestCase.assertEquals((Object)customer1.getInvoices().get(0).getAmount(), (Object)customer2.getInvoices().get(0).getAmount());
        JacksonTestCase.assertEquals((Object)customer1.getInvoices().get(1).getAmount(), (Object)customer2.getInvoices().get(1).getAmount());
        JacksonTestCase.assertEquals((Object)customer1.getInvoices().get(0).getDate(), (Object)customer2.getInvoices().get(0).getDate());
        JacksonTestCase.assertEquals((Object)customer1.getInvoices().get(1).getDate(), (Object)customer2.getInvoices().get(1).getDate());
    }

    protected void verify(Invoice invoice1, Invoice invoice2) {
        JacksonTestCase.assertEquals((Object)invoice1.getAmount(), (Object)invoice2.getAmount());
        JacksonTestCase.assertEquals((Object)invoice1.getDate(), (Object)invoice2.getDate());
    }
}

