/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import junit.framework.TestCase;
import org.restlet.engine.Engine;
import org.restlet.ext.jaxrs.internal.core.MultivaluedMapImpl;
import org.restlet.ext.jaxrs.internal.exceptions.JaxRsRuntimeException;
import org.restlet.ext.jaxrs.internal.wrappers.provider.JaxRsProviders;
import org.restlet.test.ext.jaxrs.services.providers.IllegalArgExcMapper;

public class ExceptionMappersTest
extends TestCase {
    private static final int INTERNAL_SERVER_ERROR = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
    private JaxRsProviders exceptionMappers;

    private Response convert(Throwable exc) {
        return this.exceptionMappers.convert(exc);
    }

    protected void setUp() throws Exception {
        super.setUp();
        IllegalArgExcMapper illegalArgExcMapper = new IllegalArgExcMapper();
        illegalArgExcMapper.httpHeaders = new TestHttpHeaders();
        this.exceptionMappers = new JaxRsProviders(null, null, null, Engine.getAnonymousLogger());
        this.exceptionMappers.addSingleton((Object)illegalArgExcMapper, false);
    }

    protected void tearDown() throws Exception {
        this.exceptionMappers = null;
        super.tearDown();
    }

    public void testIae() throws Exception {
        Response r = this.convert(new IllegalArgumentException());
        ExceptionMappersTest.assertNotNull((Object)r);
        ExceptionMappersTest.assertEquals((int)599, (int)r.getStatus());
    }

    public void testIoe() throws Exception {
        IOException ioException = new IOException("This exception is planned for testing !");
        try {
            Response r = this.convert(ioException);
            ExceptionMappersTest.assertEquals((int)500, (int)r.getStatus());
        }
        catch (JaxRsRuntimeException e) {
            ExceptionMappersTest.assertEquals((Object)ioException, (Object)e.getCause());
        }
    }

    public void testNfe() throws Exception {
        Response r = this.convert(new NumberFormatException());
        ExceptionMappersTest.assertNotNull((Object)r);
        ExceptionMappersTest.assertEquals((int)599, (int)r.getStatus());
    }

    private static final class TestHttpHeaders
    implements HttpHeaders {
        private final List<MediaType> accMediaTypes = new ArrayList<MediaType>();

        private TestHttpHeaders() {
        }

        public List<Locale> getAcceptableLanguages() {
            return new ArrayList<Locale>();
        }

        public List<MediaType> getAcceptableMediaTypes() {
            return this.accMediaTypes;
        }

        public Map<String, Cookie> getCookies() {
            return Collections.emptyMap();
        }

        public Locale getLanguage() {
            return null;
        }

        public MediaType getMediaType() {
            return null;
        }

        public List<String> getRequestHeader(String name) {
            return Collections.emptyList();
        }

        public MultivaluedMap<String, String> getRequestHeaders() {
            return new MultivaluedMapImpl();
        }
    }
}

