/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.client;

import java.awt.Point;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.core.Application;
import junit.framework.TestCase;
import org.restlet.engine.Engine;
import org.restlet.engine.converter.ConverterHelper;
import org.restlet.ext.jaxrs.JaxRsClientResource;
import org.restlet.ext.xstream.XstreamConverter;
import org.restlet.test.ext.jaxrs.services.echo.EchoResource;
import org.restlet.test.ext.jaxrs.services.echo.EchoResourceImpl;
import org.restlet.test.ext.jaxrs.services.tests.JaxRsTestCase;

public class JaxRsClientTest
extends JaxRsTestCase {
    private AtomicBoolean _serverStarted = new AtomicBoolean(false);
    private Object lock = new Object();

    @Override
    protected Application getApplication() {
        return new Application(){

            public Set<Class<?>> getClasses() {
                return Collections.singleton(EchoResourceImpl.class);
            }
        };
    }

    public void testEchoString() throws Exception {
        this.performEchoTest(new EchoTest(){

            @Override
            public void performTest(EchoResource echoResource) {
                TestCase.assertEquals((String)"this is a test", (String)echoResource.echo("this is a test"));
            }
        });
    }

    public void testEchoPointHeaderParam() throws Exception {
        this.performEchoTest(new EchoTest(){

            @Override
            public void performTest(EchoResource echoResource) {
                TestCase.assertEquals((int)1, (int)echoResource.echoPointHeaderParam((Point)new Point((int)1, (int)2)).x);
            }
        });
    }

    public void testEchoPointQueryParam() throws Exception {
        this.performEchoTest(new EchoTest(){

            @Override
            public void performTest(EchoResource echoResource) {
                TestCase.assertEquals((int)3, (int)echoResource.echoPointQueryParam((Point)new Point((int)3, (int)4)).x);
            }
        });
    }

    public void testEchoPointPathParam() throws Exception {
        this.performEchoTest(new EchoTest(){

            @Override
            public void performTest(EchoResource echoResource) {
                TestCase.assertEquals((int)5, (int)echoResource.echoPointPathParam((Point)new Point((int)5, (int)6)).x);
            }
        });
    }

    public void testEchoPointCookieParam() throws Exception {
        this.performEchoTest(new EchoTest(){

            @Override
            public void performTest(EchoResource echoResource) {
                TestCase.assertEquals((int)7, (int)echoResource.echoPointCookieParam((Point)new Point((int)7, (int)8)).x);
            }
        });
    }

    private JaxRsClientTest startSocketServerDaemon() throws InterruptedException {
        List registeredConverters = Engine.getInstance().getRegisteredConverters();
        for (int i = registeredConverters.size() - 1; i >= 0; --i) {
            ConverterHelper converterHelper = (ConverterHelper)registeredConverters.get(i);
            if (converterHelper instanceof XstreamConverter) continue;
            registeredConverters.remove(i);
        }
        final JaxRsClientTest clientTest = new JaxRsClientTest();
        JaxRsClientTest.setUseTcp(true);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    clientTest.startServer(clientTest.createApplication());
                    JaxRsClientTest.this._serverStarted.set(true);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
        t.setDaemon(true);
        t.start();
        return clientTest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performEchoTest(EchoTest echoTest) throws Exception {
        JaxRsClientTest clientTest = this.startSocketServerDaemon();
        while (!this._serverStarted.get()) {
            Thread.sleep(100L);
            System.out.println("waiting for the server to start...");
        }
        EchoResource echoResource = (EchoResource)JaxRsClientResource.createJaxRsClient((String)("http://localhost:" + clientTest.getServerPort()), EchoResource.class);
        echoTest.performTest(echoResource);
        Object object = this.lock;
        synchronized (object) {
            clientTest.stopServer();
            this._serverStarted.set(false);
        }
    }

    private static interface EchoTest {
        public void performTest(EchoResource var1);
    }
}

