/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.core;

import java.net.URI;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import junit.framework.TestCase;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Reference;
import org.restlet.ext.jaxrs.internal.core.CallContext;
import org.restlet.ext.jaxrs.internal.core.ThreadLocalizedContext;
import org.restlet.ext.jaxrs.internal.core.ThreadLocalizedUriInfo;
import org.restlet.ext.jaxrs.internal.todo.NotYetImplementedException;
import org.restlet.test.ext.jaxrs.core.UriBuilderImplTest;

public class UriInfoTest
extends TestCase {
    private static final String BASE_REF_STR = "http://localhost/test/";
    private static final Reference BASE_REF = new Reference("http://localhost/test/");
    private static final String RELATIV_1 = "relativ/a/b";
    private static final String RELATIV_2 = "relativ/%20a%20/%21b%40%2C";
    private static final String RELATIV_2_DECODED = "relativ/ a /!b@,";
    private static final Reference REFERENCE_1 = new Reference(BASE_REF, "http://localhost/test/relativ/a/b");
    private static final Reference REFERENCE_2 = new Reference(BASE_REF, "http://localhost/test/relativ/%20a%20/%21b%40%2C");

    protected static void assertUnmodifiable(MultivaluedMap<String, String> multivaluedMap) {
        try {
            multivaluedMap.add((Object)"jh,", (Object)"hkj");
        }
        catch (NotYetImplementedException usoe) {
            throw usoe;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private static final UriInfo createUriInfo1() {
        return UriInfoTest.newUriInfo(REFERENCE_1, BASE_REF);
    }

    private static final UriInfo createUriInfo2() {
        return UriInfoTest.newUriInfo(REFERENCE_2, BASE_REF);
    }

    private static final ThreadLocalizedUriInfo createUriInfo5() {
        return UriInfoTest.newUriInfo(new Reference(BASE_REF, "http://localhost/test/hfk;abc=%20def;ghi=jkl"), BASE_REF);
    }

    private static final ThreadLocalizedUriInfo createUriInfo7() {
        return UriInfoTest.newUriInfo(new Reference(BASE_REF, "http://localhost/test/abc?def=123&ghi=456"), BASE_REF);
    }

    private static final ThreadLocalizedUriInfo createUriInfo8() {
        return UriInfoTest.newUriInfo(new Reference(BASE_REF, "http://localhost/test/abc?def=1+23&gh%20i=45%206"), BASE_REF);
    }

    static ThreadLocalizedUriInfo newUriInfo(Reference resourceRef, Reference rootRef) {
        Request request = new Request();
        request.setResourceRef(resourceRef);
        request.setOriginalRef(resourceRef);
        request.setRootRef(rootRef);
        Response response = new Response(request);
        Response.setCurrent((Response)response);
        CallContext callContext = new CallContext(request, response);
        ThreadLocalizedContext tlContext = new ThreadLocalizedContext();
        tlContext.set(callContext);
        return new ThreadLocalizedUriInfo(tlContext);
    }

    private void checkEntry(String expectedValue, String key, MultivaluedMap<String, String> templateParameters) {
        UriInfoTest.assertEquals((String)expectedValue, (String)((String)templateParameters.getFirst((Object)key)));
    }

    private void checkPathSegments(List<PathSegment> pathSegments, String path0, int tpSize0, String path1, int tpSize1, String path2, int tpSize2) {
        UriInfoTest.assertEquals((int)3, (int)pathSegments.size());
        PathSegment pathSegment0 = pathSegments.get(0);
        PathSegment pathSegment1 = pathSegments.get(1);
        PathSegment pathSegment2 = pathSegments.get(2);
        UriInfoTest.assertEquals((String)path0, (String)pathSegment0.getPath());
        UriInfoTest.assertEquals((int)tpSize0, (int)pathSegment0.getMatrixParameters().size());
        UriInfoTest.assertEquals((String)path1, (String)pathSegment1.getPath());
        UriInfoTest.assertEquals((int)tpSize1, (int)pathSegment1.getMatrixParameters().size());
        UriInfoTest.assertEquals((String)path2, (String)pathSegment2.getPath());
        UriInfoTest.assertEquals((int)tpSize2, (int)pathSegment2.getMatrixParameters().size());
    }

    public void testGetAbsolutePath() throws Exception {
        UriBuilderImplTest.assertEqualsURI("http://localhost/test/relativ/a/b", UriInfoTest.createUriInfo1().getAbsolutePath());
        UriBuilderImplTest.assertEqualsURI("http://localhost/test/relativ/%20a%20/%21b%40%2C", UriInfoTest.createUriInfo2().getAbsolutePath());
    }

    public void testGetAbsolutePathBuilder() throws Exception {
        UriBuilderImplTest.assertEqualsURI("http://localhost/test/relativ/a/b", UriInfoTest.createUriInfo1().getAbsolutePathBuilder());
    }

    public void testGetBaseUri() {
        URI baseUri1 = UriInfoTest.createUriInfo1().getBaseUri();
        UriInfoTest.assertEquals((String)BASE_REF_STR, (String)baseUri1.toString());
    }

    public void testGetBaseUriBuilder() throws Exception {
        URI uri = UriInfoTest.createUriInfo1().getBaseUri();
        UriBuilderImplTest.assertEqualsURI(BASE_REF_STR, uri);
    }

    public void testGetPath() {
        UriInfoTest.assertEquals((String)RELATIV_1, (String)UriInfoTest.createUriInfo1().getPath());
        UriInfoTest.assertEquals((String)RELATIV_2_DECODED, (String)UriInfoTest.createUriInfo2().getPath());
    }

    public void testGetPathBoolean() {
        UriInfoTest.assertEquals((String)RELATIV_1, (String)UriInfoTest.createUriInfo1().getPath(true));
        UriInfoTest.assertEquals((String)RELATIV_1, (String)UriInfoTest.createUriInfo1().getPath(false));
        UriInfoTest.assertEquals((String)RELATIV_2_DECODED, (String)UriInfoTest.createUriInfo2().getPath(true));
        UriInfoTest.assertEquals((String)RELATIV_2, (String)UriInfoTest.createUriInfo2().getPath(false));
    }

    public void testGetPathSegments() {
        UriInfoTest.assertEquals((Object)UriInfoTest.createUriInfo1().getPathSegments(true), (Object)UriInfoTest.createUriInfo1().getPathSegments());
        UriInfoTest.assertEquals((Object)UriInfoTest.createUriInfo2().getPathSegments(true), (Object)UriInfoTest.createUriInfo2().getPathSegments());
    }

    public void testGetPathSegmentsBoolean() {
        this.checkPathSegments(UriInfoTest.createUriInfo1().getPathSegments(true), "relativ", 0, "a", 0, "b", 0);
        this.checkPathSegments(UriInfoTest.createUriInfo1().getPathSegments(false), "relativ", 0, "a", 0, "b", 0);
        this.checkPathSegments(UriInfoTest.createUriInfo2().getPathSegments(true), "relativ", 0, " a ", 0, "!b@,", 0);
        this.checkPathSegments(UriInfoTest.createUriInfo2().getPathSegments(false), "relativ", 0, "%20a%20", 0, "%21b%40%2C", 0);
        ThreadLocalizedUriInfo uriInfo = UriInfoTest.newUriInfo(new Reference(BASE_REF, "http://localhost/test/abc/def;ghi=jkl;mno=pqr/stu;vwx=yz"), BASE_REF);
        List pathSegments = uriInfo.getPathSegments();
        this.checkPathSegments(pathSegments, "abc", 0, "def", 2, "stu", 1);
        MultivaluedMap templateParameters1 = ((PathSegment)pathSegments.get(1)).getMatrixParameters();
        UriInfoTest.assertEquals((int)2, (int)templateParameters1.size());
        this.checkEntry("jkl", "ghi", (MultivaluedMap<String, String>)templateParameters1);
        this.checkEntry("pqr", "mno", (MultivaluedMap<String, String>)templateParameters1);
        MultivaluedMap templateParameters2 = ((PathSegment)pathSegments.get(2)).getMatrixParameters();
        UriInfoTest.assertEquals((int)1, (int)templateParameters2.size());
        this.checkEntry("yz", "vwx", (MultivaluedMap<String, String>)templateParameters2);
    }

    public void testGetQueryParametersDecoded() {
        UriInfoTest.assertEquals((String)"123", (String)((String)UriInfoTest.createUriInfo7().getQueryParameters(true).getFirst((Object)"def")));
        UriInfoTest.assertEquals((String)"456", (String)((String)UriInfoTest.createUriInfo7().getQueryParameters(true).getFirst((Object)"ghi")));
        UriInfoTest.assertEquals((int)2, (int)UriInfoTest.createUriInfo7().getQueryParameters(true).size());
        UriInfoTest.assertEquals((String)"1 23", (String)((String)UriInfoTest.createUriInfo8().getQueryParameters(true).getFirst((Object)"def")));
        UriInfoTest.assertEquals((String)"45 6", (String)((String)UriInfoTest.createUriInfo8().getQueryParameters(true).getFirst((Object)"gh i")));
        UriInfoTest.assertEquals((int)2, (int)UriInfoTest.createUriInfo8().getQueryParameters(true).size());
    }

    public void testGetQueryParametersEncoded() {
        UriInfoTest.assertEquals((String)"123", (String)((String)UriInfoTest.createUriInfo7().getQueryParameters(false).getFirst((Object)"def")));
        UriInfoTest.assertEquals((String)"456", (String)((String)UriInfoTest.createUriInfo7().getQueryParameters(false).getFirst((Object)"ghi")));
        UriInfoTest.assertEquals((int)2, (int)UriInfoTest.createUriInfo7().getQueryParameters(false).size());
        UriInfoTest.assertEquals((String)"1+23", (String)((String)UriInfoTest.createUriInfo8().getQueryParameters(false).getFirst((Object)"def")));
        UriInfoTest.assertEquals((String)"45%206", (String)((String)UriInfoTest.createUriInfo8().getQueryParameters(false).getFirst((Object)"gh%20i")));
        UriInfoTest.assertEquals((int)2, (int)UriInfoTest.createUriInfo8().getQueryParameters(false).size());
    }

    public void testGetQueryParametersUnmodifiable() {
        UriInfoTest.assertUnmodifiable((MultivaluedMap<String, String>)UriInfoTest.createUriInfo5().getQueryParameters(true));
        UriInfoTest.assertUnmodifiable((MultivaluedMap<String, String>)UriInfoTest.createUriInfo5().getQueryParameters(false));
    }

    public void testGetRequestUri() throws Exception {
        URI uri1 = UriInfoTest.createUriInfo1().getRequestUri();
        UriInfoTest.assertEquals((Object)new URI("http://localhost/test/relativ/a/b"), (Object)uri1);
    }

    public void testGetRequestUriBuilder() throws Exception {
        UriBuilder uriBuilder1 = UriInfoTest.createUriInfo1().getRequestUriBuilder();
        UriBuilderImplTest.assertEqualsURI("http://localhost/test/relativ/a/b", uriBuilder1);
    }
}

