/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.services.providers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.restlet.test.ext.jaxrs.services.others.Person;
import org.restlet.test.ext.jaxrs.services.providers.BaseUriContext;

@Produces(value={"text/html"})
@Provider
public class ContextResolverTestWriter
implements MessageBodyWriter<Person> {
    private ContextResolver<BaseUriContext> contextResolver;

    @Context
    void setProviders(Providers providers) {
        this.contextResolver = providers.getContextResolver(BaseUriContext.class, MediaType.TEXT_HTML_TYPE);
        if (this.contextResolver == null) {
            throw new RuntimeException("No Context Resolver found");
        }
    }

    public long getSize(Person t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.contextResolver.getContext(type) != null;
    }

    public void writeTo(Person person, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        BaseUriContext context = (BaseUriContext)this.contextResolver.getContext(type);
        OutputStreamWriter writer = new OutputStreamWriter(entityStream);
        writer.write("<html><head></head><body>\n");
        writer.write("The virtual presence of <b>");
        writer.write(person.getFirstname() + " " + person.getLastname());
        writer.write("</b> is: ");
        writer.write("<a href=\"");
        writer.write(context.getBaseUri());
        writer.write("persons/");
        writer.write(person.getLastname() + "/" + person.getFirstname());
        writer.write("\">");
        writer.write(context.getBaseUri());
        writer.write("persons/");
        writer.write(person.getLastname() + "/" + person.getFirstname());
        writer.write("</a>");
        writer.write("</html>");
        writer.flush();
    }
}

