/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.services.resources;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.TreeSet;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;

@Path(value="formTest")
public class FormTestResource {
    @Path(value="formOnly")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    public Object formOnly(final MultivaluedMap<String, String> form) {
        return new StreamingOutput(){

            public void write(OutputStream out) throws IOException {
                for (String key : new TreeSet(form.keySet())) {
                    for (String value : (List)form.get((Object)key)) {
                        out.write(key.getBytes());
                        out.write(" -> ".getBytes());
                        out.write(value.getBytes());
                        out.write(10);
                    }
                }
            }
        };
    }

    @Path(value="paramOnly")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    public Object paramOnly(@FormParam(value="a") String a, @FormParam(value="c") String c) {
        String result = "a -> " + a + "\n";
        if (c != null) {
            result = result + "c -> " + c + "\n";
        }
        return result;
    }

    @Path(value="formAndParam")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    public Object formAndParam(final MultivaluedMap<String, String> form, final @FormParam(value="a") String a) {
        return new StreamingOutput(){

            public void write(OutputStream out) throws IOException {
                out.write("a -> ".getBytes());
                out.write(a.getBytes());
                out.write(10);
                for (String key : new TreeSet(form.keySet())) {
                    if (key.equals("a")) continue;
                    for (String value : (List)form.get((Object)key)) {
                        out.write(key.getBytes());
                        out.write(" -> ".getBytes());
                        out.write(value.getBytes());
                        out.write(10);
                    }
                }
            }
        };
    }

    @Path(value="paramAndForm")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    public Object paramAndForm(final @FormParam(value="a") String a, final MultivaluedMap<String, String> form) {
        return new StreamingOutput(){

            public void write(OutputStream out) throws IOException {
                out.write("a -> ".getBytes());
                out.write(a.getBytes());
                out.write(10);
                for (String key : new TreeSet(form.keySet())) {
                    if (key.equals("a")) continue;
                    for (String value : (List)form.get((Object)key)) {
                        out.write(key.getBytes());
                        out.write(" -> ".getBytes());
                        out.write(value.getBytes());
                        out.write(10);
                    }
                }
            }
        };
    }

    @Path(value="checkUnmodifiable")
    @POST
    @Produces(value={"text/plain"})
    public Object checkUnmodifiable(@FormParam(value="a") List<String> as) {
        try {
            as.clear();
            throw new WebApplicationException(Response.serverError().entity((Object)"the List must be unmodifiable").build());
        }
        catch (UnsupportedOperationException uoe) {
            return null;
        }
    }
}

