/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.services.resources;

import java.util.List;
import java.util.Map;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

@Path(value="/skjflsfh")
public class HttpHeaderTestService {
    public static final String TEST_HEADER_NAME = "testHeader";

    @GET
    @Path(value="accMediaTypes")
    @Produces(value={"text/plain"})
    public String getAccMediaTypes(@Context HttpHeaders headers) {
        List mediaTypes = headers.getAcceptableMediaTypes();
        return mediaTypes.toString();
    }

    @GET
    @Path(value="cookies/{cookieName}")
    @Produces(value={"text/plain"})
    public String getCookies(@Context HttpHeaders headers, @PathParam(value="cookieName") String cookieName) {
        Map cookies = headers.getCookies();
        try {
            cookies.put("notAllowed", new Cookie("notAllowed", "value"));
            throw new WebApplicationException(Response.serverError().entity((Object)"could add cookie notAllowed").build());
        }
        catch (UnsupportedOperationException uoe) {
            try {
                cookies.put("xyz", new Cookie("notAllowed", "value"));
                throw new WebApplicationException(Response.serverError().entity((Object)"could add xyz").build());
            }
            catch (UnsupportedOperationException uoe2) {
                Cookie cookie = (Cookie)cookies.get(cookieName);
                if (cookie == null) {
                    return null;
                }
                return cookie.toString();
            }
        }
    }

    @GET
    @Path(value="header/{headername}")
    @Produces(value={"text/plain"})
    public String getHeader(@Context HttpHeaders headers, @PathParam(value="headername") String headername) {
        MultivaluedMap requestHeaders = headers.getRequestHeaders();
        String headerValue = (String)requestHeaders.getFirst((Object)headername);
        return headerValue;
    }

    @GET
    @Path(value="header2")
    @Produces(value={"text/plain"})
    public Object getHeader2(@HeaderParam(value="host") String hostLower, @HeaderParam(value="HOST") String hostUpper, @HeaderParam(value="Host") String hostMixed) {
        if (hostLower.equals(hostUpper) && hostLower.equals(hostMixed)) {
            return hostMixed;
        }
        String hosts = "mixed: " + hostMixed + "\nupper: " + hostUpper + "\n lower: " + hostLower;
        return Response.serverError().entity((Object)hosts).build();
    }

    @GET
    @Path(value="HeaderParam")
    @Produces(value={"text/plain"})
    public String getHeaderParam(@HeaderParam(value="testHeader") String testHeaderValue) {
        return testHeaderValue;
    }

    @GET
    @Path(value="headerWithDefault")
    @Produces(value={"text/plain"})
    public String getHeaderWithDefault(@HeaderParam(value="testHeader") @DefaultValue(value="default") String testHeader) {
        return testHeader;
    }

    @POST
    @Path(value="language")
    @Produces(value={"text/plain", "text/html"})
    public String getLanguage(@Context HttpHeaders headers) {
        return headers.getLanguage().toString();
    }

    @GET
    @Produces(value={"text/plain"})
    public String getPlain() {
        return "media type text/plain is supported\n";
    }

    @GET
    @Produces(value={"text/xml", "application/xml"})
    public String getXML() {
        return "<text>the media types text/xml and application/xml are supported</text>\n";
    }
}

