/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.services.resources;

import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.GET;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.restlet.test.ext.jaxrs.util.TestUtils;

@Path(value="matrixParamTest")
public class MatrixParamTestService {
    private String encoded;
    private String decoded;

    @GET
    @Produces(value={"text/plain"})
    @Path(value="checkUnmodifiable")
    public Object checkUnmodifiable(@MatrixParam(value="mp") List<String> mps) {
        try {
            mps.clear();
            throw new WebApplicationException(Response.serverError().entity((Object)"the List must be unmodifiable").build());
        }
        catch (UnsupportedOperationException use) {
            return null;
        }
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="encoded")
    @Encoded
    public String encoded(@MatrixParam(value="firstname") String firstname, @MatrixParam(value="lastname") String lastname) {
        return firstname + " " + lastname;
    }

    @GET
    @Produces(value={"text/plain"})
    public String get(@MatrixParam(value="firstname") String firstname, @MatrixParam(value="lastname") String lastname) {
        return firstname + " " + lastname;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="a")
    public String getA(@MatrixParam(value="firstname") String firstname, @MatrixParam(value="lastname") String lastname) {
        return firstname + " " + lastname;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="allNames")
    public String getAllNames(@MatrixParam(value="name") List<String> name) {
        return name.toString();
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="b")
    public String getB(@Context UriInfo uriInfo) {
        PathSegment pSeg = (PathSegment)TestUtils.getLastElement(uriInfo.getPathSegments());
        String vorname = (String)pSeg.getMatrixParameters().getFirst((Object)"firstname");
        String nachname = (String)pSeg.getMatrixParameters().getFirst((Object)"lastname");
        return vorname + " " + nachname;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="one")
    public String getOne(@MatrixParam(value="name") String name) {
        if (name == null) {
            return "[null]";
        }
        if (name.equals("")) {
            return "[empty]";
        }
        return name;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="setterDecoded")
    public String getSetterDecoded() {
        return this.decoded;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="setterEncoded")
    public String getSetterEncoded() {
        return this.encoded;
    }

    @Path(value="sub")
    public MatrixParamTestService getSub() {
        return new MatrixParamTestService();
    }

    @MatrixParam(value="decoded")
    public void setDecoded(String decoded) {
        this.decoded = decoded;
    }

    @Encoded
    @MatrixParam(value="encoded")
    public void setEncoded(String encoded) {
        this.encoded = encoded;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="withDefault")
    @Encoded
    public String withDefault(@MatrixParam(value="mp") @DefaultValue(value="default") String mp) {
        return this.withoutDefault(mp);
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="withoutDefault")
    @Encoded
    public String withoutDefault(@MatrixParam(value="mp") String mp) {
        if (mp == null) {
            return "[null]";
        }
        if (mp.equals("")) {
            return "[empty]";
        }
        return mp;
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="semicolon;mpA=")
    public Response withSemicolon(@MatrixParam(value="mpA") String mpA, @MatrixParam(value="mpB") String mpB) {
        String entity = "this method must not be called\nmpA param is " + mpA + "\nmpB param is " + mpB;
        return Response.serverError().entity((Object)entity).build();
    }
}

