/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.test.ext.jaxrs.services.resources;

import java.net.URI;
import java.security.Principal;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

@Path(value="/SecurityContextTestService")
public class SecurityContextService {
    @Context
    private SecurityContext securityContext;

    @GET
    @Produces(value={"text/plain"})
    public String get() {
        if (!this.securityContext.isUserInRole("bad")) {
            throw new WebApplicationException(403);
        }
        return "das darfst Du";
    }

    @GET
    @Path(value="authenticationScheme")
    @Produces(value={"text/plain"})
    public String getAuthenticationScheme() {
        return this.securityContext.getAuthenticationScheme();
    }

    @GET
    @Path(value="userPrincipal")
    @Produces(value={"text/plain"})
    public String getUserPrincipal() {
        Principal principal = this.securityContext.getUserPrincipal();
        if (principal == null) {
            return "no principal found";
        }
        return principal.getName();
    }

    @GET
    @Path(value="secure")
    @Produces(value={"text/plain"})
    public String isSecure(@Context UriInfo uriInfo) {
        if (!this.securityContext.isSecure()) {
            Response.ResponseBuilder rb = Response.status((Response.Status)Response.Status.MOVED_PERMANENTLY);
            rb.entity((Object)"You must use a secure connection");
            rb.location(uriInfo.getRequestUriBuilder().scheme("https").build(new Object[0]));
            throw new WebApplicationException(rb.build());
        }
        return "wonderful! It's a secure request.";
    }

    @POST
    public Response post(MultivaluedMap<String, String> entity, @Context UriInfo uriInfo) {
        if (!this.securityContext.isUserInRole("bat")) {
            throw new WebApplicationException(403);
        }
        entity.toString();
        String id = "4711";
        URI collectionUri = uriInfo.getRequestUri();
        URI location = UriBuilder.fromUri((URI)collectionUri).path("{id}").build(new Object[]{"4711"});
        return Response.created((URI)location).build();
    }
}

